/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.ejb.deployment.archivist;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.annotation.introspection.AnnotationScanner;
import com.sun.enterprise.deployment.annotation.introspection.EjbComponentAnnotationScanner;
import com.sun.enterprise.deployment.archivist.Archivist;
import com.sun.enterprise.deployment.archivist.ArchivistFor;
import com.sun.enterprise.deployment.io.ConfigurationDeploymentDescriptorFile;
import com.sun.enterprise.deployment.io.DeploymentDescriptorFile;
import com.sun.enterprise.deployment.util.AnnotationDetector;
import com.sun.enterprise.deployment.util.DOLUtils;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import org.glassfish.api.deployment.archive.ArchiveType;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.deployment.common.DeploymentUtils;
import org.glassfish.ejb.deployment.archive.EjbType;
import org.glassfish.ejb.deployment.descriptor.EjbBundleDescriptorImpl;
import org.glassfish.ejb.deployment.io.EjbDeploymentDescriptorFile;
import org.glassfish.ejb.deployment.util.EjbBundleValidator;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceLocator;
import org.jvnet.hk2.annotations.Service;

@Service
@PerLookup
@ArchivistFor(value="ejb")
public class EjbArchivist
extends Archivist<EjbBundleDescriptorImpl> {
    @Inject
    private EjbType ejbType;

    public ArchiveType getModuleType() {
        return this.ejbType;
    }

    public void setDescriptor(Application descriptor) {
        Set ejbBundles = descriptor.getBundleDescriptors(EjbBundleDescriptorImpl.class);
        if (ejbBundles.size() > 0) {
            this.descriptor = (BundleDescriptor)ejbBundles.iterator().next();
            if (((EjbBundleDescriptorImpl)this.descriptor).getModuleDescriptor().isStandalone()) {
                return;
            }
            this.descriptor = null;
        }
    }

    public DeploymentDescriptorFile getStandardDDFile() {
        if (this.standardDD == null) {
            this.standardDD = new EjbDeploymentDescriptorFile();
        }
        return this.standardDD;
    }

    public List<ConfigurationDeploymentDescriptorFile> getConfigurationDDFiles() {
        if (this.confDDFiles == null) {
            this.confDDFiles = DOLUtils.getConfigurationDeploymentDescriptorFiles((ServiceLocator)this.habitat, (String)"ejb");
        }
        return this.confDDFiles;
    }

    public EjbBundleDescriptorImpl getDefaultBundleDescriptor() {
        return new EjbBundleDescriptorImpl();
    }

    protected void postOpen(EjbBundleDescriptorImpl descriptor, ReadableArchive archive) throws IOException {
        super.postOpen((BundleDescriptor)descriptor, archive);
        this.postValidate((BundleDescriptor)descriptor, archive);
    }

    public void validate(ClassLoader aClassLoader) {
        ClassLoader cl = aClassLoader;
        if (cl == null) {
            cl = this.classLoader;
        }
        if (cl == null) {
            return;
        }
        ((EjbBundleDescriptorImpl)this.descriptor).setClassLoader(cl);
        ((EjbBundleDescriptorImpl)this.descriptor).visit(new EjbBundleValidator());
    }

    protected String getArchiveExtension() {
        return ".jar";
    }

    protected boolean postHandles(ReadableArchive abstractArchive) throws IOException {
        AnnotationDetector detector = new AnnotationDetector((AnnotationScanner)new EjbComponentAnnotationScanner());
        return !DeploymentUtils.isArchiveOfType((ReadableArchive)abstractArchive, (ArchiveType)DOLUtils.warType(), (ServiceLocator)this.locator) && detector.hasAnnotationInArchiveWithNoScanning(abstractArchive);
    }
}

