/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.streaming;

import com.sun.xml.rpc.streaming.PrefixFactory;
import com.sun.xml.rpc.streaming.StAXReader;
import com.sun.xml.rpc.streaming.XMLWriterBase;
import com.sun.xml.rpc.streaming.XMLWriterException;
import com.sun.xml.rpc.util.exception.LocalizableExceptionAdapter;
import com.sun.xml.rpc.util.xml.CDATA;
import java.io.OutputStream;
import java.io.StringReader;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class StAXWriter
extends XMLWriterBase {
    private static final String XML_VERSION = "1.0";
    private XMLStreamWriter writer;
    private PrefixFactory prefixFactory;
    private boolean documentEnded = false;
    private static XMLOutputFactory outputFactory = null;

    public StAXWriter(OutputStream out, String enc, boolean declare) {
        try {
            if (outputFactory == null) {
                outputFactory = XMLOutputFactory.newInstance();
            }
            this.writer = outputFactory.createXMLStreamWriter(out, enc);
            if (declare) {
                this.writer.writeStartDocument(enc, XML_VERSION);
            }
        }
        catch (XMLStreamException e) {
            throw this.wrapException(e);
        }
    }

    public StAXWriter(OutputStream out, String enc, boolean declare, XMLStreamWriter writer) {
        try {
            this.writer = writer;
            if (declare) {
                writer.writeStartDocument(enc, XML_VERSION);
            }
        }
        catch (XMLStreamException e) {
            throw this.wrapException(e);
        }
    }

    public XMLStreamWriter getXMLStreamWriter() {
        return this.writer;
    }

    @Override
    public void startElement(String localName, String uri) {
        try {
            if (uri.equals("")) {
                this.writer.writeStartElement(localName);
            } else {
                boolean mustDeclarePrefix = false;
                String aPrefix = this.getPrefix(uri);
                if (aPrefix == null) {
                    aPrefix = this.prefixFactory.getPrefix(uri);
                    mustDeclarePrefix = true;
                }
                this.writer.writeStartElement(aPrefix, localName, uri);
                if (mustDeclarePrefix) {
                    this.writeNamespaceDeclaration(aPrefix, uri);
                }
            }
        }
        catch (XMLStreamException e) {
            throw this.wrapException(e);
        }
    }

    @Override
    public void startElement(String localName, String uri, String prefix) {
        try {
            if (uri.equals("")) {
                this.writer.writeStartElement(localName);
            } else {
                boolean mustDeclarePrefix = false;
                String other = this.writer.getPrefix(uri);
                if (other == null) {
                    mustDeclarePrefix = true;
                } else if (!other.equals(prefix)) {
                    mustDeclarePrefix = true;
                    this.writer.setPrefix(prefix, uri);
                }
                this.writer.writeStartElement(prefix, localName, uri);
                if (mustDeclarePrefix) {
                    this.writer.writeNamespace(prefix, uri);
                }
            }
        }
        catch (XMLStreamException e) {
            throw this.wrapException(e);
        }
    }

    @Override
    public void writeAttribute(String localName, String uri, String value) {
        try {
            if (uri.equals("")) {
                this.writer.writeAttribute(localName, value);
            } else {
                boolean mustDeclarePrefix = false;
                String aPrefix = this.getPrefix(uri);
                if (aPrefix == null) {
                    mustDeclarePrefix = true;
                    if (this.prefixFactory != null) {
                        aPrefix = this.prefixFactory.getPrefix(uri);
                    }
                    if (aPrefix == null) {
                        throw new XMLWriterException("xmlwriter.noPrefixForURI", uri);
                    }
                }
                this.writer.writeAttribute(aPrefix, uri, localName, value);
                if (mustDeclarePrefix) {
                    this.writeNamespaceDeclaration(aPrefix, uri);
                }
            }
        }
        catch (XMLStreamException e) {
            throw this.wrapException(e);
        }
    }

    @Override
    public void writeAttributeUnquoted(String localName, String uri, String value) {
        this.writeAttribute(localName, uri, value);
    }

    @Override
    public void writeChars(String chars) {
        try {
            this.writer.writeCharacters(chars);
        }
        catch (XMLStreamException e) {
            throw this.wrapException(e);
        }
    }

    @Override
    public void writeChars(CDATA chars) {
        this.writeChars(chars.getText());
    }

    @Override
    public void writeCharsUnquoted(String chars) {
        try {
            if (chars.charAt(0) == '<') {
                this.parseAndWriteXML(chars);
                return;
            }
            this.writer.writeCharacters(chars);
        }
        catch (XMLStreamException e) {
            throw this.wrapException(e);
        }
    }

    @Override
    public void writeCharsUnquoted(char[] buf, int offset, int len) {
        try {
            if (buf[offset] == '<') {
                this.parseAndWriteXML(new String(buf, offset, len));
                return;
            }
            this.writer.writeCharacters(buf, offset, len);
        }
        catch (XMLStreamException e) {
            throw this.wrapException(e);
        }
    }

    @Override
    public void writeComment(String comment) {
        try {
            this.writer.writeComment(comment);
        }
        catch (XMLStreamException e) {
            throw this.wrapException(e);
        }
    }

    @Override
    public void writeNamespaceDeclaration(String prefix, String uri) {
        try {
            this.writer.writeNamespace(prefix, uri);
            if (prefix == null || prefix.length() == 0 || prefix.equals("xmlns")) {
                this.writer.setDefaultNamespace(uri);
            } else {
                this.writer.setPrefix(prefix, uri);
            }
        }
        catch (XMLStreamException e) {
            throw this.wrapException(e);
        }
    }

    @Override
    public void writeNamespaceDeclaration(String uri) {
        try {
            String aPrefix = this.writer.getPrefix(uri);
            if (aPrefix == null) {
                if (this.prefixFactory == null) {
                    throw new XMLWriterException("xmlwriter.noPrefixForURI", uri);
                }
                aPrefix = this.prefixFactory.getPrefix(uri);
            }
            this.writeNamespaceDeclaration(aPrefix, uri);
        }
        catch (XMLStreamException e) {
            throw this.wrapException(e);
        }
    }

    @Override
    public void endElement() {
        try {
            this.writer.writeEndElement();
        }
        catch (XMLStreamException e) {
            throw this.wrapException(e);
        }
    }

    @Override
    public void close() {
        try {
            if (!this.documentEnded) {
                this.writer.writeEndDocument();
            }
            this.writer.close();
        }
        catch (XMLStreamException e) {
            throw this.wrapException(e);
        }
    }

    @Override
    public void flush() {
        try {
            this.writer.flush();
        }
        catch (XMLStreamException e) {
            throw this.wrapException(e);
        }
    }

    @Override
    public String getPrefix(String uri) {
        try {
            return this.writer.getPrefix(uri);
        }
        catch (XMLStreamException e) {
            throw this.wrapException(e);
        }
    }

    @Override
    public String getURI(String prefix) {
        return this.writer.getNamespaceContext().getNamespaceURI(prefix);
    }

    @Override
    public PrefixFactory getPrefixFactory() {
        return this.prefixFactory;
    }

    @Override
    public void setPrefixFactory(PrefixFactory factory) {
        this.prefixFactory = factory;
    }

    private void parseAndWriteXML(String xml) throws XMLStreamException {
        StAXReader reader = new StAXReader(new StringReader(xml), true);
        int state = 0;
        do {
            state = reader.next();
            switch (state) {
                case 1: {
                    QName elementName = reader.getName();
                    this.startElement(elementName.getLocalPart(), elementName.getNamespaceURI(), elementName.getPrefix());
                    break;
                }
                case 2: {
                    this.endElement();
                    break;
                }
                case 3: {
                    this.writeChars(reader.getValue());
                }
            }
        } while (state != 5);
    }

    private XMLWriterException wrapException(XMLStreamException e) {
        return new XMLWriterException("xmlwriter.ioException", new LocalizableExceptionAdapter(e));
    }
}

