/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.appclient.server.core.jws.servedcontent;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipOutputStream;
import org.glassfish.appclient.server.core.jws.AppClientHTTPAdapter;
import org.glassfish.appclient.server.core.jws.servedcontent.ASJarSigner;
import org.glassfish.appclient.server.core.jws.servedcontent.AutoSignedContent;
import org.glassfish.grizzly.http.server.Request;
import org.glassfish.grizzly.http.server.Response;
import org.glassfish.grizzly.http.server.Session;
import org.glassfish.grizzly.http.util.HttpStatus;
import org.glassfish.grizzly.http.util.MimeType;

public class StreamedAutoSignedStaticContent
extends AutoSignedContent {
    private static final String SIGNED_JNLP_PATH = "JNLP-INF/APPLICATION.JNLP";
    private static final Logger logger = Logger.getLogger("javax.enterprise.system.container.appclient", "org.glassfish.appclient.server.LogMessages");

    public StreamedAutoSignedStaticContent(File unsignedFile, String userProvidedAlias, ASJarSigner jarSigner, String relativeURI, String appName) throws FileNotFoundException {
        super(unsignedFile, null, userProvidedAlias, jarSigner, relativeURI, appName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(String relativeURIString, Request gReq, Response gResp) throws IOException {
        logger.log(Level.FINE, "Processing main JAR for {0}", gReq.getRequestURI());
        long now = System.currentTimeMillis();
        gResp.setDateHeader("Last-Modified", now);
        gResp.setDateHeader("Date", now);
        gResp.setStatus(HttpStatus.OK_200);
        gResp.setContentType(this.contentType(this.unsignedFile()));
        Session session = gReq.getSession();
        Object jwsObj = session.getAttribute("org.glassfish.jws.mainJNLP");
        if (jwsObj == null) {
            logger.log(Level.FINE, "Session {0} did not contain cached JNLP", session.getIdInternal());
            throw new NullPointerException();
        }
        if (!(jwsObj instanceof byte[])) {
            logger.log(Level.FINE, "Session {0} cached JNLP is not a byte[] as expected", session.getIdInternal());
            throw new IllegalArgumentException(jwsObj.getClass().toString());
        }
        ZipOutputStream zos = new ZipOutputStream(gResp.getOutputStream());
        logger.log(Level.FINE, "Request's session contains cached JNLP");
        byte[] jnlpContent = (byte[])jwsObj;
        HashMap<String, byte[]> addedContent = new HashMap<String, byte[]>();
        addedContent.put(SIGNED_JNLP_PATH, jnlpContent);
        try {
            this.jarSigner().signJar(this.unsignedFile(), zos, this.userProvidedAlias(), StreamedAutoSignedStaticContent.createJWSAttrs(AppClientHTTPAdapter.requestURI(gReq), this.appName()), addedContent);
            if (logger.isLoggable(Level.FINEST)) {
                File debugSignedJARFile = new File(this.unsignedFile().getAbsolutePath() + ".debug");
                try (ZipOutputStream dbgZos = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(debugSignedJARFile)));){
                    this.jarSigner().signJar(this.unsignedFile(), dbgZos, this.userProvidedAlias(), StreamedAutoSignedStaticContent.createJWSAttrs(AppClientHTTPAdapter.requestURI(gReq), this.appName()), addedContent);
                }
                logger.log(Level.FINEST, "Created on-disk signed JAR {0}", debugSignedJARFile.getAbsolutePath());
            }
            zos.close();
        }
        catch (IOException ioex) {
            throw ioex;
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
        finally {
            zos.close();
        }
    }

    @Override
    public boolean isAvailable(URI requestURI) throws IOException {
        return true;
    }

    private String contentType(File file) {
        String substr;
        String path = file.getPath();
        int dot = path.lastIndexOf(46);
        if (dot < 0) {
            substr = file.toString();
            dot = substr.lastIndexOf(46);
        } else {
            substr = path;
        }
        if (dot > 0) {
            String ext = substr.substring(dot + 1);
            String ct = MimeType.get((String)ext);
            return ct;
        }
        return MimeType.get((String)"html");
    }
}

