/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rx.mc.runtime;

import com.sun.istack.logging.Logger;
import com.sun.xml.ws.api.addressing.AddressingVersion;
import com.sun.xml.ws.api.addressing.WSEndpointReference;
import com.sun.xml.ws.api.message.Header;
import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.api.message.MessageHeaders;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.pipe.Fiber;
import com.sun.xml.ws.api.pipe.NextAction;
import com.sun.xml.ws.api.pipe.Tube;
import com.sun.xml.ws.api.pipe.TubeCloner;
import com.sun.xml.ws.api.pipe.helper.AbstractFilterTubeImpl;
import com.sun.xml.ws.api.pipe.helper.AbstractTubeImpl;
import com.sun.xml.ws.api.server.Container;
import com.sun.xml.ws.rx.RxRuntimeException;
import com.sun.xml.ws.rx.mc.dev.ProtocolMessageHandler;
import com.sun.xml.ws.rx.mc.dev.WsmcRuntimeProvider;
import com.sun.xml.ws.rx.mc.localization.LocalizationMessages;
import com.sun.xml.ws.rx.mc.runtime.MakeConnectionSenderTask;
import com.sun.xml.ws.rx.mc.runtime.McConfiguration;
import com.sun.xml.ws.rx.mc.runtime.McResponseHandlerBase;
import com.sun.xml.ws.rx.mc.runtime.OneWayMepHandler;
import com.sun.xml.ws.rx.mc.runtime.RequestResponseMepHandler;
import com.sun.xml.ws.rx.util.Communicator;
import com.sun.xml.ws.rx.util.SuspendedFiberStorage;
import java.util.UUID;
import javax.xml.stream.XMLStreamException;

public class McClientTube
extends AbstractFilterTubeImpl
implements WsmcRuntimeProvider {
    private static final Logger LOGGER = Logger.getLogger(McClientTube.class);
    private final McConfiguration configuration;
    private final Header wsmcAnnonymousReplyToHeader;
    private final Header wsmcAnnonymousFaultToHeader;
    private final Communicator communicator;
    private final SuspendedFiberStorage suspendedFiberStorage;
    private final MakeConnectionSenderTask mcSenderTask;
    private final WSEndpointReference wsmcAnonymousEndpointReference;

    McClientTube(McConfiguration configuration, Tube tubelineHead, Container container) throws RxRuntimeException {
        super(tubelineHead);
        this.configuration = configuration;
        this.communicator = Communicator.builder("mc-client-tube-communicator").tubelineHead(this.next).addressingVersion(configuration.getAddressingVersion()).soapVersion(configuration.getSoapVersion()).jaxbContext(configuration.getRuntimeVersion().getJaxbContext(configuration.getAddressingVersion())).container(container).build();
        String wsmcAnonymousAddress = configuration.getRuntimeVersion().getAnonymousAddress(UUID.randomUUID().toString());
        this.wsmcAnonymousEndpointReference = new WSEndpointReference(wsmcAnonymousAddress, configuration.getAddressingVersion());
        this.wsmcAnnonymousReplyToHeader = this.wsmcAnonymousEndpointReference.createHeader(configuration.getAddressingVersion().replyToTag);
        this.wsmcAnnonymousFaultToHeader = this.wsmcAnonymousEndpointReference.createHeader(configuration.getAddressingVersion().faultToTag);
        this.suspendedFiberStorage = new SuspendedFiberStorage();
        this.mcSenderTask = new MakeConnectionSenderTask(this.communicator, this.suspendedFiberStorage, wsmcAnonymousAddress, this.wsmcAnnonymousReplyToHeader, this.wsmcAnnonymousFaultToHeader, configuration);
    }

    McClientTube(McClientTube original, TubeCloner cloner) {
        super(original, cloner);
        this.configuration = original.configuration;
        this.wsmcAnnonymousReplyToHeader = original.wsmcAnnonymousReplyToHeader;
        this.wsmcAnnonymousFaultToHeader = original.wsmcAnnonymousFaultToHeader;
        this.communicator = original.communicator;
        this.suspendedFiberStorage = original.suspendedFiberStorage;
        this.mcSenderTask = original.mcSenderTask;
        this.wsmcAnonymousEndpointReference = original.wsmcAnonymousEndpointReference;
    }

    @Override
    public AbstractTubeImpl copy(TubeCloner cloner) {
        LOGGER.entering();
        try {
            McClientTube mcClientTube = new McClientTube(this, cloner);
            return mcClientTube;
        }
        finally {
            LOGGER.exiting();
        }
    }

    @Override
    public NextAction processRequest(Packet request) {
        Message message;
        if (!this.mcSenderTask.isRunning() && !this.mcSenderTask.wasShutdown()) {
            this.communicator.setDestinationAddressFrom(request);
            this.mcSenderTask.start();
        }
        if (!(message = request.getMessage()).hasHeaders()) {
            throw (RxRuntimeException)((Object)LOGGER.logSevereException((Throwable)((Object)new RxRuntimeException(LocalizationMessages.WSMC_0102_NO_SOAP_HEADERS()))));
        }
        if (this.needToSetWsmcAnnonymousHeaders(request)) {
            McClientTube.setMcAnnonymousHeaders(message.getHeaders(), this.configuration.getAddressingVersion(), this.wsmcAnnonymousReplyToHeader, this.wsmcAnnonymousFaultToHeader);
            String correlationId = message.getID(this.configuration.getAddressingVersion(), this.configuration.getSoapVersion());
            McResponseHandlerBase responseHandler = request.expectReply != null && request.expectReply != false ? new RequestResponseMepHandler(this.configuration, this.mcSenderTask, this.suspendedFiberStorage, correlationId) : new OneWayMepHandler(this.configuration, this.mcSenderTask, this.suspendedFiberStorage, correlationId);
            this.suspendedFiberStorage.register(correlationId, Fiber.current());
            this.communicator.sendAsync(request, responseHandler);
            return super.doSuspend();
        }
        return super.processRequest(request);
    }

    @Override
    public NextAction processResponse(Packet response) {
        return super.processResponse(response);
    }

    @Override
    public NextAction processException(Throwable t) {
        return super.processException(t);
    }

    @Override
    public void preDestroy() {
        this.mcSenderTask.shutdown();
        this.communicator.close();
        super.preDestroy();
    }

    @Override
    public final WSEndpointReference getWsmcAnonymousEndpointReference() {
        return this.wsmcAnonymousEndpointReference;
    }

    @Override
    public final void registerProtocolMessageHandler(ProtocolMessageHandler handler) {
        this.mcSenderTask.register(handler);
    }

    private boolean needToSetWsmcAnnonymousHeaders(Packet request) {
        Header replyToHeader = request.getMessage().getHeaders().get(this.configuration.getAddressingVersion().replyToTag, false);
        if (replyToHeader != null) {
            try {
                return replyToHeader.readAsEPR(this.configuration.getAddressingVersion()).isAnonymous();
            }
            catch (XMLStreamException ex) {
                throw (RxRuntimeException)((Object)LOGGER.logSevereException((Throwable)((Object)new RxRuntimeException(LocalizationMessages.WSMC_0103_ERROR_RETRIEVING_WSA_REPLYTO_CONTENT(), ex))));
            }
        }
        return this.isBooleanFlagSet(request, McConfiguration.ACK_REQUESTED_HEADER_SET);
    }

    static void setMcAnnonymousHeaders(MessageHeaders headers, AddressingVersion av, Header wsmcReplyToHeader, Header wsmcFaultToHeader) {
        headers.remove(av.replyToTag);
        headers.add(wsmcReplyToHeader);
        if (headers.remove(av.faultToTag) != null) {
            headers.add(wsmcFaultToHeader);
        }
    }

    private Boolean isBooleanFlagSet(Packet packet, String flag) {
        Boolean value = (Boolean)Boolean.class.cast(packet.invocationProperties.get(flag));
        return value != null && value != false;
    }
}

