/*
 * Decompiled with CFR 0.152.
 */
package jdk.incubator.http;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Optional;
import java.util.function.Consumer;
import jdk.incubator.http.HttpClientImpl;
import jdk.incubator.http.HttpConnection;
import jdk.incubator.http.HttpResponse;
import jdk.incubator.http.ResponseHeaders;
import jdk.incubator.http.internal.common.Utils;

class ResponseContent {
    final HttpResponse.BodyProcessor<?> pusher;
    final HttpConnection connection;
    final int contentLength;
    ByteBuffer buffer;
    final ResponseHeaders headers;
    private final Consumer<Optional<ByteBuffer>> dataConsumer;
    private final Consumer<IOException> errorConsumer;
    private final HttpClientImpl client;
    private final Runnable onFinished;
    static final int LF = 10;
    static final int CR = 13;
    static final int SP = 32;
    static final int BUF_SIZE = 1024;
    boolean chunkedContent;
    boolean chunkedContentInitialized;
    int chunklen = -1;
    int bytesremaining;
    int bytesread;
    ByteBuffer chunkbuf;
    ByteBuffer initialBuffer;
    int fixedBytesReturned;

    ResponseContent(HttpConnection httpConnection, int n, ResponseHeaders responseHeaders, HttpResponse.BodyProcessor<?> bodyProcessor, Consumer<Optional<ByteBuffer>> consumer, Consumer<IOException> consumer2, Runnable runnable) {
        this.pusher = bodyProcessor;
        this.connection = httpConnection;
        this.contentLength = n;
        this.headers = responseHeaders;
        this.dataConsumer = consumer;
        this.errorConsumer = consumer2;
        this.client = httpConnection.client;
        this.onFinished = runnable;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean contentChunked() throws IOException {
        if (this.chunkedContentInitialized) {
            return this.chunkedContent;
        }
        if (this.contentLength == -1) {
            String string = this.headers.firstValue("Transfer-Encoding").orElse("");
            if (!string.equals("")) {
                if (!string.equalsIgnoreCase("chunked")) throw new IOException("invalid content");
                this.chunkedContent = true;
            } else {
                this.chunkedContent = false;
            }
        }
        this.chunkedContentInitialized = true;
        return this.chunkedContent;
    }

    void pushBody(ByteBuffer byteBuffer) {
        try {
            if (this.contentChunked()) {
                this.pushBodyChunked(byteBuffer);
            } else {
                this.pushBodyFixed(byteBuffer);
            }
        }
        catch (IOException iOException) {
            this.errorConsumer.accept(iOException);
        }
    }

    int readChunkLen() throws IOException {
        this.chunklen = 0;
        boolean bl = false;
        while (true) {
            this.getHunk();
            byte by = this.chunkbuf.get();
            if (bl) {
                if (by == 10) {
                    return this.chunklen + 2;
                }
                throw new IOException("invalid chunk header");
            }
            if (by == 13) {
                bl = true;
                continue;
            }
            int n = this.toDigit(by);
            this.chunklen = this.chunklen * 16 + n;
        }
    }

    private void getHunk() throws IOException {
        if (this.chunkbuf == null || !this.chunkbuf.hasRemaining()) {
            this.chunkbuf = this.connection.read();
        }
    }

    private void consumeBytes(int n) throws IOException {
        this.getHunk();
        while (n > 0) {
            int n2 = Math.min(this.chunkbuf.remaining(), n);
            this.chunkbuf.position(this.chunkbuf.position() + n2);
            if ((n -= n2) <= 0) continue;
            this.getHunk();
        }
    }

    ByteBuffer readChunkedBuffer() throws IOException {
        if (this.chunklen == -1) {
            this.bytesremaining = this.chunklen = this.readChunkLen() - 2;
            if (this.chunklen == 0) {
                this.consumeBytes(2);
                return null;
            }
        }
        this.getHunk();
        this.bytesread = this.chunkbuf.remaining();
        ByteBuffer byteBuffer = Utils.getBuffer();
        int n = byteBuffer.remaining();
        int n2 = Math.min(this.bytesread, Math.min(this.bytesremaining, n));
        Utils.copy(this.chunkbuf, byteBuffer, n2);
        byteBuffer.flip();
        this.bytesremaining -= n2;
        if (this.bytesremaining == 0) {
            this.consumeBytes(2);
            this.chunklen = -1;
        }
        return byteBuffer;
    }

    private void compactBuffer(ByteBuffer byteBuffer) {
        byteBuffer.compact().flip();
    }

    private ByteBuffer copyBuffer(ByteBuffer byteBuffer, int n) {
        ByteBuffer byteBuffer2 = Utils.getBuffer();
        assert (byteBuffer2.remaining() >= n);
        byte[] byArray = byteBuffer2.array();
        byteBuffer.get(byArray, 0, n);
        byteBuffer2.limit(n);
        return byteBuffer2;
    }

    private void pushBodyChunked(ByteBuffer byteBuffer) throws IOException {
        ByteBuffer byteBuffer2;
        this.chunkbuf = byteBuffer;
        while ((byteBuffer2 = this.readChunkedBuffer()) != null) {
            if (!byteBuffer2.hasRemaining()) continue;
            this.dataConsumer.accept(Optional.of(byteBuffer2));
        }
        this.onFinished.run();
        this.dataConsumer.accept(Optional.empty());
    }

    private int toDigit(int n) throws IOException {
        if (n >= 48 && n <= 57) {
            return n - 48;
        }
        if (n >= 65 && n <= 70) {
            return n - 65 + 10;
        }
        if (n >= 97 && n <= 102) {
            return n - 97 + 10;
        }
        throw new IOException("Invalid chunk header byte " + n);
    }

    private void pushBodyFixed(ByteBuffer byteBuffer) throws IOException {
        ByteBuffer byteBuffer2;
        int n;
        int n2;
        for (n = this.contentLength; byteBuffer.hasRemaining() && n > 0; n -= n2) {
            byteBuffer2 = Utils.getBuffer();
            n2 = Math.min(byteBuffer.remaining(), n);
            Utils.copy(byteBuffer, byteBuffer2, n2);
            byteBuffer2.flip();
            this.dataConsumer.accept(Optional.of(byteBuffer2));
        }
        while (n > 0) {
            byteBuffer2 = this.connection.read();
            if (byteBuffer2 == null) {
                throw new IOException("connection closed");
            }
            n2 = byteBuffer2.remaining();
            if (n2 > n) {
                throw new IOException("too many bytes read");
            }
            n -= n2;
            this.dataConsumer.accept(Optional.of(byteBuffer2));
        }
        this.onFinished.run();
        this.dataConsumer.accept(Optional.empty());
    }
}

