/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.catalina.Context;
import org.apache.catalina.Manager;
import org.apache.catalina.Session;
import org.apache.catalina.session.BaseSessionLocker;
import org.apache.catalina.session.StandardSession;

public class PESessionLocker
extends BaseSessionLocker {
    public PESessionLocker() {
    }

    public PESessionLocker(Context ctx) {
        this();
        this._context = ctx;
    }

    public boolean lockSession(ServletRequest request) throws ServletException {
        boolean result = false;
        Session sess = this.getSession(request);
        if (sess != null) {
            long pollTime = 200L;
            int maxNumberOfRetries = 7;
            int tryNumber = 0;
            boolean keepTrying = true;
            boolean lockResult = false;
            while (keepTrying) {
                lockResult = sess.lockForeground();
                if (lockResult) {
                    keepTrying = false;
                    result = true;
                    break;
                }
                if (++tryNumber < maxNumberOfRetries) {
                    this.threadSleep(pollTime *= 2L);
                    continue;
                }
                if (!(sess instanceof StandardSession)) continue;
                ((StandardSession)sess).unlockBackground();
            }
        }
        return result;
    }

    private Session getSession(ServletRequest request) {
        HttpServletRequest httpReq = (HttpServletRequest)request;
        HttpSession httpSess = httpReq.getSession(false);
        if (httpSess == null) {
            return null;
        }
        String id = httpSess.getId();
        Manager mgr = this._context.getManager();
        Session sess = null;
        try {
            sess = mgr.findSession(id);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return sess;
    }

    protected void threadSleep(long sleepTime) {
        try {
            Thread.sleep(sleepTime);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void unlockSession(ServletRequest request) {
        Session sess = this.getSession(request);
        if (sess != null) {
            sess.unlockForeground();
        }
    }
}

