/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.deployment.annotation.handlers;

import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.annotation.context.WebBundleContext;
import com.sun.enterprise.deployment.annotation.context.WebComponentContext;
import com.sun.enterprise.deployment.web.AppListenerDescriptor;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.logging.Level;
import javax.servlet.ServletContextAttributeListener;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletRequestAttributeListener;
import javax.servlet.ServletRequestListener;
import javax.servlet.annotation.WebListener;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionIdListener;
import javax.servlet.http.HttpSessionListener;
import org.glassfish.apf.AnnotationHandlerFor;
import org.glassfish.apf.AnnotationInfo;
import org.glassfish.apf.AnnotationProcessorException;
import org.glassfish.apf.HandlerProcessingResult;
import org.glassfish.web.deployment.annotation.handlers.AbstractWebHandler;
import org.glassfish.web.deployment.annotation.handlers.WebFilterHandler;
import org.glassfish.web.deployment.descriptor.AppListenerDescriptorImpl;
import org.jvnet.hk2.annotations.Service;

@Service
@AnnotationHandlerFor(value=WebListener.class)
public class WebListenerHandler
extends AbstractWebHandler {
    protected static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(WebFilterHandler.class);

    @Override
    protected HandlerProcessingResult processAnnotation(AnnotationInfo ainfo, WebComponentContext[] webCompContexts) throws AnnotationProcessorException {
        return this.processAnnotation(ainfo, webCompContexts[0].getDescriptor().getWebBundleDescriptor());
    }

    @Override
    protected HandlerProcessingResult processAnnotation(AnnotationInfo ainfo, WebBundleContext webBundleContext) throws AnnotationProcessorException {
        return this.processAnnotation(ainfo, webBundleContext.getDescriptor());
    }

    private HandlerProcessingResult processAnnotation(AnnotationInfo ainfo, WebBundleDescriptor webBundleDesc) throws AnnotationProcessorException {
        Class listenerClass = (Class)ainfo.getAnnotatedElement();
        if (!(ServletContextListener.class.isAssignableFrom(listenerClass) || ServletContextAttributeListener.class.isAssignableFrom(listenerClass) || ServletRequestListener.class.isAssignableFrom(listenerClass) || ServletRequestAttributeListener.class.isAssignableFrom(listenerClass) || HttpSessionListener.class.isAssignableFrom(listenerClass) || HttpSessionAttributeListener.class.isAssignableFrom(listenerClass) || HttpSessionIdListener.class.isAssignableFrom(listenerClass))) {
            this.log(Level.SEVERE, ainfo, localStrings.getLocalString("web.deployment.annotation.handlers.needtoimpllistenerinterface", "The Class {0} having annotation javax.servlet.annotation.WebListener need to implement one of the following interfaces: javax.servlet.ServletContextLisener, javax.servlet.ServletContextAttributeListener, javax.servlet.ServletRequestListener, javax.servletServletRequestAttributeListener, javax.servlet.http.HttpSessionListener, javax.servlet.http.HttpSessionAttributeListener, javax.servlet.http.HttpSessionIdListener.", new Object[]{listenerClass.getName()}));
            return this.getDefaultFailedResult();
        }
        WebListener listenerAn = (WebListener)ainfo.getAnnotation();
        AppListenerDescriptorImpl appListener = new AppListenerDescriptorImpl(listenerClass.getName());
        appListener.setDescription(listenerAn.value());
        webBundleDesc.addAppListenerDescriptor((AppListenerDescriptor)appListener);
        return this.getDefaultProcessedResult();
    }
}

