/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http2;

import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.http2.Http2Stream;
import org.glassfish.grizzly.http2.Http2StreamException;
import org.glassfish.grizzly.http2.frames.ErrorCode;
import org.glassfish.grizzly.memory.Buffers;

abstract class Source {
    Source() {
    }

    public abstract int remaining();

    public abstract Buffer read(int var1) throws Http2StreamException;

    public abstract boolean hasRemaining();

    public abstract void release();

    public static SourceFactory factory(Http2Stream http2Stream) {
        return new SourceFactory(http2Stream);
    }

    public static final class SourceFactory {
        private final Http2Stream stream;

        private SourceFactory(Http2Stream stream) {
            this.stream = stream;
        }

        public Source createBufferSource(Buffer buffer) {
            return new BufferSource(buffer, this.stream);
        }

        private static class BufferSource
        extends Source {
            private boolean isClosed;
            private Buffer buffer;
            private final Http2Stream stream;

            protected BufferSource(Buffer buffer, Http2Stream stream) {
                this.buffer = buffer;
                this.stream = stream;
            }

            @Override
            public int remaining() {
                return this.buffer.remaining();
            }

            @Override
            public Buffer read(int length) throws Http2StreamException {
                if (this.isClosed) {
                    throw new Http2StreamException(this.stream.getId(), ErrorCode.INTERNAL_ERROR, "The source was closed");
                }
                int remaining = this.buffer.remaining();
                if (length == 0 || remaining == 0) {
                    return Buffers.EMPTY_BUFFER;
                }
                int bytesToSplit = Math.min(remaining, length);
                Buffer newBuf = this.buffer.split(this.buffer.position() + bytesToSplit);
                Buffer bufferToReturn = this.buffer;
                this.buffer = newBuf;
                return bufferToReturn;
            }

            @Override
            public boolean hasRemaining() {
                return !this.isClosed && this.buffer.hasRemaining();
            }

            @Override
            public void release() {
                if (!this.isClosed) {
                    this.isClosed = true;
                    this.buffer.tryDispose();
                }
            }
        }
    }
}

