/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql;

import org.eclipse.persistence.jpa.jpql.AbstractEclipseLinkSemanticValidator;
import org.eclipse.persistence.jpa.jpql.AbstractGrammarValidator;
import org.eclipse.persistence.jpa.jpql.AbstractValidator;
import org.eclipse.persistence.jpa.jpql.EclipseLinkLiteralVisitor;
import org.eclipse.persistence.jpa.jpql.EclipseLinkVersion;
import org.eclipse.persistence.jpa.jpql.LiteralVisitor;
import org.eclipse.persistence.jpa.jpql.parser.AbstractEclipseLinkExpressionVisitor;
import org.eclipse.persistence.jpa.jpql.parser.AbstractExpression;
import org.eclipse.persistence.jpa.jpql.parser.AbstractSelectClause;
import org.eclipse.persistence.jpa.jpql.parser.AsOfClause;
import org.eclipse.persistence.jpa.jpql.parser.CastExpression;
import org.eclipse.persistence.jpa.jpql.parser.ConnectByClause;
import org.eclipse.persistence.jpa.jpql.parser.DatabaseType;
import org.eclipse.persistence.jpa.jpql.parser.EclipseLinkExpressionVisitor;
import org.eclipse.persistence.jpa.jpql.parser.Expression;
import org.eclipse.persistence.jpa.jpql.parser.ExtractExpression;
import org.eclipse.persistence.jpa.jpql.parser.HierarchicalQueryClause;
import org.eclipse.persistence.jpa.jpql.parser.InExpression;
import org.eclipse.persistence.jpa.jpql.parser.InputParameter;
import org.eclipse.persistence.jpa.jpql.parser.JPQLGrammar;
import org.eclipse.persistence.jpa.jpql.parser.OrderSiblingsByClause;
import org.eclipse.persistence.jpa.jpql.parser.RegexpExpression;
import org.eclipse.persistence.jpa.jpql.parser.SimpleSelectClause;
import org.eclipse.persistence.jpa.jpql.parser.SimpleSelectStatement;
import org.eclipse.persistence.jpa.jpql.parser.StartWithClause;
import org.eclipse.persistence.jpa.jpql.parser.TableExpression;
import org.eclipse.persistence.jpa.jpql.parser.TableVariableDeclaration;
import org.eclipse.persistence.jpa.jpql.parser.UnionClause;

public class EclipseLinkGrammarValidator
extends AbstractGrammarValidator
implements EclipseLinkExpressionVisitor {
    private InExpressionVisitor inExpressionVisitor;
    private InExpressionWithNestedArrayVisitor inExpressionWithNestedArrayVisitor;

    public EclipseLinkGrammarValidator(JPQLGrammar jpqlGrammar) {
        super(jpqlGrammar);
    }

    protected AbstractGrammarValidator.AbstractSingleEncapsulatedExpressionHelper<CastExpression> buildCastExpressionHelper() {
        return new AbstractGrammarValidator.AbstractSingleEncapsulatedExpressionHelper<CastExpression>((AbstractGrammarValidator)this){

            @Override
            protected String encapsulatedExpressionInvalidKey(CastExpression expression) {
                return "CAST_EXPRESSION_INVALID_EXPRESSION";
            }

            @Override
            protected String encapsulatedExpressionMissingKey(CastExpression expression) {
                return "CAST_EXPRESSION_MISSING_EXPRESSION";
            }

            @Override
            public String leftParenthesisMissingKey(CastExpression expression) {
                return "CAST_EXPRESSION_MISSING_LEFT_PARENTHESIS";
            }

            @Override
            public String rightParenthesisMissingKey(CastExpression expression) {
                return "CAST_EXPRESSION_MISSING_RIGHT_PARENTHESIS";
            }
        };
    }

    protected AbstractGrammarValidator.AbstractDoubleEncapsulatedExpressionHelper<DatabaseType> buildDatabaseTypeHelper() {
        return new AbstractGrammarValidator.AbstractDoubleEncapsulatedExpressionHelper<DatabaseType>((AbstractGrammarValidator)this){

            @Override
            protected String firstExpressionInvalidKey() {
                return "DATABASE_TYPE_INVALID_FIRST_EXPRESSION";
            }

            @Override
            protected String firstExpressionMissingKey() {
                return "DATABASE_TYPE_MISSING_FIRST_EXPRESSION";
            }

            @Override
            protected boolean hasComma(DatabaseType expression) {
                return expression.hasComma() || !expression.hasSecondExpression();
            }

            @Override
            protected boolean hasFirstExpression(DatabaseType expression) {
                return !expression.hasLeftParenthesis() || expression.hasFirstExpression();
            }

            @Override
            public boolean hasLeftParenthesis(DatabaseType expression) {
                if (expression.hasLeftParenthesis()) {
                    return true;
                }
                return !expression.hasFirstExpression() && !expression.hasComma() && !expression.hasSecondExpression() && !expression.hasRightParenthesis();
            }

            @Override
            public boolean hasRightParenthesis(DatabaseType expression) {
                if (expression.hasRightParenthesis()) {
                    return true;
                }
                return !expression.hasLeftParenthesis() && !expression.hasFirstExpression() && !expression.hasComma() && !expression.hasSecondExpression();
            }

            @Override
            protected boolean hasSecondExpression(DatabaseType expression) {
                return !expression.hasComma() || expression.hasSecondExpression();
            }

            @Override
            public String leftParenthesisMissingKey(DatabaseType expression) {
                return "DATABASE_TYPE_MISSING_LEFT_PARENTHESIS";
            }

            @Override
            protected String missingCommaKey() {
                return "DATABASE_TYPE_MISSING_COMMA";
            }

            @Override
            public String rightParenthesisMissingKey(DatabaseType expression) {
                return "DATABASE_TYPE_MISSING_RIGHT_PARENTHESIS";
            }

            @Override
            protected String secondExpressionInvalidKey() {
                return "DATABASE_TYPE_INVALID_SECOND_EXPRESSION";
            }

            @Override
            protected String secondExpressionMissingKey() {
                return "DATABASE_TYPE_MISSING_SECOND_EXPRESSION";
            }
        };
    }

    protected AbstractGrammarValidator.AbstractSingleEncapsulatedExpressionHelper<ExtractExpression> buildExtractExpressionHelper() {
        return new AbstractGrammarValidator.AbstractSingleEncapsulatedExpressionHelper<ExtractExpression>((AbstractGrammarValidator)this){

            @Override
            protected String encapsulatedExpressionInvalidKey(ExtractExpression expression) {
                return "EXTRACT_EXPRESSION_INVALID_EXPRESSION";
            }

            @Override
            protected String encapsulatedExpressionMissingKey(ExtractExpression expression) {
                return "EXTRACT_EXPRESSION_MISSING_DATE_PART";
            }

            @Override
            public String leftParenthesisMissingKey(ExtractExpression expression) {
                return "EXTRACT_EXPRESSION_MISSING_LEFT_PARENTHESIS";
            }

            @Override
            protected int lengthBeforeEncapsulatedExpression(ExtractExpression expression) {
                return expression.getDatePart().length() + (expression.hasSpaceAfterDatePart() ? 1 : 0) + (expression.hasFrom() ? 4 : 0) + (expression.hasSpaceAfterFrom() ? 1 : 0);
            }

            @Override
            public String rightParenthesisMissingKey(ExtractExpression expression) {
                return "EXTRACT_EXPRESSION_MISSING_RIGHT_PARENTHESIS";
            }
        };
    }

    protected InExpressionVisitor buildInExpressionVisitor() {
        return new InExpressionVisitor();
    }

    protected InExpressionWithNestedArrayVisitor buildInExpressionWithNestedArrayVisitor() {
        return new InExpressionWithNestedArrayVisitor(this);
    }

    @Override
    protected LiteralVisitor buildLiteralVisitor() {
        return new EclipseLinkLiteralVisitor();
    }

    @Override
    protected AbstractValidator.OwningClauseVisitor buildOwningClauseVisitor() {
        return new AbstractEclipseLinkSemanticValidator.EclipseLinkOwningClauseVisitor();
    }

    protected AbstractGrammarValidator.AbstractSingleEncapsulatedExpressionHelper<TableExpression> buildTableExpressionHelper() {
        return new AbstractGrammarValidator.AbstractSingleEncapsulatedExpressionHelper<TableExpression>((AbstractGrammarValidator)this){

            @Override
            protected String encapsulatedExpressionInvalidKey(TableExpression expression) {
                return "TABLE_EXPRESSION_INVALID_EXPRESSION";
            }

            @Override
            protected String encapsulatedExpressionMissingKey(TableExpression expression) {
                return "TABLE_EXPRESSION_MISSING_EXPRESSION";
            }

            @Override
            public String leftParenthesisMissingKey(TableExpression expression) {
                return "TABLE_EXPRESSION_MISSING_LEFT_PARENTHESIS";
            }

            @Override
            public String rightParenthesisMissingKey(TableExpression expression) {
                return "TABLE_EXPRESSION_MISSING_RIGHT_PARENTHESIS";
            }
        };
    }

    protected AbstractGrammarValidator.AbstractSingleEncapsulatedExpressionHelper<CastExpression> castExpressionHelper() {
        AbstractGrammarValidator.AbstractSingleEncapsulatedExpressionHelper<CastExpression> helper = (AbstractGrammarValidator.AbstractSingleEncapsulatedExpressionHelper<CastExpression>)this.getHelper("CAST");
        if (helper == null) {
            helper = this.buildCastExpressionHelper();
            this.registerHelper("CAST", helper);
        }
        return helper;
    }

    protected AbstractGrammarValidator.AbstractDoubleEncapsulatedExpressionHelper<DatabaseType> databaseTypeHelper() {
        AbstractGrammarValidator.AbstractDoubleEncapsulatedExpressionHelper<DatabaseType> helper = (AbstractGrammarValidator.AbstractDoubleEncapsulatedExpressionHelper<DatabaseType>)this.getHelper("database-type");
        if (helper == null) {
            helper = this.buildDatabaseTypeHelper();
            this.registerHelper("database-type", helper);
        }
        return helper;
    }

    protected AbstractGrammarValidator.AbstractSingleEncapsulatedExpressionHelper<ExtractExpression> extractExpressionHelper() {
        AbstractGrammarValidator.AbstractSingleEncapsulatedExpressionHelper<ExtractExpression> helper = (AbstractGrammarValidator.AbstractSingleEncapsulatedExpressionHelper<ExtractExpression>)this.getHelper("EXTRACT");
        if (helper == null) {
            helper = this.buildExtractExpressionHelper();
            this.registerHelper("EXTRACT", helper);
        }
        return helper;
    }

    protected InExpressionVisitor getInExpressionVisitor() {
        if (this.inExpressionVisitor == null) {
            this.inExpressionVisitor = this.buildInExpressionVisitor();
        }
        return this.inExpressionVisitor;
    }

    protected InExpressionWithNestedArrayVisitor getInExpressionWithNestedArray() {
        if (this.inExpressionWithNestedArrayVisitor == null) {
            this.inExpressionWithNestedArrayVisitor = this.buildInExpressionWithNestedArrayVisitor();
        }
        return this.inExpressionWithNestedArrayVisitor;
    }

    @Override
    protected AbstractEclipseLinkSemanticValidator.EclipseLinkOwningClauseVisitor getOwningClauseVisitor() {
        return (AbstractEclipseLinkSemanticValidator.EclipseLinkOwningClauseVisitor)super.getOwningClauseVisitor();
    }

    protected final boolean isEclipseLink() {
        return "EclipseLink".equals(this.getProvider());
    }

    protected boolean isInExpressionWithNestedArray(SimpleSelectClause expression) {
        InExpressionWithNestedArrayVisitor visitor = this.getInExpressionWithNestedArray();
        try {
            expression.accept(visitor);
            boolean bl = visitor.valid;
            return bl;
        }
        finally {
            visitor.valid = false;
        }
    }

    @Override
    protected boolean isInputParameterInValidLocation(InputParameter expression) {
        return true;
    }

    @Override
    protected boolean isJoinFetchIdentifiable() {
        EclipseLinkVersion version = EclipseLinkVersion.value(this.getGrammar().getProviderVersion());
        return version.isNewerThanOrEqual(EclipseLinkVersion.VERSION_2_4);
    }

    @Override
    protected boolean isMultipleSubquerySelectItemsAllowed(SimpleSelectClause expression) {
        return this.isInExpressionWithNestedArray(expression);
    }

    protected boolean isOwnedByInExpression(Expression expression) {
        InExpressionVisitor visitor = this.getInExpressionVisitor();
        expression.accept(visitor);
        return visitor.expression != null;
    }

    protected boolean isOwnedByUnionClause(Expression expression) {
        AbstractEclipseLinkSemanticValidator.EclipseLinkOwningClauseVisitor visitor = this.getOwningClauseVisitor();
        try {
            expression.accept(visitor);
            boolean bl = visitor.unionClause != null;
            return bl;
        }
        finally {
            visitor.dispose();
        }
    }

    @Override
    protected boolean isSubqueryAllowedAnywhere() {
        EclipseLinkVersion version = EclipseLinkVersion.value(this.getProviderVersion());
        return version.isNewerThanOrEqual(EclipseLinkVersion.VERSION_2_4);
    }

    protected AbstractGrammarValidator.AbstractSingleEncapsulatedExpressionHelper<TableExpression> tableExpressionHelper() {
        AbstractGrammarValidator.AbstractSingleEncapsulatedExpressionHelper<TableExpression> helper = (AbstractGrammarValidator.AbstractSingleEncapsulatedExpressionHelper<TableExpression>)this.getHelper("TABLE");
        if (helper == null) {
            helper = this.buildTableExpressionHelper();
            this.registerHelper("TABLE", helper);
        }
        return helper;
    }

    @Override
    protected void validateAbstractSelectClause(AbstractSelectClause expression, boolean multipleSelectItemsAllowed) {
        if (!multipleSelectItemsAllowed) {
            AbstractExpression parent = expression.getParent();
            multipleSelectItemsAllowed = this.isOwnedByFromClause(parent) || this.isOwnedByUnionClause(parent) || this.isOwnedByInExpression(parent);
        }
        super.validateAbstractSelectClause(expression, multipleSelectItemsAllowed);
    }

    @Override
    public void visit(AsOfClause expression) {
    }

    @Override
    public void visit(CastExpression expression) {
        if (!this.isEclipseLink()) {
            this.addProblem(expression, "CAST_EXPRESSION_INVALID_JPA_VERSION");
        } else {
            this.validateAbstractSingleEncapsulatedExpression(expression, this.castExpressionHelper());
            if (expression.hasExpression() || expression.hasAs()) {
                if (!expression.hasDatabaseType()) {
                    int startPosition = this.position(expression) + 4 + (expression.hasLeftParenthesis() ? 1 : 0) + this.length(expression.getExpression()) + (expression.hasSpaceAfterExpression() ? 1 : 0) + (expression.hasAs() ? 2 : 0) + (expression.hasSpaceAfterAs() ? 1 : 0);
                    this.addProblem((Expression)expression, startPosition, "CAST_EXPRESSION_MISSING_DATABASE_TYPE", new String[0]);
                } else {
                    expression.getDatabaseType().accept(this);
                }
            }
        }
    }

    @Override
    public void visit(ConnectByClause expression) {
    }

    @Override
    public void visit(DatabaseType expression) {
        this.validateAbstractDoubleEncapsulatedExpression(expression, this.databaseTypeHelper());
    }

    @Override
    public void visit(ExtractExpression expression) {
        if (!this.isEclipseLink()) {
            this.addProblem(expression, "EXTRACT_EXPRESSION_INVALID_JPA_VERSION");
        } else {
            this.validateAbstractSingleEncapsulatedExpression(expression, this.extractExpressionHelper());
            if (expression.hasLeftParenthesis() && !expression.hasDatePart()) {
                int startPosition = this.position(expression) + 7 + (expression.hasLeftParenthesis() ? 1 : 0);
                this.addProblem((Expression)expression, startPosition, "EXTRACT_EXPRESSION_MISSING_DATE_PART", new String[0]);
            }
        }
    }

    @Override
    public void visit(HierarchicalQueryClause expression) {
    }

    @Override
    public void visit(OrderSiblingsByClause expression) {
    }

    @Override
    public void visit(RegexpExpression expression) {
        if (!this.isEclipseLink()) {
            this.addProblem(expression, "REGEXP_EXPRESSION_INVALID_JPA_VERSION");
        } else {
            int endPosition;
            int startPosition;
            int endPosition2;
            int startPosition2;
            if (!expression.hasStringExpression()) {
                endPosition2 = startPosition2 = this.position(expression);
                this.addProblem((Expression)expression, startPosition2, endPosition2, "REGEXP_EXPRESSION_MISSING_STRING_EXPRESSION", new String[0]);
            } else {
                Expression stringExpression = expression.getStringExpression();
                if (!this.isValid(stringExpression, "string_expression")) {
                    startPosition = this.position(stringExpression);
                    endPosition = startPosition + this.length(stringExpression);
                    this.addProblem((Expression)expression, startPosition, endPosition, "REGEXP_EXPRESSION_INVALID_STRING_EXPRESSION", new String[0]);
                } else {
                    stringExpression.accept(this);
                }
            }
            if (!expression.hasPatternValue()) {
                endPosition2 = startPosition2 = this.position(expression) + this.length(expression.getStringExpression()) + (expression.hasSpaceAfterStringExpression() ? 1 : 0) + 6 + (expression.hasSpaceAfterIdentifier() ? 1 : 0);
                this.addProblem((Expression)expression, startPosition2, endPosition2, "REGEXP_EXPRESSION_MISSING_PATTERN_VALUE", new String[0]);
            } else {
                Expression patternValue = expression.getStringExpression();
                if (!this.isValid(patternValue, "pattern_value")) {
                    startPosition = this.position(expression) + this.length(expression.getStringExpression()) + (expression.hasSpaceAfterStringExpression() ? 1 : 0) + 6 + (expression.hasSpaceAfterIdentifier() ? 1 : 0);
                    endPosition = startPosition + this.length(patternValue);
                    this.addProblem((Expression)expression, startPosition, endPosition, "REGEXP_EXPRESSION_INVALID_PATTERN_VALUE", new String[0]);
                } else {
                    patternValue.accept(this);
                }
            }
        }
    }

    @Override
    public void visit(StartWithClause expression) {
    }

    @Override
    public void visit(TableExpression expression) {
        this.validateAbstractSingleEncapsulatedExpression(expression, this.tableExpressionHelper());
    }

    @Override
    public void visit(TableVariableDeclaration expression) {
        if (!this.isEclipseLink()) {
            this.addProblem(expression, "TABLE_VARIABLE_DECLARATION_INVALID_JPA_VERSION");
        } else {
            TableExpression tableExpression = expression.getTableExpression();
            tableExpression.accept(this);
            if (!expression.hasIdentificationVariable()) {
                int startPosition = this.position(expression) + this.length(tableExpression) + (expression.hasSpaceAfterTableExpression() ? 1 : 0) + (expression.hasAs() ? 2 : 0) + (expression.hasSpaceAfterAs() ? 1 : 0);
                this.addProblem((Expression)expression, startPosition, "TABLE_VARIABLE_DECLARATION_MISSING_IDENTIFICATION_VARIABLE", new String[0]);
            } else {
                expression.getIdentificationVariable().accept(this);
            }
        }
    }

    @Override
    public void visit(UnionClause expression) {
        if (!this.isEclipseLink()) {
            this.addProblem(expression, "UNION_CLAUSE_INVALID_JPA_VERSION");
        } else if (!expression.hasQuery()) {
            int startPosition = this.position(expression) + expression.getIdentifier().length() + (expression.hasSpaceAfterIdentifier() ? 1 : 0) + (expression.hasAll() ? 3 : 0) + (expression.hasSpaceAfterAll() ? 1 : 0);
            this.addProblem((Expression)expression, startPosition, "UNION_CLAUSE_MISSING_EXPRESSION", new String[0]);
        } else {
            expression.getQuery().accept(this);
        }
    }

    protected static class InExpressionVisitor
    extends AbstractEclipseLinkExpressionVisitor {
        protected InExpression expression;

        protected InExpressionVisitor() {
        }

        @Override
        public void visit(InExpression expression) {
            this.expression = expression;
        }
    }

    protected static final class InExpressionWithNestedArrayVisitor
    extends AbstractEclipseLinkExpressionVisitor {
        private final EclipseLinkGrammarValidator visitor;
        public boolean valid;

        protected InExpressionWithNestedArrayVisitor(EclipseLinkGrammarValidator visitor) {
            this.visitor = visitor;
        }

        @Override
        public void visit(InExpression expression) {
            this.valid = this.visitor.isNestedArray(expression.getExpression());
        }

        @Override
        public void visit(SimpleSelectClause expression) {
            expression.getParent().accept(this);
        }

        @Override
        public void visit(SimpleSelectStatement expression) {
            expression.getParent().accept(this);
        }
    }
}

