/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource.deployer;

import com.sun.appserv.connectors.internal.api.ConnectorRuntimeException;
import com.sun.appserv.connectors.internal.api.ConnectorsUtil;
import com.sun.enterprise.config.serverbeans.BindableResource;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.enterprise.connectors.util.ResourcesUtil;
import com.sun.enterprise.resource.deployer.AbstractConnectorResourceDeployer;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.glassfish.connectors.config.ConnectorConnectionPool;
import org.glassfish.connectors.config.ConnectorResource;
import org.glassfish.resourcebase.resources.api.PoolInfo;
import org.glassfish.resourcebase.resources.api.ResourceDeployerInfo;
import org.glassfish.resourcebase.resources.api.ResourceInfo;
import org.jvnet.hk2.annotations.Service;

@Service
@ResourceDeployerInfo(value=ConnectorResource.class)
@Singleton
public class ConnectorResourceDeployer
extends AbstractConnectorResourceDeployer {
    @Inject
    private ConnectorRuntime runtime;
    private static Logger _logger = LogDomains.getLogger(ConnectorResourceDeployer.class, (String)"javax.enterprise.resource.resourceadapter");

    public synchronized void deployResource(Object resource, String applicationName, String moduleName) throws Exception {
        ConnectorResource domainResource = (ConnectorResource)resource;
        ResourceInfo resourceInfo = new ResourceInfo(domainResource.getJndiName(), applicationName, moduleName);
        PoolInfo poolInfo = new PoolInfo(domainResource.getPoolName(), applicationName, moduleName);
        this.createConnectorResource(domainResource, resourceInfo, poolInfo);
    }

    public void deployResource(Object resource) throws Exception {
        ConnectorResource domainResource = (ConnectorResource)resource;
        String poolName = domainResource.getPoolName();
        ResourceInfo resourceInfo = ConnectorsUtil.getResourceInfo((BindableResource)domainResource);
        PoolInfo poolInfo = new PoolInfo(poolName, resourceInfo.getApplicationName(), resourceInfo.getModuleName());
        this.createConnectorResource(domainResource, resourceInfo, poolInfo);
    }

    private void createConnectorResource(ConnectorResource connectorResource, ResourceInfo resourceInfo, PoolInfo poolInfo) throws ConnectorRuntimeException {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Calling backend to add connector resource", resourceInfo);
        }
        this.runtime.createConnectorResource(resourceInfo, poolInfo, null);
        String jndiName = resourceInfo.getName();
        if (ConnectorsUtil.getValidSuffix((String)jndiName) == null) {
            ResourceInfo pmResourceInfo = new ResourceInfo(ConnectorsUtil.getPMJndiName((String)jndiName), resourceInfo.getApplicationName(), resourceInfo.getModuleName());
            this.runtime.createConnectorResource(pmResourceInfo, poolInfo, null);
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Added connector resource in backend", resourceInfo);
        }
    }

    public void undeployResource(Object resource, String applicationName, String moduleName) throws Exception {
        ConnectorResource domainResource = (ConnectorResource)resource;
        ResourceInfo resourceInfo = new ResourceInfo(domainResource.getJndiName(), applicationName, moduleName);
        this.deleteConnectorResource(domainResource, resourceInfo);
    }

    public synchronized void undeployResource(Object resource) throws Exception {
        ConnectorResource domainResource = (ConnectorResource)resource;
        ResourceInfo resourceInfo = ConnectorsUtil.getResourceInfo((BindableResource)domainResource);
        this.deleteConnectorResource(domainResource, resourceInfo);
    }

    private void deleteConnectorResource(ConnectorResource connectorResource, ResourceInfo resourceInfo) throws Exception {
        this.runtime.deleteConnectorResource(resourceInfo);
        if (ConnectorsUtil.getValidSuffix((String)resourceInfo.getName()) == null) {
            String pmJndiName = ConnectorsUtil.getPMJndiName((String)resourceInfo.getName());
            ResourceInfo pmResourceInfo = new ResourceInfo(pmJndiName, resourceInfo.getApplicationName(), resourceInfo.getModuleName());
            this.runtime.deleteConnectorResource(pmResourceInfo);
        }
        this.checkAndDeletePool(connectorResource);
    }

    public void redeployResource(Object resource) throws Exception {
        this.undeployResource(resource);
        this.deployResource(resource);
    }

    public synchronized void disableResource(Object resource) throws Exception {
        this.undeployResource(resource);
    }

    public synchronized void enableResource(Object resource) throws Exception {
        this.deployResource(resource);
    }

    public boolean handles(Object resource) {
        return resource instanceof ConnectorResource;
    }

    public boolean supportsDynamicReconfiguration() {
        return false;
    }

    public Class[] getProxyClassesForDynamicReconfiguration() {
        return new Class[0];
    }

    private void checkAndDeletePool(ConnectorResource cr) throws Exception {
        String poolName = cr.getPoolName();
        ResourceInfo resourceInfo = ConnectorsUtil.getResourceInfo((BindableResource)cr);
        PoolInfo poolInfo = new PoolInfo(poolName, resourceInfo.getApplicationName(), resourceInfo.getModuleName());
        Resources resources = (Resources)cr.getParent();
        if (resources != null) {
            try {
                boolean poolReferred = ResourcesUtil.createInstance().isPoolReferredInServerInstance(poolInfo);
                if (!poolReferred) {
                    if (_logger.isLoggable(Level.FINE)) {
                        _logger.fine("Deleting connector connection pool [" + poolName + "] as there are no more resource-refs to the pool in this server instance");
                    }
                    ConnectorConnectionPool ccp = (ConnectorConnectionPool)ConnectorsUtil.getResourceByName((Resources)resources, ConnectorConnectionPool.class, (String)poolName);
                    this.runtime.getResourceDeployer(ccp).undeployResource((Object)ccp);
                }
            }
            catch (Exception ce) {
                _logger.warning(ce.getMessage());
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine("Exception while deleting pool [ " + poolName + " ] : " + ce);
                }
                throw ce;
            }
        }
    }
}

