/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.internal.serializer;

import java.math.BigDecimal;
import java.math.BigInteger;

class BigNumberUtil {
    private static final int MAX_BIT_SIZE = 53;
    private static final long MAX_JS_SAFE_VALUE = 0x1FFFFFFFFFFFFFL;
    private static final long MIN_JS_SAFE_VALUE = -9007199254740991L;
    private static final int MIN_RANGE = -1022;
    private static final int MAX_RANGE = 1023;

    BigNumberUtil() {
    }

    static boolean isIEEE754(BigDecimal value) {
        int scale = value.scale();
        int valBits = value.unscaledValue().abs().bitLength();
        int intBitsScaled = value.toBigInteger().bitLength();
        return valBits <= 53 && intBitsScaled <= 53 && -1022 <= scale && scale <= 1023;
    }

    static boolean isIEEE754(BigInteger value) {
        return value.abs().bitLength() <= 53;
    }

    static boolean isIEEE754(Long value) {
        return value >= -9007199254740991L && value <= 0x1FFFFFFFFFFFFFL;
    }
}

