/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors.deployment.annotation.handlers;

import com.sun.enterprise.connectors.deployment.annotation.handlers.AdministeredObjectHandler;
import com.sun.enterprise.deployment.AdminObject;
import com.sun.enterprise.deployment.ConnectionDefDescriptor;
import com.sun.enterprise.deployment.ConnectorConfigProperty;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.InboundResourceAdapter;
import com.sun.enterprise.deployment.MessageListener;
import com.sun.enterprise.deployment.OutboundResourceAdapter;
import com.sun.enterprise.deployment.annotation.context.RarBundleContext;
import com.sun.enterprise.deployment.annotation.handlers.AbstractHandler;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.resource.spi.Activation;
import javax.resource.spi.ActivationSpec;
import javax.resource.spi.AdministeredObject;
import javax.resource.spi.ConfigProperty;
import javax.resource.spi.ConnectionDefinition;
import javax.resource.spi.ConnectionDefinitions;
import javax.resource.spi.Connector;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.ResourceAdapter;
import org.glassfish.apf.AnnotatedElementHandler;
import org.glassfish.apf.AnnotationHandlerFor;
import org.glassfish.apf.AnnotationInfo;
import org.glassfish.apf.AnnotationProcessorException;
import org.glassfish.apf.HandlerProcessingResult;
import org.glassfish.apf.ResultType;
import org.glassfish.apf.impl.AnnotationUtils;
import org.glassfish.apf.impl.HandlerProcessingResultImpl;
import org.jvnet.hk2.annotations.Service;

@Service
@AnnotationHandlerFor(value=ConfigProperty.class)
public class ConfigPropertyHandler
extends AbstractHandler {
    protected static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ConfigPropertyHandler.class);
    protected static final Logger logger = AnnotationUtils.getLogger();
    private static final String SUCCESS = "success";

    public HandlerProcessingResult processAnnotation(AnnotationInfo element) throws AnnotationProcessorException {
        AnnotatedElementHandler aeHandler = element.getProcessingContext().getHandler();
        ConfigProperty configProperty = (ConfigProperty)element.getAnnotation();
        if (!(aeHandler instanceof RarBundleContext)) {
            return this.getFailureResult(element, "not a rar bundle context", true);
        }
        RarBundleContext rbc = (RarBundleContext)aeHandler;
        ConnectorDescriptor desc = rbc.getDescriptor();
        this.handleConfigPropertyAnnotation(configProperty, element, desc);
        return this.getDefaultProcessedResult();
    }

    public HandlerProcessingResult handleConfigPropertyAnnotation(ConfigProperty configProperty, AnnotationInfo element, ConnectorDescriptor desc) {
        String defaultValue = configProperty.defaultValue();
        String[] description = configProperty.description();
        boolean ignore = configProperty.ignore();
        boolean supportsDynamicUpdates = configProperty.supportsDynamicUpdates();
        boolean confidential = configProperty.confidential();
        if (element.getElementType().equals((Object)ElementType.METHOD)) {
            Method m = (Method)element.getAnnotatedElement();
            String result = ConfigPropertyHandler.validateMethod(m, configProperty);
            if (!result.equals(SUCCESS)) {
                return this.getFailureResult(element, result, true);
            }
            Class type = ConfigPropertyHandler.getType(configProperty, m.getParameterTypes()[0]);
            String firstDesc = "";
            if (description.length > 0) {
                firstDesc = description[0];
            }
            ConnectorConfigProperty ep = ConfigPropertyHandler.getConfigProperty(defaultValue, firstDesc, ignore, supportsDynamicUpdates, confidential, type, m.getName().substring(3));
            this.handleConfigPropertyAnnotation(element, desc, ep, m.getDeclaringClass());
        } else if (element.getElementType().equals((Object)ElementType.FIELD)) {
            Field f = (Field)element.getAnnotatedElement();
            String result = ConfigPropertyHandler.validateField(f, configProperty);
            if (!result.equals(SUCCESS)) {
                return this.getFailureResult(element, result, true);
            }
            Class type = ConfigPropertyHandler.getType(configProperty, f.getType());
            if (defaultValue == null || defaultValue.equals("")) {
                defaultValue = ConfigPropertyHandler.deriveDefaultValueOfField(f);
            }
            String firstDesc = "";
            if (description.length > 0) {
                firstDesc = description[0];
            }
            ConnectorConfigProperty ep = ConfigPropertyHandler.getConfigProperty(defaultValue, firstDesc, ignore, supportsDynamicUpdates, confidential, type, f.getName());
            this.handleConfigPropertyAnnotation(element, desc, ep, f.getDeclaringClass());
        }
        return this.getDefaultProcessedResult();
    }

    private static Class getWrapperClass(String primitive) {
        if (primitive.equalsIgnoreCase("int")) {
            return Integer.class;
        }
        if (primitive.equalsIgnoreCase("long")) {
            return Long.class;
        }
        if (primitive.equalsIgnoreCase("short")) {
            return Short.class;
        }
        if (primitive.equalsIgnoreCase("char")) {
            return Character.class;
        }
        if (primitive.equalsIgnoreCase("byte")) {
            return Byte.class;
        }
        if (primitive.equalsIgnoreCase("boolean")) {
            return Boolean.class;
        }
        if (primitive.equalsIgnoreCase("float")) {
            return Float.class;
        }
        if (primitive.equalsIgnoreCase("double")) {
            return Double.class;
        }
        throw new IllegalArgumentException("Could not determine Wrapper class for primitive type [" + primitive + "]");
    }

    private static String deriveDefaultValueOfField(Field f) {
        Class<?> declaringClass = f.getDeclaringClass();
        String fieldName = f.getName();
        String value = null;
        try {
            Object o = declaringClass.newInstance();
            String getterMethod = "get" + ConfigPropertyHandler.getCamelCasedPropertyName(fieldName);
            if (Boolean.class.isAssignableFrom(f.getType())) {
                getterMethod = "is" + ConfigPropertyHandler.getCamelCasedPropertyName(fieldName);
            }
            Method m = declaringClass.getDeclaredMethod(getterMethod, new Class[0]);
            m.setAccessible(true);
            Object result = m.invoke(o, new Object[0]);
            if (result != null) {
                value = result.toString();
            }
        }
        catch (Exception e) {
            Object[] args = new Object[]{fieldName, declaringClass.getName(), e.getMessage()};
            String localString = localStrings.getLocalString("enterprise.deployment.annotation.handlers.configpropertyfieldreadfailure", "failed to read the value of field [{0}] on class [{1}], reason : {2}", args);
            logger.log(Level.WARNING, localString, e);
        }
        return value;
    }

    private static String getCamelCasedPropertyName(String propertyName) {
        return propertyName.substring(0, 1).toUpperCase(Locale.getDefault()) + propertyName.substring(1);
    }

    private static ConnectorConfigProperty getConfigProperty(String defaultValue, String description, boolean ignore, boolean supportsDynamicUpdates, boolean confidential, Class type, String propertyName) {
        ConnectorConfigProperty ep = new ConnectorConfigProperty();
        if (!description.equals("")) {
            ep.setDescription(description);
        }
        if (defaultValue != null && !defaultValue.equals("")) {
            ep.setValue(defaultValue);
        }
        ep.setType(type.getName());
        ep.setName(propertyName);
        if (!ep.isSetIgnoreCalled()) {
            ep.setIgnore(ignore);
        }
        if (!ep.isSetConfidentialCalled()) {
            ep.setConfidential(confidential);
        }
        if (!ep.isSupportsDynamicUpdates()) {
            ep.setSupportsDynamicUpdates(supportsDynamicUpdates);
        }
        return ep;
    }

    private void handleConfigPropertyAnnotation(AnnotationInfo element, ConnectorDescriptor desc, ConnectorConfigProperty ep, Class declaringClass) {
        if (ResourceAdapter.class.isAssignableFrom(declaringClass) && !Modifier.isAbstract(declaringClass.getModifiers()) || declaringClass.getAnnotation(Connector.class) != null) {
            if (!ConfigPropertyHandler.processConnector(desc, ep, declaringClass)) {
                desc.addConfigPropertyAnnotation(declaringClass.getName(), element);
            }
        } else if (ManagedConnectionFactory.class.isAssignableFrom(declaringClass) && !Modifier.isAbstract(declaringClass.getModifiers())) {
            this.processConnectionDefinition(element, desc, ep, declaringClass);
        } else if (ActivationSpec.class.isAssignableFrom(declaringClass) && !Modifier.isAbstract(declaringClass.getModifiers()) || declaringClass.getAnnotation(Activation.class) != null) {
            this.processActivation(element, desc, ep, declaringClass);
        } else if (declaringClass.getAnnotation(AdministeredObject.class) != null || this.isAdminObjectJavaBean(declaringClass, desc)) {
            this.processAdministeredObject(element, desc, ep, declaringClass);
        }
    }

    private boolean isAdminObjectJavaBean(Class adminObjectClass, ConnectorDescriptor desc) {
        boolean isAdminObject = false;
        Set adminObjects = desc.getAdminObjects();
        for (AdminObject adminObject : adminObjects) {
            if (!adminObject.getAdminObjectClass().equals(adminObjectClass.getName())) continue;
            isAdminObject = true;
            break;
        }
        return isAdminObject;
    }

    private void processAdministeredObject(AnnotationInfo element, ConnectorDescriptor desc, ConnectorConfigProperty ep, Class declaringClass) {
        block5: {
            block3: {
                block4: {
                    if (declaringClass.getAnnotation(AdministeredObject.class) == null) break block3;
                    AdministeredObject ao = declaringClass.getAnnotation(AdministeredObject.class);
                    Class[] adminObjectInterfaces = ao.adminObjectInterfaces();
                    if (adminObjectInterfaces.length <= 0) break block4;
                    for (Class adminObjectInterface : adminObjectInterfaces) {
                        this.handleAdministeredObject(element, desc, ep, declaringClass, adminObjectInterface);
                    }
                    break block5;
                }
                List<Class> interfacesList = AdministeredObjectHandler.deriveAdminObjectInterfacesFromHierarchy(declaringClass);
                if (interfacesList.size() != 1) break block5;
                Class intf = interfacesList.get(0);
                this.handleAdministeredObject(element, desc, ep, declaringClass, intf);
                break block5;
            }
            Set adminObjects = desc.getAdminObjects();
            for (AdminObject adminObject : adminObjects) {
                if (!adminObject.getAdminObjectClass().equals(declaringClass.getName())) continue;
                if (!ConfigPropertyHandler.isConfigDefined(adminObject.getConfigProperties(), ep)) {
                    adminObject.addConfigProperty(ep);
                }
                String uniqueName = adminObject.getAdminObjectInterface() + "_" + adminObject.getAdminObjectClass();
                if (desc.getConfigPropertyProcessedClasses().contains(uniqueName)) continue;
                ConfigPropertyHandler.processParent(declaringClass.getSuperclass(), adminObject.getConfigProperties());
                desc.addConfigPropertyProcessedClass(declaringClass.getName());
            }
        }
    }

    private void handleAdministeredObject(AnnotationInfo element, ConnectorDescriptor desc, ConnectorConfigProperty ep, Class adminObjectClass, Class adminObjectIntf) {
        AdminObject adminObject = desc.getAdminObject(adminObjectIntf.getName(), adminObjectClass.getName());
        if (adminObject != null) {
            if (!ConfigPropertyHandler.isConfigDefined(adminObject.getConfigProperties(), ep)) {
                adminObject.addConfigProperty(ep);
            }
            if (!desc.getConfigPropertyProcessedClasses().contains(adminObjectClass.getName())) {
                ConfigPropertyHandler.processParent(adminObjectClass.getSuperclass(), adminObject.getConfigProperties());
                desc.addConfigPropertyProcessedClass(adminObjectClass.getName());
            }
        } else {
            this.getFailureResult(element, "could not get adminobject of interface [ " + adminObjectIntf.getName() + " ] and class [ " + adminObjectClass.getName() + " ]", true);
        }
    }

    private void processActivation(AnnotationInfo element, ConnectorDescriptor desc, ConnectorConfigProperty ep, Class declaringClass) {
        block6: {
            block5: {
                Class[] messageListeners;
                InboundResourceAdapter ira = desc.getInboundResourceAdapter();
                if (declaringClass.getAnnotation(Activation.class) == null) break block5;
                if (!desc.getInBoundDefined()) break block6;
                Activation activation = declaringClass.getAnnotation(Activation.class);
                for (Class clz : messageListeners = activation.messageListeners()) {
                    MessageListener ml;
                    if (!ira.hasMessageListenerType(clz.getName()) || !(ml = ira.getMessageListener(clz.getName())).getActivationSpecClass().equals(declaringClass.getName())) continue;
                    if (!ConfigPropertyHandler.isConfigDefined(ml.getConfigProperties(), ep)) {
                        ml.addConfigProperty(ep);
                    }
                    if (desc.getConfigPropertyProcessedClasses().contains(declaringClass.getName())) continue;
                    ConfigPropertyHandler.processParent(declaringClass.getSuperclass(), ml.getConfigProperties());
                    desc.addConfigPropertyProcessedClass(declaringClass.getName());
                }
                break block6;
            }
            if (desc.getInBoundDefined()) {
                Set messageListeners = desc.getInboundResourceAdapter().getMessageListeners();
                for (MessageListener ml : messageListeners) {
                    if (!ml.getActivationSpecClass().equals(declaringClass.getName())) continue;
                    if (!ConfigPropertyHandler.isConfigDefined(ml.getConfigProperties(), ep)) {
                        ml.addConfigProperty(ep);
                    }
                    if (desc.getConfigPropertyProcessedClasses().contains(declaringClass.getName())) continue;
                    ConfigPropertyHandler.processParent(declaringClass.getSuperclass(), ml.getConfigProperties());
                    desc.addConfigPropertyProcessedClass(declaringClass.getName());
                }
            }
        }
    }

    private void processConnectionDefinition(AnnotationInfo element, ConnectorDescriptor desc, ConnectorConfigProperty ep, Class declaringClass) {
        if (desc.getOutBoundDefined()) {
            OutboundResourceAdapter ora = desc.getOutboundResourceAdapter();
            Set connectionDefinitions = ora.getConnectionDefs();
            for (Object o : connectionDefinitions) {
                ConnectionDefDescriptor cd = (ConnectionDefDescriptor)o;
                if (!cd.getManagedConnectionFactoryImpl().equals(declaringClass.getName())) continue;
                if (!ConfigPropertyHandler.isConfigDefined(cd.getConfigProperties(), ep)) {
                    cd.addConfigProperty(ep);
                }
                if (desc.getConfigPropertyProcessedClasses().contains(cd.getConnectionFactoryIntf())) continue;
                ConfigPropertyHandler.processParent(declaringClass.getSuperclass(), cd.getConfigProperties());
                desc.addConfigPropertyProcessedClass(cd.getConnectionFactoryIntf());
            }
        } else {
            this.getFailureResult(element, "Outbound RA is not defined", true);
        }
    }

    public static boolean processConnector(ConnectorDescriptor desc, ConnectorConfigProperty ep, Class declaringClass) {
        if (desc.getResourceAdapterClass().equals(declaringClass.getName())) {
            if (!ConfigPropertyHandler.isConfigDefined(desc.getConfigProperties(), ep)) {
                desc.addConfigProperty(ep);
            }
            if (!desc.getConfigPropertyProcessedClasses().contains(declaringClass.getName())) {
                ConfigPropertyHandler.processParent(declaringClass.getSuperclass(), desc.getConfigProperties());
                desc.addConfigPropertyProcessedClass(declaringClass.getName());
            }
            return true;
        }
        return false;
    }

    private static String validateMethod(Method m, ConfigProperty property) {
        if (!m.getName().startsWith("set")) {
            return "not a standard JavaBean setter method : [" + m.getName() + " ] ";
        }
        int modifier = m.getModifiers();
        if (Modifier.isPrivate(modifier)) {
            return "@ConfigProperty annotation on a private setter method [ " + m.getName() + " ] of class [ " + m.getDeclaringClass().getName() + " ]";
        }
        Class type = property.type();
        Class<?>[] parameters = m.getParameterTypes();
        if (parameters.length != 0) {
            if (parameters.length != 1) {
                return "more than one parameter for JavaBean setter method : [" + m.getName() + " ] ";
            }
        } else {
            return "no parameters for JavaBean setter method :  [" + m.getName() + " ] ";
        }
        Class propertyType = parameters[0];
        if (!type.equals(Object.class) && !propertyType.isAssignableFrom(type)) {
            if (type.isPrimitive()) {
                type = ConfigPropertyHandler.getWrapperClass(type.getName());
            } else if (propertyType.isPrimitive()) {
                propertyType = ConfigPropertyHandler.getWrapperClass(propertyType.getName());
            }
            if (!propertyType.isAssignableFrom(type)) {
                return "annotation type [" + type + "] and property-type [" + propertyType + "] are not assignment compatible";
            }
        }
        return SUCCESS;
    }

    private static Class getType(ConfigProperty property, Class type) {
        Class configPropertyType = property.type();
        if (configPropertyType.equals(Object.class)) {
            configPropertyType = type;
        }
        return configPropertyType;
    }

    private static String validateField(Field f, ConfigProperty property) {
        Class<?> c = f.getDeclaringClass();
        Class<?> returnType = f.getType();
        Class type = property.type();
        if (!type.equals(Object.class) && !returnType.isAssignableFrom(type)) {
            return "annotation type [" + type + "] and return-type [" + returnType + "] are not assignment compatible for @ConfigProperty in field [ " + f.getName() + " ] of class [ " + c + " ]";
        }
        return SUCCESS;
    }

    public static void processParent(Class claz, Set configProperties) {
        Field[] fields;
        Method[] methods;
        if (claz == null) {
            return;
        }
        for (Method m : methods = claz.getDeclaredMethods()) {
            ConfigProperty property = m.getAnnotation(ConfigProperty.class);
            if (property == null) continue;
            String result = ConfigPropertyHandler.validateMethod(m, property);
            if (!result.equals(SUCCESS)) {
                throw new IllegalStateException(result);
            }
            String defaultValue = property.defaultValue();
            Class type = ConfigPropertyHandler.getType(property, m.getParameterTypes()[0]);
            ConfigPropertyHandler.processConfigProperty(configProperties, m.getName().substring(3), property, defaultValue, type);
        }
        for (Field f : fields = claz.getDeclaredFields()) {
            ConfigProperty property = f.getAnnotation(ConfigProperty.class);
            if (property == null) continue;
            String status = ConfigPropertyHandler.validateField(f, property);
            if (!status.equals(SUCCESS)) {
                throw new IllegalStateException(status);
            }
            String defaultValue = property.defaultValue();
            if (defaultValue == null || defaultValue.equals("")) {
                defaultValue = ConfigPropertyHandler.deriveDefaultValueOfField(f);
            }
            ConfigPropertyHandler.processConfigProperty(configProperties, f.getName(), property, defaultValue, f.getType());
        }
        if (claz.getSuperclass() != null) {
            ConfigPropertyHandler.processParent(claz.getSuperclass(), configProperties);
        }
    }

    private static void processConfigProperty(Set configProperties, String propertyName, ConfigProperty property, String defaultValue, Class declaredEntityType) {
        String description = "";
        if (property.description() != null && property.description().length > 0) {
            description = property.description()[0];
        }
        Class type = ConfigPropertyHandler.getType(property, declaredEntityType);
        ConnectorConfigProperty ccp = ConfigPropertyHandler.getConfigProperty(defaultValue, description, property.ignore(), property.supportsDynamicUpdates(), property.confidential(), type, propertyName);
        if (!ConfigPropertyHandler.isConfigDefined(configProperties, ccp)) {
            configProperties.add(ccp);
        }
    }

    private static boolean isConfigDefined(Set configProperties, ConnectorConfigProperty ep) {
        boolean result = false;
        for (Object o : configProperties) {
            ConnectorConfigProperty ddEnvProperty = (ConnectorConfigProperty)o;
            if (!ddEnvProperty.getName().equals(ep.getName())) continue;
            result = true;
            break;
        }
        return result;
    }

    protected HandlerProcessingResult getDefaultProcessedResult() {
        return HandlerProcessingResultImpl.getDefaultResult((Class)this.getAnnotationType(), (ResultType)ResultType.PROCESSED);
    }

    public Class<? extends Annotation>[] getTypeDependencies() {
        return new Class[]{Connector.class, ConnectionDefinition.class, ConnectionDefinitions.class, Activation.class, AdministeredObject.class};
    }

    private void debug(String s) {
        logger.log(Level.INFO, "[ConfigPropertyHandler] " + s);
    }

    private HandlerProcessingResultImpl getFailureResult(AnnotationInfo element, String message, boolean doLog) {
        HandlerProcessingResultImpl result = new HandlerProcessingResultImpl();
        result.addResult(this.getAnnotationType(), ResultType.FAILED);
        if (doLog) {
            AnnotatedElement o = element.getAnnotatedElement();
            String className = null;
            className = o instanceof Field ? ((Field)o).getDeclaringClass().getName() : ((Method)o).getDeclaringClass().getName();
            Object[] args = new Object[]{element.getAnnotation(), className, message};
            String localString = localStrings.getLocalString("enterprise.deployment.annotation.handlers.connectorannotationfailure", "failed to handle annotation [ {0} ] on class [ {1} ], reason : {2}", args);
            logger.log(Level.WARNING, localString);
        }
        return result;
    }
}

