/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.config;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;
import org.glassfish.grizzly.config.GrizzlyConfigException;
import org.jvnet.hk2.config.Attribute;
import org.jvnet.hk2.config.ConfigBeanProxy;

public class DefaultProxy
implements InvocationHandler {
    private final Map<String, Method> methods;
    private final ConfigBeanProxy parent;

    DefaultProxy(ConfigBeanProxy parent, Class<? extends ConfigBeanProxy> sslClass) {
        Method[] list;
        this.parent = parent;
        this.methods = new HashMap<String, Method>();
        for (Method method : list = sslClass.getDeclaredMethods()) {
            if (!method.getName().startsWith("get") && !method.getName().startsWith("is")) continue;
            this.methods.put(method.getName(), method);
        }
    }

    public ConfigBeanProxy getParent() {
        return this.parent;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object value = null;
        if (this.methods.get(method.getName()) != null) {
            String defValue;
            Attribute annotation = method.getAnnotation(Attribute.class);
            if (annotation != null && (defValue = annotation.defaultValue().trim()).length() > 0) {
                value = defValue;
            }
        } else if ("getParent".equals(method.getName())) {
            value = this.getParent();
        } else {
            throw new GrizzlyConfigException(String.format("Method not implemented for a %s: %s", this.getClass().getName(), method.getName()));
        }
        return value;
    }

    public static ConfigBeanProxy createDummyProxy(ConfigBeanProxy parent, Class<? extends ConfigBeanProxy> type) {
        return (ConfigBeanProxy)Proxy.newProxyInstance(type.getClassLoader(), new Class[]{type}, (InvocationHandler)new DefaultProxy(parent, type));
    }
}

