/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.servlet.api.javax_servlet.singlethreadmodel;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class STMClientServlet
extends HttpServlet {
    public void init(ServletConfig config) throws ServletException {
        super.init(config);
    }

    public void destory() {
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        int errors = 0;
        try {
            int threadCount = Integer.valueOf(request.getParameter("count"));
            String fPath = request.getRequestURI();
            String path = fPath.substring(0, fPath.lastIndexOf("/") + 1) + "SingleModelTest";
            ThreadClient tc = new ThreadClient(request.getServerName(), request.getServerPort(), threadCount, path);
            errors = tc.runTest();
        }
        catch (Throwable t) {
            throw new ServletException("SingleThreadModel Test FAILED", t);
        }
        if (errors > 0) {
            throw new ServletException("SingleThreadModel Test FAILED");
        }
    }

    public String getServletInfo() {
        return "SingleThreadModel Client Servlet";
    }

    private class ThreadClient {
        private static final int SLEEPTIME = 5000;
        private static final int NUM_REQUESTS = 3;
        private int threadCount = 0;
        private int threadsDone = 0;
        private int errors = 0;
        private int port = 0;
        private Object lock = new Object();
        private Object startLock = new Object();
        private String hostname = null;
        private String requestPath = null;

        public ThreadClient(String hostname, int port, int threadCount, String requestPath) {
            this.hostname = hostname;
            this.port = port;
            this.threadCount = threadCount;
            this.requestPath = requestPath;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int runTest() throws Throwable {
            Thread[] testThread = new Thread[this.threadCount];
            for (int i = 0; i < this.threadCount; ++i) {
                testThread[i] = new Thread((Runnable)new TestThread(i), "TestThread-" + i);
                testThread[i].setPriority(10);
                testThread[i].start();
            }
            Object object = this.lock;
            synchronized (object) {
                while (this.threadsDone < testThread.length) {
                    this.lock.wait();
                }
                try {
                    Thread.sleep(5000L);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            object = this.startLock;
            synchronized (object) {
                this.threadsDone = 0;
                this.startLock.notifyAll();
            }
            object = this.lock;
            synchronized (object) {
                while (this.threadsDone < testThread.length) {
                    this.lock.wait();
                }
            }
            if (this.errors > 0) {
                STMClientServlet.this.log("[STMClient] Number of Errors: " + this.errors);
                STMClientServlet.this.log("[STMClient] Test FAILED");
            } else {
                STMClientServlet.this.log("[STMClient] No Errors.Test PASSED");
            }
            return this.errors;
        }

        private class TestThread
        implements Runnable {
            private int threadNum = 0;

            public TestThread(int threadNum) {
                this.threadNum = threadNum;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = ThreadClient.this.lock;
                synchronized (object) {
                    ++ThreadClient.this.threadsDone;
                    ThreadClient.this.lock.notifyAll();
                }
                object = ThreadClient.this.startLock;
                synchronized (object) {
                    try {
                        ThreadClient.this.startLock.wait();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                this.runSingleThreadModelTest();
                object = ThreadClient.this.lock;
                synchronized (object) {
                    ++ThreadClient.this.threadsDone;
                    ThreadClient.this.lock.notifyAll();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void runSingleThreadModelTest() {
                for (int i = 0; i < 3; ++i) {
                    try {
                        URL url = new URL("http://" + ThreadClient.this.hostname + ":" + ThreadClient.this.port + ThreadClient.this.requestPath);
                        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                        conn.setRequestMethod("GET");
                        conn.connect();
                        int code = conn.getResponseCode();
                        if (code != 200) {
                            Object object = ThreadClient.this.lock;
                            synchronized (object) {
                                ++ThreadClient.this.errors;
                            }
                        }
                        Thread.sleep(1000L);
                        continue;
                    }
                    catch (Throwable t) {
                        STMClientServlet.this.log("[STMClient] Unexpected Exception in runSingleThreadModelTest()!");
                        STMClientServlet.this.log("[STMClient] Exception: " + t.toString());
                        STMClientServlet.this.log("[STMClient] Message: " + t.getMessage());
                        t.printStackTrace();
                        Object object = ThreadClient.this.lock;
                        synchronized (object) {
                            ++ThreadClient.this.errors;
                            continue;
                        }
                    }
                }
            }
        }
    }
}

