/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.servlet.common.client;

import com.sun.javatest.Status;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.common.webclient.BaseUrlClient;
import com.sun.ts.tests.common.webclient.WebTestCase;
import com.sun.ts.tests.common.webclient.http.HttpRequest;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;

public abstract class AbstractUrlClient
extends BaseUrlClient {
    protected static final String APITEST = "apitest";
    protected static final String DONOTUSEServletName = "NoServletName";
    private InetAddress[] _addrs = null;
    private String _servlet = null;

    protected AbstractUrlClient() {
        String suffix;
        String cname = ((Object)((Object)this)).getClass().getName();
        String prefix = "com.sun.ts.tests.";
        if (cname.startsWith(prefix)) {
            cname = cname.substring(prefix.length());
        }
        if (cname.endsWith(suffix = ".URLClient")) {
            cname = cname.substring(0, cname.length() - suffix.length());
        }
        cname = cname.replace('.', '_');
        cname = "/" + cname + "_web";
        this.setContextRoot(cname);
    }

    public void run(String[] args) {
        Status s = super.run(args, new PrintWriter(System.out), new PrintWriter(System.err));
        s.exit();
    }

    protected void setTestProperties(WebTestCase testCase) {
        this.setStandardProperties(TEST_PROPS.getProperty("standard"), testCase);
        this.setApiTestProperties(TEST_PROPS.getProperty(APITEST), testCase);
        super.setTestProperties(testCase);
    }

    private void setApiTestProperties(String testValue, WebTestCase testCase) {
        if (testValue == null) {
            return;
        }
        this._testName = testValue;
        StringBuffer sb = new StringBuffer(50);
        if (this._servlet != null && TEST_PROPS.getProperty(DONOTUSEServletName) == null) {
            sb.append("GET ").append(this._contextRoot).append("/");
            sb.append(this._servlet).append("?testname=").append(testValue);
            sb.append(" HTTP/1.1");
        } else {
            sb.append("GET ").append(this._contextRoot).append("/");
            sb.append(testValue).append(" HTTP/1.0");
        }
        System.out.println("REQUEST LINE: " + sb.toString());
        HttpRequest req = new HttpRequest(sb.toString(), this._hostname, this._port);
        testCase.setRequest(req);
        if (TEST_PROPS.getProperty("search_string") == null || TEST_PROPS.getProperty("search_string").equals("")) {
            testCase.setResponseSearchString("Test PASSED");
            testCase.setUnexpectedResponseSearchString("Test FAILED");
        }
    }

    private void setStandardProperties(String testValue, WebTestCase testCase) {
        if (testValue == null) {
            return;
        }
        StringBuffer sb = new StringBuffer(50);
        this._testName = testValue;
        if (this._servlet != null) {
            sb.append("GET ").append(this._contextRoot).append("/");
            sb.append(this._servlet).append("?testname=").append(testValue);
            sb.append(" HTTP/1.1");
        } else {
            sb.append("GET ").append(this._contextRoot).append("/");
            sb.append(testValue).append(" HTTP/1.0");
        }
        System.out.println("REQUEST LINE: " + sb.toString());
        HttpRequest req = new HttpRequest(sb.toString(), this._hostname, this._port);
        testCase.setRequest(req);
        sb = new StringBuffer(50);
        sb.append(this._tsHome).append(this.GOLDENFILEDIR);
        sb.append(this._generalURI).append("/");
        sb.append(testValue).append(".gf");
        testCase.setGoldenFilePath(sb.toString());
    }

    protected void setServletName(String servlet) {
        this._servlet = servlet;
    }

    protected String getServletName() {
        return this._servlet;
    }

    protected String getLocalInterfaceInfo(boolean returnAddresses) {
        String result = null;
        this.initInetAddress();
        if (this._addrs.length != 0) {
            StringBuffer sb = new StringBuffer(32);
            if (!returnAddresses) {
                sb.append("localhost,");
            } else {
                sb.append("127.0.0.1,");
            }
            for (int i = 0; i < this._addrs.length; ++i) {
                if (returnAddresses) {
                    String ip = this._addrs[i].getHostAddress();
                    if (!ip.equals("127.0.0.1")) {
                        if (ip.contains("%")) {
                            int scope_id = ip.indexOf("%");
                            ip = ip.substring(0, scope_id);
                        }
                        sb.append(ip);
                    }
                } else {
                    String host = this._addrs[i].getCanonicalHostName();
                    if (!host.equals("localhost")) {
                        sb.append(host);
                    }
                }
                if (i + 1 == this._addrs.length) continue;
                sb.append(",");
            }
            result = sb.toString();
            TestUtil.logTrace((String)("[AbstractUrlClient] Interface info: " + result));
        }
        return result;
    }

    private void initInetAddress() {
        if (this._addrs == null) {
            try {
                this._addrs = InetAddress.getAllByName(InetAddress.getLocalHost().getCanonicalHostName());
            }
            catch (UnknownHostException uhe) {
                TestUtil.logMsg((String)"[AbstractUrlClient][WARNING] Unable to obtain local host information.");
            }
        }
    }
}

