package org.apache.jsp;

import javax.servlet.*;
import javax.servlet.http.*;
import javax.servlet.jsp.*;
import com.sun.ts.tests.jsp.common.util.JspTestUtil;
import java.io.IOException;
import javax.servlet.jsp.tagext.TagAdapter;
import javax.servlet.jsp.tagext.Tag;
import javax.servlet.jsp.tagext.SimpleTag;
import javax.servlet.jsp.tagext.JspTag;
import javax.servlet.jsp.tagext.SimpleTagSupport;

public final class TagAdapterTest_jsp extends org.apache.jasper.runtime.HttpJspBase
    implements org.apache.jasper.runtime.JspSourceDependent {


    private static TagAdapter getTagAdapter() {
        return new TagAdapter(new SimpleTagSupport());
    }


    public void tagAdapterCtorTest(HttpServletRequest req,
                                   HttpServletResponse res,
                                   JspWriter out)
    throws ServletException, IOException {
        TagAdapter adapter = getTagAdapter();
        if (adapter != null) {
            out.println("Test PASSED");
        } else {
            out.println("Test FAILED.  Unable to create new TagAdapter instanced via " +
                "the public constuctor.");
        }
    }


    public void tagAdapterSetPageContextTest(HttpServletRequest req,
                                             HttpServletResponse res,
                                             JspWriter out)
    throws ServletException, IOException {
        TagAdapter adapter = getTagAdapter();
        if (adapter != null) {
            try {
                adapter.setPageContext(null);
            } catch (Throwable t) {
                if (t instanceof UnsupportedOperationException) {
                    out.println("Test PASSED");
                } else {
                    out.println("Test FAILED.  Exception thrown when TagAdapter" +
                        ".setPageContext() was called, but was not an instance" +
                        " of UnsupportedOperationException.  Received: " +
                        t.getClass().getName());
                }
            }
        } else {
            out.println("Test FAILED.  TagAdapter was null.");
        }
    }


    public void tagAdapterSetParentTest(HttpServletRequest req,
                                        HttpServletResponse res,
                                        JspWriter out)
    throws ServletException, IOException {
        TagAdapter adapter = getTagAdapter();
        if (adapter != null) {
            try {
                adapter.setParent(null);
            } catch (Throwable t) {
                if (t instanceof UnsupportedOperationException) {
                    out.println("Test PASSED");
                } else {
                    out.println("Test FAILED.  Exception thrown when TagAdapter" +
                        ".setParent() was called, but was not an instance" +
                        " of UnsupportedOperationException.  Received: " +
                        t.getClass().getName());
                }
            }
        } else {
            out.println("Test FAILED.  TagAdapter was null.");
        }
    }


    public void tagAdapterGetParentTest(HttpServletRequest req,
                                        HttpServletResponse res,
                                        JspWriter out)
    throws ServletException, IOException {
        TagAdapter adapter = getTagAdapter();
        if (adapter != null) {
            boolean pass = false;
            JspTag adaptee = adapter.getAdaptee();
            if(adaptee == null) {
                out.println("Test FAILED.  adpatee is null.");
            } else if(adaptee instanceof SimpleTag) {
                Tag p1 = adapter.getParent();
                SimpleTag stg = (SimpleTag) adaptee; 
                JspTag p2 = stg.getParent();
                if(p1 == p2) {
                    out.println("Test PASSED. getParent() returns the same value as getAdaptee().getParent()");
                } else {
                    out.println("Test FAILED.  getParent() does not return the same value as getAdaptee().getParent()");
                }
            } else {
                out.println("Test PASSED. adaptee is not a SimpleTag and need to update tests.");
            }
        } else {
            out.println("Test FAILED.  TagAdapter was null.");
        }
    }


    public void tagAdapterDoStartTagTest(HttpServletRequest req,
                                        HttpServletResponse res,
                                        JspWriter out)
    throws ServletException, IOException {
        TagAdapter adapter = getTagAdapter();
        if (adapter != null) {
            try {
                adapter.doStartTag();
            } catch (Throwable t) {
                if (t instanceof UnsupportedOperationException) {
                    out.println("Test PASSED");
                } else if (t instanceof JspException) {
                    out.println("Test FAILED.  JspException was incorrectly" +
                        " thrown when calling doStartTag() on the TagAdapter.");
                } else {
                    out.println("Test FAILED.  Exception thrown when TagAdapter" +
                        ".doStartTag() was called, but was not an instance" +
                        " of UnsupportedOperationException.  Received: " +
                        t.getClass().getName());
                }
            }
        } else {
            out.println("Test FAILED.  TagAdapter was null.");
        }
    }


    public void tagAdapterDoEndTagTest(HttpServletRequest req,
                                       HttpServletResponse res,
                                       JspWriter out)
    throws ServletException, IOException {
        TagAdapter adapter = getTagAdapter();
        if (adapter != null) {
            try {
                adapter.doEndTag();
            } catch (Throwable t) {
                if (t instanceof UnsupportedOperationException) {
                    out.println("Test PASSED");
                } else if (t instanceof JspException) {
                    out.println("Test FAILED.  JspException was incorrectly" +
                        " thrown when calling doEndTag() on the TagAdapter.");
                } else {
                    out.println("Test FAILED.  Exception thrown when TagAdapter" +
                        ".doEndTag() was called, but was not an instance" +
                        " of UnsupportedOperationException.  Received: " +
                        t.getClass().getName());
                }
            }
        } else {
            out.println("Test FAILED.  TagAdapter was null.");
        }
    }


    public void tagAdapterReleaseTest(HttpServletRequest req,
                                      HttpServletResponse res,
                                      JspWriter out)
    throws ServletException, IOException {
        TagAdapter adapter = getTagAdapter();
        if (adapter != null) {
            try {
                adapter.release();
            } catch (Throwable t) {
                if (t instanceof UnsupportedOperationException) {
                    out.println("Test PASSED");
                } else {
                    out.println("Test FAILED.  Exception thrown when TagAdapter" +
                        ".release() was called, but was not an instance" +
                        " of UnsupportedOperationException.  Received: " +
                        t.getClass().getName());
                }
            }
        } else {
            out.println("Test FAILED.  TagAdapter was null.");
        }
    }

  private static final JspFactory _jspxFactory = JspFactory.getDefaultFactory();

  private static java.util.List<String> _jspx_dependants;

  private org.glassfish.jsp.api.ResourceInjector _jspx_resourceInjector;

  public java.util.List<String> getDependants() {
    return _jspx_dependants;
  }

  public void _jspService(HttpServletRequest request, HttpServletResponse response)
        throws java.io.IOException, ServletException {

    PageContext pageContext = null;
    HttpSession session = null;
    ServletContext application = null;
    ServletConfig config = null;
    JspWriter out = null;
    Object page = this;
    JspWriter _jspx_out = null;
    PageContext _jspx_page_context = null;

    try {
      response.setContentType("text/plain");
      response.setHeader("X-Powered-By", "JSP/2.3");
      pageContext = _jspxFactory.getPageContext(this, request, response,
      			null, true, 8192, true);
      _jspx_page_context = pageContext;
      application = pageContext.getServletContext();
      config = pageContext.getServletConfig();
      session = pageContext.getSession();
      out = pageContext.getOut();
      _jspx_out = out;
      _jspx_resourceInjector = (org.glassfish.jsp.api.ResourceInjector) application.getAttribute("com.sun.appserv.jsp.resource.injector");

      out.write("\n");
      out.write("\n");
      out.write("\n");
      out.write("\n");
      out.write("\n");
      out.write('\n');
      out.write('\n');
      out.write('\n');
      out.write('\n');
      out.write('\n');
      out.write('\n');
      out.write('\n');
      out.write('\n');
      out.write('\n');
      out.write('\n');
      out.write('\n');
      out.write('\n');
      out.write('\n');
      out.write('\n');
      out.write('\n');
      out.write('\n');
      out.write('\n');
      out.write('\n');
      out.write('\n');
      out.write('\n');
 JspTestUtil.invokeTest(this, request, response, out); 
      out.write('\n');
    } catch (Throwable t) {
      if (!(t instanceof SkipPageException)){
        out = _jspx_out;
        if (out != null && out.getBufferSize() != 0)
          out.clearBuffer();
        if (_jspx_page_context != null) _jspx_page_context.handlePageException(t);
        else throw new ServletException(t);
      }
    } finally {
      _jspxFactory.releasePageContext(_jspx_page_context);
    }
  }
}
