/*
 * Decompiled with CFR 0.152.
 */
package com.sun.data.provider.impl;

import com.sun.data.provider.DataProviderException;
import com.sun.data.provider.FieldKey;
import com.sun.data.provider.impl.AbstractDataProvider;
import java.beans.Beans;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class MapDataProvider
extends AbstractDataProvider {
    protected Map map = new HashMap();

    public MapDataProvider() {
    }

    public MapDataProvider(Map map) {
        this.setMap(map);
    }

    public Map getMap() {
        return this.map;
    }

    public void setMap(Map map) {
        this.map = map;
    }

    protected void refreshFieldKeys() {
        super.clearFieldKeys();
        ArrayList<Object> keys = new ArrayList<Object>();
        Iterator kit = this.map.keySet().iterator();
        while (kit.hasNext()) {
            Object o = kit.next();
            if (o instanceof FieldKey) {
                keys.add(o);
                continue;
            }
            keys.add(new MapFieldKey(o));
        }
        super.addFieldKeys(keys.toArray(new FieldKey[keys.size()]));
        super.sortFieldKeys();
    }

    public FieldKey[] getFieldKeys() throws DataProviderException {
        this.refreshFieldKeys();
        return super.getFieldKeys();
    }

    public FieldKey getFieldKey(String fieldId) throws DataProviderException {
        this.refreshFieldKeys();
        return super.getFieldKey(fieldId);
    }

    public Object getValue(FieldKey fieldKey) throws DataProviderException {
        if (Beans.isDesignTime() && (this.map == null || this.map.isEmpty())) {
            this.map = (Map)AbstractDataProvider.getFakeData(this.map.getClass());
        }
        if (fieldKey instanceof MapFieldKey) {
            return this.map.get(((MapFieldKey)fieldKey).mapKey);
        }
        return this.map.get(fieldKey.getFieldId());
    }

    public Class getType(FieldKey fieldKey) throws DataProviderException {
        Object o = this.getValue(fieldKey);
        return o != null ? o.getClass() : null;
    }

    public boolean isReadOnly(FieldKey fieldKey) throws DataProviderException {
        return false;
    }

    public void setValue(FieldKey fieldKey, Object value) throws DataProviderException {
        Object oldValue = this.getValue(fieldKey);
        if (fieldKey instanceof MapFieldKey) {
            this.map.put(((MapFieldKey)fieldKey).mapKey, value);
        } else {
            this.map.put(fieldKey.getFieldId(), value);
        }
        this.fireValueChanged(fieldKey, oldValue, value);
    }

    public class MapFieldKey
    extends FieldKey {
        protected Object mapKey;

        public MapFieldKey(Object mapKey) {
            super(String.valueOf(mapKey));
            this.mapKey = mapKey;
        }

        public Object getMapKey() {
            return this.mapKey;
        }

        public boolean equals(Object o) {
            if (o instanceof MapFieldKey) {
                MapFieldKey mdk = (MapFieldKey)o;
                return this.mapKey == mdk.mapKey || this.mapKey != null && this.mapKey.equals(mdk.mapKey);
            }
            return super.equals(o);
        }
    }
}

