/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.appclient.client.acc;

import com.sun.enterprise.container.common.spi.util.InjectionException;
import com.sun.enterprise.container.common.spi.util.InjectionManager;
import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.deployment.JndiNameEnvironment;
import com.sun.enterprise.security.appclient.integration.AppClientSecurityInfo;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.net.Authenticator;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.security.auth.callback.CallbackHandler;
import org.glassfish.appclient.client.acc.HttpAuthenticator;
import org.glassfish.appclient.client.acc.Util;
import org.glassfish.appclient.client.acc.config.ClientCredential;
import org.glassfish.appclient.client.acc.config.MessageSecurityConfig;
import org.glassfish.appclient.client.acc.config.TargetServer;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;

@Service
@PerLookup
public class AppClientContainerSecurityHelper {
    @Inject
    private InjectionManager injectionManager;
    @Inject
    private AppClientSecurityInfo secInfo;
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private ClassLoader classLoader;

    void init(TargetServer[] targetServers, List<MessageSecurityConfig> msgSecConfigs, Properties containerProperties, ClientCredential clientCredential, CallbackHandler callerSuppliedCallbackHandler, ClassLoader classLoader, ApplicationClientDescriptor acDesc, boolean isTextAuth) throws InstantiationException, IllegalAccessException, InjectionException, ClassNotFoundException, IOException {
        this.classLoader = classLoader == null ? Thread.currentThread().getContextClassLoader() : classLoader;
        this.initLoginConfig();
        CallbackHandler callbackHandler = this.initSecurity(callerSuppliedCallbackHandler, acDesc);
        this.secInfo.initializeSecurity(Arrays.asList(targetServers), msgSecConfigs, callbackHandler, AppClientSecurityInfo.CredentialType.USERNAME_PASSWORD, clientCredential == null ? null : clientCredential.getUserName(), clientCredential == null || clientCredential.getPassword() == null || clientCredential.getPassword().get() == null ? null : clientCredential.getPassword().get(), false, !isTextAuth);
        this.initHttpAuthenticator(AppClientSecurityInfo.CredentialType.USERNAME_PASSWORD);
    }

    private void initLoginConfig() throws IOException {
        URI configURI;
        String appclientloginConfContent = System.getProperty("appclient.login.conf.content");
        if (appclientloginConfContent == null) {
            File f = new File(System.getProperty("com.sun.aas.installRoot"));
            configURI = f.toURI().resolve("lib/appclient/appclientlogin.conf");
        } else {
            File tempFile = Util.writeTextToTempFile(appclientloginConfContent, "appclientlogin", ".conf", false);
            configURI = tempFile.toURI();
        }
        File configFile = new File(configURI);
        System.setProperty("java.security.auth.login.config", configFile.toURL().toString());
    }

    private CallbackHandler initSecurity(CallbackHandler callerSuppliedCallbackHandler, ApplicationClientDescriptor acDesc) throws InstantiationException, IllegalAccessException, InjectionException, ClassNotFoundException {
        CallbackHandler callbackHandler = callerSuppliedCallbackHandler;
        if (callerSuppliedCallbackHandler == null) {
            String descriptorCallbackHandlerClassName;
            callbackHandler = acDesc != null && (descriptorCallbackHandlerClassName = acDesc.getCallbackHandler()) != null ? this.newCallbackHandlerInstance(descriptorCallbackHandlerClassName, acDesc, this.classLoader) : null;
        }
        this.logger.config("Callback handler class = " + (callbackHandler == null ? "(default)" : callbackHandler.getClass().getName()));
        return callbackHandler;
    }

    private CallbackHandler newCallbackHandlerInstance(String callbackHandlerClassName, ApplicationClientDescriptor acDesc, ClassLoader loader) throws ClassNotFoundException, InstantiationException, IllegalAccessException, InjectionException {
        Class<?> callbackHandlerClass = Class.forName(callbackHandlerClassName, true, loader);
        return this.newCallbackHandlerInstance(callbackHandlerClass, acDesc);
    }

    private CallbackHandler newCallbackHandlerInstance(Class<? extends CallbackHandler> callbackHandlerClass, ApplicationClientDescriptor acDesc) throws InstantiationException, IllegalAccessException, InjectionException {
        CallbackHandler userHandler = callbackHandlerClass.newInstance();
        this.injectionManager.injectInstance((Object)userHandler, (JndiNameEnvironment)acDesc);
        return userHandler;
    }

    void clearClientSecurityContext() {
        this.secInfo.clearClientSecurityContext();
    }

    boolean isLoginCancelled() {
        return this.secInfo.isLoginCancelled();
    }

    private void initHttpAuthenticator(AppClientSecurityInfo.CredentialType loginType) {
        Authenticator.setDefault(new HttpAuthenticator(this.secInfo, loginType));
    }

    private static class CallbackHandlerInvocationHandler
    implements InvocationHandler {
        private CallbackHandler delegate;

        CallbackHandlerInvocationHandler(CallbackHandler handler) {
            this.delegate = handler;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            return method.invoke((Object)this.delegate, args);
        }

        void setDelegate(CallbackHandler handler) {
            this.delegate = handler;
        }
    }
}

