/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admingui.common.servlet;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import org.glassfish.admingui.common.servlet.DownloadServlet;
import org.glassfish.admingui.common.util.RestUtil;

public class LBConfigContentSource
implements DownloadServlet.ContentSource {
    @Override
    public String getId() {
        return "LBConfig";
    }

    @Override
    public InputStream getInputStream(DownloadServlet.Context ctx) {
        ctx.setAttribute("extension", "xml");
        HttpServletRequest request = (HttpServletRequest)ctx.getServletRequest();
        String lbName = request.getParameter("lbName");
        String restUrl = request.getParameter("restUrl");
        FileInputStream tmpFile = null;
        try {
            String endpoint = restUrl + "/load-balancers/load-balancer/" + lbName + "/export-http-lb-config";
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
            Date date = new Date();
            HashMap<String, Object> attrsMap = new HashMap<String, Object>();
            String tempDir = System.getProperty("java.io.tmpdir");
            String lbFileName = "loadbalancer.xml." + lbName + "_LB_CONFIG." + dateFormat.format(date);
            String slbFile = tempDir + System.getProperty("file.separator") + lbFileName;
            File lbFile = new File(slbFile);
            attrsMap.put("id", slbFile);
            RestUtil.postRestRequestFromServlet(request, endpoint, attrsMap, true, true);
            tmpFile = new FileInputStream(lbFile);
            boolean success = lbFile.delete();
            if (!success) {
                throw new Exception("Load Balancer config file delete failed");
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        ctx.setAttribute("tmpFile", tmpFile);
        return tmpFile;
    }

    @Override
    public void cleanUp(DownloadServlet.Context ctx) {
        InputStream tmpFile = (InputStream)ctx.getAttribute("tmpFile");
        if (tmpFile != null) {
            try {
                tmpFile.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        ctx.removeAttribute("tmpFile");
    }

    @Override
    public long getLastModified(DownloadServlet.Context context) {
        return -1L;
    }
}

