/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.BitSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.catalina.LogFacade;

public class URLEncoder {
    private static final Logger log = LogFacade.getLogger();
    static final char[] hexadecimal = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    protected BitSet safeCharacters = new BitSet(256);

    public URLEncoder() {
        char i;
        for (i = 'a'; i <= 'z'; i = (char)((char)(i + '\u0001'))) {
            this.addSafeCharacter(i);
        }
        for (i = 'A'; i <= 'Z'; i = (char)(i + '\u0001')) {
            this.addSafeCharacter(i);
        }
        for (i = '0'; i <= '9'; i = (char)(i + '\u0001')) {
            this.addSafeCharacter(i);
        }
    }

    public void addSafeCharacter(char c) {
        this.safeCharacters.set(c);
    }

    public String encode(String path) {
        int maxBytesPerChar = 10;
        int caseDiff = 32;
        StringBuilder rewrittenPath = new StringBuilder(path.length());
        ByteArrayOutputStream buf = new ByteArrayOutputStream(maxBytesPerChar);
        OutputStreamWriter writer = null;
        try {
            writer = new OutputStreamWriter((OutputStream)buf, "UTF8");
        }
        catch (UnsupportedEncodingException e) {
            log.log(Level.WARNING, "AS-WEB-CORE-00490", e);
            writer = new OutputStreamWriter(buf);
        }
        for (int i = 0; i < path.length(); ++i) {
            char c = path.charAt(i);
            if (this.safeCharacters.get(c)) {
                rewrittenPath.append(c);
                continue;
            }
            try {
                writer.write(c);
                writer.flush();
            }
            catch (IOException e) {
                buf.reset();
                continue;
            }
            byte[] ba = buf.toByteArray();
            for (int j = 0; j < ba.length; ++j) {
                byte toEncode = ba[j];
                rewrittenPath.append('%');
                int low = toEncode & 0xF;
                int high = (toEncode & 0xF0) >> 4;
                rewrittenPath.append(hexadecimal[high]);
                rewrittenPath.append(hexadecimal[low]);
            }
            buf.reset();
        }
        return rewrittenPath.toString();
    }
}

