/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.deployment.annotation.handlers;

import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WebComponentDescriptor;
import com.sun.enterprise.deployment.annotation.context.WebBundleContext;
import com.sun.enterprise.deployment.annotation.context.WebComponentContext;
import com.sun.enterprise.deployment.web.InitializationParameter;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.net.URLPattern;
import java.util.Arrays;
import java.util.logging.Level;
import javax.servlet.annotation.WebInitParam;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import org.glassfish.apf.AnnotatedElementHandler;
import org.glassfish.apf.AnnotationHandlerFor;
import org.glassfish.apf.AnnotationInfo;
import org.glassfish.apf.AnnotationProcessorException;
import org.glassfish.apf.HandlerProcessingResult;
import org.glassfish.apf.ResultType;
import org.glassfish.web.deployment.annotation.handlers.AbstractWebHandler;
import org.glassfish.web.deployment.annotation.handlers.WebFilterHandler;
import org.glassfish.web.deployment.descriptor.WebComponentDescriptorImpl;
import org.jvnet.hk2.annotations.Service;

@Service
@AnnotationHandlerFor(value=WebServlet.class)
public class WebServletHandler
extends AbstractWebHandler {
    protected static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(WebFilterHandler.class);

    @Override
    public HandlerProcessingResult processAnnotation(AnnotationInfo ainfo) throws AnnotationProcessorException {
        AnnotatedElementHandler aeHandler = ainfo.getProcessingContext().getHandler();
        if (aeHandler instanceof WebBundleContext) {
            WebBundleContext webBundleContext = (WebBundleContext)aeHandler;
            WebServlet webServletAn = (WebServlet)ainfo.getAnnotation();
            Class webCompClass = (Class)ainfo.getAnnotatedElement();
            String servletName = this.getServletName(webServletAn, webCompClass);
            WebComponentDescriptor webCompDesc = webBundleContext.getDescriptor().getWebComponentByCanonicalName(servletName);
            if (webCompDesc == null) {
                this.createWebComponentDescriptor(servletName, webCompClass, webBundleContext.getDescriptor());
            }
        }
        return super.processAnnotation(ainfo);
    }

    @Override
    protected HandlerProcessingResult processAnnotation(AnnotationInfo ainfo, WebComponentContext[] webCompContexts) throws AnnotationProcessorException {
        WebComponentContext webCompContext;
        HandlerProcessingResult result = null;
        WebComponentContext[] webComponentContextArray = webCompContexts;
        int n = webComponentContextArray.length;
        for (int i = 0; i < n && (result = this.processAnnotation(ainfo, (webCompContext = webComponentContextArray[i]).getDescriptor())).getOverallResult() != ResultType.FAILED; ++i) {
        }
        return result;
    }

    @Override
    protected HandlerProcessingResult processAnnotation(AnnotationInfo ainfo, WebBundleContext webBundleContext) throws AnnotationProcessorException {
        HandlerProcessingResult result;
        WebServlet webServletAn = (WebServlet)ainfo.getAnnotation();
        Class webCompClass = (Class)ainfo.getAnnotatedElement();
        String servletName = this.getServletName(webServletAn, webCompClass);
        WebComponentDescriptor webCompDesc = webBundleContext.getDescriptor().getWebComponentByCanonicalName(servletName);
        if (webCompDesc == null) {
            webCompDesc = this.createWebComponentDescriptor(servletName, webCompClass, webBundleContext.getDescriptor());
        }
        if ((result = this.processAnnotation(ainfo, webCompDesc)).getOverallResult() == ResultType.PROCESSED) {
            WebComponentContext webCompContext = new WebComponentContext(webCompDesc);
            webBundleContext.getProcessingContext().pushHandler((AnnotatedElementHandler)webCompContext);
        }
        return result;
    }

    private HandlerProcessingResult processAnnotation(AnnotationInfo ainfo, WebComponentDescriptor webCompDesc) throws AnnotationProcessorException {
        WebInitParam[] initParams;
        Class webCompClass = (Class)ainfo.getAnnotatedElement();
        if (!HttpServlet.class.isAssignableFrom(webCompClass)) {
            this.log(Level.SEVERE, ainfo, localStrings.getLocalString("web.deployment.annotation.handlers.needtoextend", "The Class {0} having annotation {1} need to be a derived class of {2}.", new Object[]{webCompClass.getName(), WebServlet.class.getName(), HttpServlet.class.getName()}));
            return this.getDefaultFailedResult();
        }
        WebServlet webServletAn = (WebServlet)ainfo.getAnnotation();
        String servletName = this.getServletName(webServletAn, webCompClass);
        if (!servletName.equals(webCompDesc.getCanonicalName())) {
            return this.getDefaultProcessedResult();
        }
        String webCompImpl = webCompDesc.getWebComponentImplementation();
        if (!(webCompImpl == null || webCompImpl.length() <= 0 || webCompImpl.equals(webCompClass.getName()) && webCompDesc.isServlet())) {
            String messageKey = null;
            String defaultMessage = null;
            if (webCompDesc.isServlet()) {
                messageKey = "web.deployment.annotation.handlers.servletimpldontmatch";
                defaultMessage = "The servlet ''{0}'' has implementation ''{1}'' in xml. It does not match with ''{2}'' from annotation @{3}.";
            } else {
                messageKey = "web.deployment.annotation.handlers.servletimpljspdontmatch";
                defaultMessage = "The servlet ''{0}'' is a jsp ''{1}'' in xml. It does not match with ''{2}'' from annotation @{3}.";
            }
            this.log(Level.SEVERE, ainfo, localStrings.getLocalString(messageKey, defaultMessage, new Object[]{webCompDesc.getCanonicalName(), webCompImpl, webCompClass.getName(), WebServlet.class.getName()}));
            return this.getDefaultFailedResult();
        }
        webCompDesc.setServlet(true);
        webCompDesc.setWebComponentImplementation(webCompClass.getName());
        if (webCompDesc.getUrlPatternsSet().size() == 0) {
            Object[] urlPatterns = webServletAn.urlPatterns();
            if (urlPatterns == null || urlPatterns.length == 0) {
                urlPatterns = webServletAn.value();
            }
            boolean validUrlPatterns = true;
            if (urlPatterns != null && urlPatterns.length > 0) {
                Object[] objectArray = urlPatterns;
                int n = objectArray.length;
                for (int i = 0; i < n; ++i) {
                    Object up = objectArray[i];
                    if (!URLPattern.isValid((String)up)) {
                        validUrlPatterns = false;
                        break;
                    }
                    webCompDesc.addUrlPattern((String)up);
                }
            }
            if (!validUrlPatterns) {
                String urlPatternString = urlPatterns != null ? Arrays.toString(urlPatterns) : "";
                throw new IllegalArgumentException(localStrings.getLocalString("web.deployment.annotation.handlers.invalidUrlPatterns", "Invalid url patterns for {0}: {1}.", new Object[]{webCompClass, urlPatternString}));
            }
        }
        if (webCompDesc.getLoadOnStartUp() == null) {
            webCompDesc.setLoadOnStartUp(Integer.valueOf(webServletAn.loadOnStartup()));
        }
        if ((initParams = webServletAn.initParams()) != null && initParams.length > 0) {
            for (WebInitParam initParam : initParams) {
                webCompDesc.addInitializationParameter((InitializationParameter)new EnvironmentProperty(initParam.name(), initParam.value(), initParam.description()));
            }
        }
        if (webCompDesc.getSmallIconUri() == null) {
            webCompDesc.setSmallIconUri(webServletAn.smallIcon());
        }
        if (webCompDesc.getLargeIconUri() == null) {
            webCompDesc.setLargeIconUri(webServletAn.largeIcon());
        }
        if (webCompDesc.getDescription() == null || webCompDesc.getDescription().length() == 0) {
            webCompDesc.setDescription(webServletAn.description());
        }
        if (webCompDesc.getDisplayName() == null || webCompDesc.getDisplayName().length() == 0) {
            webCompDesc.setDisplayName(webServletAn.displayName());
        }
        if (webCompDesc.isAsyncSupported() == null) {
            webCompDesc.setAsyncSupported(Boolean.valueOf(webServletAn.asyncSupported()));
        }
        return this.getDefaultProcessedResult();
    }

    private String getServletName(WebServlet webServletAn, Class<?> webCompClass) {
        String servletName = webServletAn.name();
        if (servletName == null || servletName.length() == 0) {
            servletName = webCompClass.getName();
        }
        return servletName;
    }

    private WebComponentDescriptor createWebComponentDescriptor(String servletName, Class<?> webCompClass, WebBundleDescriptor webBundleDescriptor) {
        WebComponentDescriptorImpl webCompDesc = new WebComponentDescriptorImpl();
        webCompDesc.setName(servletName);
        webCompDesc.setCanonicalName(servletName);
        webCompDesc.setServlet(true);
        webCompDesc.setWebComponentImplementation(webCompClass.getName());
        webBundleDescriptor.addWebComponentDescriptor((WebComponentDescriptor)webCompDesc);
        return webCompDesc;
    }
}

