/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors.util;

import com.sun.enterprise.connectors.util.JarResourceExtractor;
import java.security.SecureClassLoader;

public class ConnectorRARClassLoader
extends SecureClassLoader {
    private JarResourceExtractor jarResources;

    public ConnectorRARClassLoader(String jarName, ClassLoader parent) {
        super(parent);
        this.jarResources = new JarResourceExtractor(jarName);
    }

    protected byte[] loadClassBytes(String className) {
        className = this.formatClassName(className);
        return this.jarResources.getResource(className);
    }

    public Class findClass(String name) throws ClassNotFoundException {
        byte[] b = this.loadClassBytes(name);
        if (b == null) {
            throw new ClassNotFoundException(name);
        }
        return this.defineClass(name, b, 0, b.length);
    }

    private String formatClassName(String className) {
        return className.replace('.', '/') + ".class";
    }

    public String getResourceAsString(String raDeploymentDescPath) {
        return new String(this.jarResources.getResource(raDeploymentDescPath));
    }
}

