/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.util;

import java.io.IOException;
import java.io.Writer;

public class XMLWriter {
    public static final int OPENING = 0;
    public static final int CLOSING = 1;
    public static final int NO_CONTENT = 2;
    protected StringBuilder buffer = new StringBuilder();
    protected Writer writer = null;

    public XMLWriter() {
    }

    public XMLWriter(Writer writer) {
        this.writer = writer;
    }

    public String toString() {
        return this.buffer.toString();
    }

    public void writeProperty(String namespace, String namespaceInfo, String name, String value) {
        this.writeElement(namespace, namespaceInfo, name, 0);
        this.buffer.append(value);
        this.writeElement(namespace, namespaceInfo, name, 1);
    }

    public void writeProperty(String namespace, String name, String value) {
        this.writeElement(namespace, name, 0);
        this.buffer.append(value);
        this.writeElement(namespace, name, 1);
    }

    public void writeProperty(String namespace, String name) {
        this.writeElement(namespace, name, 2);
    }

    public void writeElement(String namespace, String name, int type) {
        this.writeElement(namespace, null, name, type);
    }

    public void writeElement(String namespace, String namespaceInfo, String name, int type) {
        if (namespace != null && namespace.length() > 0) {
            switch (type) {
                case 0: {
                    if (namespaceInfo != null) {
                        this.buffer.append("<" + namespace + ":" + name + " xmlns:" + namespace + "=\"" + namespaceInfo + "\">");
                        break;
                    }
                    this.buffer.append("<" + namespace + ":" + name + ">");
                    break;
                }
                case 1: {
                    this.buffer.append("</" + namespace + ":" + name + ">\n");
                    break;
                }
                default: {
                    if (namespaceInfo != null) {
                        this.buffer.append("<" + namespace + ":" + name + " xmlns:" + namespace + "=\"" + namespaceInfo + "\"/>");
                        break;
                    }
                    this.buffer.append("<" + namespace + ":" + name + "/>");
                    break;
                }
            }
        } else {
            switch (type) {
                case 0: {
                    this.buffer.append("<" + name + ">");
                    break;
                }
                case 1: {
                    this.buffer.append("</" + name + ">\n");
                    break;
                }
                default: {
                    this.buffer.append("<" + name + "/>");
                }
            }
        }
    }

    public void writeText(String text) {
        this.buffer.append(text);
    }

    public void writeData(String data) {
        this.buffer.append("<![CDATA[" + data + "]]>");
    }

    public void writeXMLHeader() {
        this.buffer.append("<?xml version=\"1.0\" encoding=\"utf-8\" ?>\n");
    }

    public void sendData() throws IOException {
        if (this.writer != null) {
            this.writer.write(this.buffer.toString());
            this.buffer = new StringBuilder();
        }
    }
}

