/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.osgijavaeebase;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import org.glassfish.osgijavaeebase.BundleClassLoader;

public class TempBundleClassLoader
extends ClassLoader {
    private BundleClassLoader delegate;

    public TempBundleClassLoader(BundleClassLoader delegate) {
        super(delegate.getParent());
        this.delegate = delegate;
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        String packageName;
        String entryName = name.replace('.', '/') + ".class";
        URL url = this.delegate.getResource(entryName);
        if (url == null) {
            throw new ClassNotFoundException(name);
        }
        InputStream inputStream = null;
        byte[] bytes = null;
        try {
            inputStream = url.openStream();
            bytes = this.getClassData(inputStream);
        }
        catch (IOException e) {
            throw new ClassNotFoundException(name, e);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
        int lastPackageSep = name.lastIndexOf(46);
        if (lastPackageSep != -1 && this.getPackage(packageName = name.substring(0, lastPackageSep)) == null) {
            try {
                this.definePackage(packageName, null, null, null, null, null, null, null);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        Class<?> clazz = null;
        try {
            clazz = this.defineClass(name, bytes, 0, bytes.length, null);
            return clazz;
        }
        catch (UnsupportedClassVersionError ucve) {
            throw new UnsupportedClassVersionError(name + " can't be defined as we are running in Java version" + System.getProperty("java.version"));
        }
    }

    @Override
    public URL getResource(String name) {
        return this.delegate.getResource(name);
    }

    @Override
    public Enumeration<URL> findResources(String name) throws IOException {
        return this.delegate.getResources(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getClassData(InputStream istream) throws IOException {
        BufferedInputStream bstream = new BufferedInputStream(istream);
        byte[] buf = new byte[4096];
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        int num = 0;
        try {
            while ((num = bstream.read(buf)) != -1) {
                bout.write(buf, 0, num);
            }
        }
        finally {
            if (bstream != null) {
                bstream.close();
            }
        }
        return bout.toByteArray();
    }
}

