/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.encoding.literal;

import com.sun.xml.rpc.encoding.DeserializationException;
import com.sun.xml.rpc.encoding.SOAPDeserializationContext;
import com.sun.xml.rpc.encoding.SOAPSerializationContext;
import com.sun.xml.rpc.encoding.SerializerBase;
import com.sun.xml.rpc.encoding.literal.LiteralObjectSerializerBase;
import com.sun.xml.rpc.streaming.Attributes;
import com.sun.xml.rpc.streaming.XMLReader;
import com.sun.xml.rpc.streaming.XMLReaderUtil;
import com.sun.xml.rpc.streaming.XMLWriter;
import com.sun.xml.rpc.streaming.XmlTreeReader;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.soap.Detail;
import javax.xml.soap.DetailEntry;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;

public class DetailFragmentDeserializer
extends LiteralObjectSerializerBase {
    protected SOAPFactory soapFactory;
    private static final String FIRST_PREFIX = "ns";

    public DetailFragmentDeserializer(QName type, String encodingStyle) {
        this(type, false, encodingStyle);
    }

    public DetailFragmentDeserializer(QName type, boolean isNillable, String encodingStyle) {
        super(type, isNillable, encodingStyle);
        try {
            this.soapFactory = SOAPFactory.newInstance();
        }
        catch (SOAPException sOAPException) {
            // empty catch block
        }
    }

    @Override
    protected void writeAdditionalNamespaceDeclarations(Object obj, XMLWriter writer) throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object internalDeserialize(QName name, XMLReader reader, SOAPDeserializationContext context) throws Exception {
        boolean pushedEncodingStyle = context.processEncodingStyle(reader);
        try {
            QName actualName;
            context.verifyEncodingStyle(this.encodingStyle);
            if (name != null && !(actualName = reader.getName()).equals(name)) {
                throw new DeserializationException("xsd.unexpectedElementName", new Object[]{name.toString(), actualName.toString()});
            }
            Attributes attrs = reader.getAttributes();
            String nullVal = attrs.getValue("http://www.w3.org/2001/XMLSchema-instance", "nil");
            boolean isNull = nullVal != null && SerializerBase.decodeBoolean(nullVal);
            Object obj = null;
            if (isNull) {
                if (!this.isNullable) {
                    throw new DeserializationException("xsd.unexpectedNull");
                }
                reader.next();
            } else {
                obj = this.doDeserialize(reader, context);
            }
            XMLReaderUtil.verifyReaderState(reader, 2);
            Object object = obj;
            return object;
        }
        finally {
            if (pushedEncodingStyle) {
                context.popEncodingStyle();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object deserializeElement(QName name, XMLReader reader, SOAPDeserializationContext context) throws Exception {
        boolean pushedEncodingStyle = context.processEncodingStyle(reader);
        try {
            QName actualName;
            context.verifyEncodingStyle(this.encodingStyle);
            if (name != null && !(actualName = reader.getName()).equals(name)) {
                throw new DeserializationException("xsd.unexpectedElementName", new Object[]{name.toString(), actualName.toString()});
            }
            Attributes attrs = reader.getAttributes();
            String nullVal = attrs.getValue("http://www.w3.org/2001/XMLSchema-instance", "nil");
            boolean isNull = nullVal != null && SerializerBase.decodeBoolean(nullVal);
            Object obj = null;
            if (isNull) {
                reader.next();
            } else {
                obj = this.doDeserializeElement(reader, context);
            }
            XMLReaderUtil.verifyReaderState(reader, 2);
            Object object = obj;
            return object;
        }
        finally {
            if (pushedEncodingStyle) {
                context.popEncodingStyle();
            }
        }
    }

    @Override
    protected Object doDeserialize(XMLReader reader, SOAPDeserializationContext context) throws Exception {
        Detail detail = this.soapFactory.createDetail();
        String elementURI = reader.getURI();
        Name name = elementURI == null || elementURI.equals("") ? this.soapFactory.createName(reader.getLocalName()) : this.soapFactory.createName(reader.getLocalName(), FIRST_PREFIX, elementURI);
        DetailEntry entry = detail.addDetailEntry(name);
        this.doDeserializeElement((SOAPElement)entry, reader, context);
        return detail;
    }

    protected Object doDeserializeElement(XMLReader reader, SOAPDeserializationContext context) throws Exception {
        SOAPElement soapElement;
        String elementURI = reader.getURI();
        SOAPElement element = elementURI == null || elementURI.equals("") ? this.soapFactory.createElement(reader.getLocalName()) : (reader instanceof XmlTreeReader ? ((soapElement = (SOAPElement)((XmlTreeReader)reader).getCurrentNode()) != null && soapElement.getPrefix() == null ? this.soapFactory.createElement(reader.getLocalName(), null, null) : this.soapFactory.createElement(reader.getLocalName(), FIRST_PREFIX, reader.getURI())) : this.soapFactory.createElement(reader.getLocalName(), FIRST_PREFIX, reader.getURI()));
        this.doDeserializeElement(element, reader, context);
        return element;
    }

    protected void doDeserializeElement(SOAPElement element, XMLReader reader, SOAPDeserializationContext context) throws Exception {
        String defaultURI = reader.getURI("");
        if (defaultURI != null) {
            element.addNamespaceDeclaration("", defaultURI);
        }
        Iterator iter = reader.getPrefixes();
        while (iter.hasNext()) {
            String prefix = (String)iter.next();
            String uri = reader.getURI(prefix);
            element.addNamespaceDeclaration(prefix, uri);
        }
        Attributes attributes = reader.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Name name;
            if (attributes.isNamespaceDeclaration(i)) continue;
            String uri = attributes.getURI(i);
            if (uri == null) {
                name = this.soapFactory.createName(attributes.getLocalName(i));
            } else {
                String prefix = attributes.getPrefix(i);
                name = this.soapFactory.createName(attributes.getLocalName(i), prefix, uri);
            }
            element.addAttribute(name, attributes.getValue(i));
        }
        reader.next();
        while (reader.getState() != 2) {
            int state = reader.getState();
            if (state == 1) {
                SOAPElement child = (SOAPElement)this.deserializeElement(null, reader, context);
                element.addChildElement(child);
            } else if (state == 3) {
                element.addTextNode(reader.getValue());
            }
            reader.next();
        }
    }

    @Override
    protected void doSerialize(Object obj, XMLWriter writer, SOAPSerializationContext context) throws Exception {
    }

    @Override
    protected void doSerializeAttributes(Object obj, XMLWriter writer, SOAPSerializationContext context) throws Exception {
    }
}

