/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.batch;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import java.beans.PropertyVetoException;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.batch.spi.impl.BatchRuntimeConfiguration;
import org.glassfish.batch.spi.impl.GlassFishBatchValidationException;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.Target;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="set-batch-runtime-configuration")
@PerLookup
@CommandLock(value=CommandLock.LockType.NONE)
@I18n(value="set.batch.runtime.configuration")
@ExecuteOn(value={RuntimeType.DAS})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER})
@RestEndpoints(value={@RestEndpoint(configBean=Domain.class, opType=RestEndpoint.OpType.POST, path="set-batch-runtime-configuration", description="Set Batch Runtime Configuration")})
public class SetBatchRuntimeConfiguration
implements AdminCommand {
    @Inject
    ServiceLocator serviceLocator;
    @Inject
    protected Logger logger;
    @Param(name="target", optional=true, defaultValue="server")
    protected String target;
    @Inject
    protected Target targetUtil;
    @Param(name="dataSourceLookupName", shortName="d", optional=true)
    private String dataSourceLookupName;
    @Param(name="executorServiceLookupName", shortName="x", optional=true)
    private String executorServiceLookupName;

    public void execute(final AdminCommandContext context) {
        final ActionReport actionReport = context.getActionReport();
        Properties extraProperties = actionReport.getExtraProperties();
        if (extraProperties == null) {
            extraProperties = new Properties();
            actionReport.setExtraProperties(extraProperties);
        }
        if (this.dataSourceLookupName == null && this.executorServiceLookupName == null) {
            actionReport.setMessage("Either dataSourceLookupName or executorServiceLookupName must be specified.");
            actionReport.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        try {
            Config config = this.targetUtil.getConfig(this.target);
            System.out.println("** EXECUTING -d " + this.dataSourceLookupName + "  -x " + this.executorServiceLookupName);
            BatchRuntimeConfiguration batchRuntimeConfiguration = (BatchRuntimeConfiguration)config.getExtensionByType(BatchRuntimeConfiguration.class);
            if (batchRuntimeConfiguration != null) {
                ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<BatchRuntimeConfiguration>(){

                    public Object run(BatchRuntimeConfiguration batchRuntimeConfigurationProxy) throws PropertyVetoException, TransactionFailure {
                        boolean encounteredError = false;
                        if (SetBatchRuntimeConfiguration.this.dataSourceLookupName != null) {
                            try {
                                SetBatchRuntimeConfiguration.this.validateDataSourceLookupName(context, SetBatchRuntimeConfiguration.this.target, SetBatchRuntimeConfiguration.this.dataSourceLookupName);
                                batchRuntimeConfigurationProxy.setDataSourceLookupName(SetBatchRuntimeConfiguration.this.dataSourceLookupName);
                                actionReport.setActionExitCode(ActionReport.ExitCode.SUCCESS);
                            }
                            catch (GlassFishBatchValidationException ex) {
                                SetBatchRuntimeConfiguration.this.logger.log(Level.WARNING, ex.getMessage());
                                actionReport.setMessage(SetBatchRuntimeConfiguration.this.dataSourceLookupName + " is not mapped to a DataSource");
                                actionReport.setActionExitCode(ActionReport.ExitCode.FAILURE);
                                throw new GlassFishBatchValidationException(SetBatchRuntimeConfiguration.this.dataSourceLookupName + " is not mapped to a DataSource");
                            }
                        }
                        if (SetBatchRuntimeConfiguration.this.executorServiceLookupName != null && !encounteredError) {
                            try {
                                SetBatchRuntimeConfiguration.this.validateExecutorServiceLookupName(context, SetBatchRuntimeConfiguration.this.target, SetBatchRuntimeConfiguration.this.executorServiceLookupName);
                                batchRuntimeConfigurationProxy.setExecutorServiceLookupName(SetBatchRuntimeConfiguration.this.executorServiceLookupName);
                                actionReport.setActionExitCode(ActionReport.ExitCode.SUCCESS);
                            }
                            catch (GlassFishBatchValidationException ex) {
                                SetBatchRuntimeConfiguration.this.logger.log(Level.WARNING, ex.getMessage());
                                actionReport.setMessage("No executor service bound to name = " + SetBatchRuntimeConfiguration.this.executorServiceLookupName);
                                actionReport.setActionExitCode(ActionReport.ExitCode.FAILURE);
                                throw new GlassFishBatchValidationException("No executor service bound to name = " + SetBatchRuntimeConfiguration.this.executorServiceLookupName);
                            }
                        }
                        return null;
                    }
                }, (ConfigBeanProxy)batchRuntimeConfiguration);
            }
        }
        catch (TransactionFailure txfEx) {
            this.logger.log(Level.WARNING, "Exception during command ", txfEx);
            actionReport.setMessage(txfEx.getCause().getMessage());
            actionReport.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
    }

    public void validateDataSourceLookupName(AdminCommandContext context, String targetName, String dsLookupName) {
        try {
            CommandRunner runner = (CommandRunner)this.serviceLocator.getService(CommandRunner.class, new Annotation[0]);
            ActionReport subReport = context.getActionReport().addSubActionsReport();
            CommandRunner.CommandInvocation inv = runner.getCommandInvocation("list-jdbc-resources", subReport, context.getSubject());
            ParameterMap params = new ParameterMap();
            params.add((Object)"target", (Object)targetName);
            inv.parameters(params);
            inv.execute();
            Properties props = subReport.getExtraProperties();
            if (props != null && props.get("jdbcResources") != null) {
                List map = (List)props.get("jdbcResources");
                for (HashMap e : map) {
                    if (!((String)e.get("name")).equals(dsLookupName)) continue;
                    return;
                }
            }
            throw new GlassFishBatchValidationException("No DataSource mapped to " + dsLookupName);
        }
        catch (Exception ex) {
            throw new GlassFishBatchValidationException("Exception during validation: ", (Throwable)ex);
        }
    }

    public void validateExecutorServiceLookupName(AdminCommandContext context, String targetName, String exeLookupName) {
        if ("concurrent/__defaultManagedExecutorService".equals(exeLookupName)) {
            return;
        }
        try {
            CommandRunner runner = (CommandRunner)this.serviceLocator.getService(CommandRunner.class, new Annotation[0]);
            ActionReport subReport = context.getActionReport().addSubActionsReport();
            CommandRunner.CommandInvocation inv = runner.getCommandInvocation("list-managed-executor-services", subReport, context.getSubject());
            ParameterMap params = new ParameterMap();
            params.add((Object)"target", (Object)targetName);
            inv.parameters(params);
            inv.execute();
            Properties props = subReport.getExtraProperties();
            if (props != null && props.get("managedExecutorServices") != null) {
                List map = (List)props.get("managedExecutorServices");
                for (HashMap e : map) {
                    if (!((String)e.get("name")).equals(exeLookupName)) continue;
                    return;
                }
            }
            throw new GlassFishBatchValidationException("No ExecutorService mapped to " + exeLookupName);
        }
        catch (Exception ex) {
            throw new GlassFishBatchValidationException("Exception during validation: ", (Throwable)ex);
        }
    }
}

