/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.transport;

import com.sun.corba.ee.spi.ior.IOR;
import com.sun.corba.ee.spi.ior.TaggedComponent;
import com.sun.corba.ee.spi.ior.iiop.AlternateIIOPAddressComponent;
import com.sun.corba.ee.spi.ior.iiop.IIOPAddress;
import com.sun.corba.ee.spi.ior.iiop.IIOPProfileTemplate;
import com.sun.corba.ee.spi.transport.IORToSocketInfo;
import com.sun.corba.ee.spi.transport.SocketInfo;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class DefaultIORToSocketInfoImpl
implements IORToSocketInfo {
    @Override
    public List<? extends SocketInfo> getSocketInfo(IOR ior, List<? extends SocketInfo> previous) {
        if (!previous.isEmpty()) {
            return previous;
        }
        ArrayList<SocketInfo> result = new ArrayList<SocketInfo>();
        IIOPProfileTemplate iiopProfileTemplate = (IIOPProfileTemplate)ior.getProfile().getTaggedProfileTemplate();
        IIOPAddress primary = iiopProfileTemplate.getPrimaryAddress();
        String hostname = primary.getHost().toLowerCase();
        int port = primary.getPort();
        SocketInfo socketInfo = this.createSocketInfo(hostname, port);
        result.add(socketInfo);
        Iterator<TaggedComponent> iterator = iiopProfileTemplate.iteratorById(3);
        while (iterator.hasNext()) {
            AlternateIIOPAddressComponent alternate = (AlternateIIOPAddressComponent)iterator.next();
            hostname = alternate.getAddress().getHost().toLowerCase();
            port = alternate.getAddress().getPort();
            socketInfo = this.createSocketInfo(hostname, port);
            result.add(socketInfo);
        }
        return result;
    }

    private SocketInfo createSocketInfo(final String hostname, final int port) {
        return new SocketInfo(){

            @Override
            public String getType() {
                return "IIOP_CLEAR_TEXT";
            }

            @Override
            public String getHost() {
                return hostname;
            }

            @Override
            public int getPort() {
                return port;
            }
        };
    }
}

