/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.deployment.node.runtime.gf;

import com.sun.enterprise.deployment.node.XMLElement;
import com.sun.enterprise.deployment.node.runtime.RuntimeDescriptorNode;
import org.glassfish.web.deployment.node.runtime.gf.LocaleCharsetMapNode;
import org.glassfish.web.deployment.runtime.LocaleCharsetInfo;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;

public class LocaleCharsetInfoNode
extends RuntimeDescriptorNode<LocaleCharsetInfo> {
    protected LocaleCharsetInfo descriptor = null;

    public LocaleCharsetInfoNode() {
        this.registerElementHandler(new XMLElement("locale-charset-map"), LocaleCharsetMapNode.class, "addLocaleCharsetMap");
    }

    public LocaleCharsetInfo getDescriptor() {
        if (this.descriptor == null) {
            this.descriptor = new LocaleCharsetInfo();
        }
        return this.descriptor;
    }

    public void startElement(XMLElement element, Attributes attributes) {
        if (element.getQName().equals("locale-charset-info")) {
            LocaleCharsetInfo info = this.getDescriptor();
            for (int i = 0; i < attributes.getLength(); ++i) {
                if (!"default-locale".equals(attributes.getQName(i))) continue;
                info.setAttributeValue("DefaultLocale", attributes.getValue(i));
            }
        } else if (element.getQName().equals("parameter-encoding")) {
            LocaleCharsetInfo info = this.getDescriptor();
            info.setParameterEncoding(true);
            for (int i = 0; i < attributes.getLength(); ++i) {
                if ("default-charset".equals(attributes.getQName(i))) {
                    info.setAttributeValue("ParameterEncoding", "DefaultCharset", attributes.getValue(i));
                }
                if (!"form-hint-field".equals(attributes.getQName(i))) continue;
                info.setAttributeValue("ParameterEncoding", "FormHintField", attributes.getValue(i));
            }
        } else {
            super.startElement(element, attributes);
        }
    }

    public Node writeDescriptor(Node parent, String nodeName, LocaleCharsetInfo descriptor) {
        Element locale = (Element)super.writeDescriptor(parent, nodeName, (Object)descriptor);
        if (descriptor.sizeLocaleCharsetMap() > 0) {
            LocaleCharsetMapNode lcmn = new LocaleCharsetMapNode();
            for (int i = 0; i < descriptor.sizeLocaleCharsetMap(); ++i) {
                lcmn.writeDescriptor((Node)locale, "locale-charset-map", descriptor.getLocaleCharsetMap(i));
            }
        }
        if (descriptor.isParameterEncoding()) {
            Element parameter = LocaleCharsetInfoNode.appendChild((Node)locale, (String)"parameter-encoding");
            if (descriptor.getAttributeValue("ParameterEncoding", "FormHintField") != null) {
                LocaleCharsetInfoNode.setAttribute((Element)parameter, (String)"form-hint-field", (String)descriptor.getAttributeValue("ParameterEncoding", "FormHintField"));
            }
            if (descriptor.getAttributeValue("ParameterEncoding", "DefaultCharset") != null) {
                LocaleCharsetInfoNode.setAttribute((Element)parameter, (String)"default-charset", (String)descriptor.getAttributeValue("ParameterEncoding", "DefaultCharset"));
            }
        }
        if (descriptor.getAttributeValue("DefaultLocale") != null) {
            LocaleCharsetInfoNode.setAttribute((Element)locale, (String)"default-locale", (String)descriptor.getAttributeValue("DefaultLocale"));
        }
        return locale;
    }
}

