/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.appclient.server.core;

import com.sun.enterprise.deploy.shared.AbstractArchiveHandler;
import com.sun.enterprise.loader.ASURLClassLoader;
import com.sun.enterprise.security.perms.PermsArchiveDelegate;
import com.sun.enterprise.security.perms.SMGlobalPolicyUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Named;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.archive.ArchiveDetector;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.jvnet.hk2.annotations.Service;

@Service(name="car")
public class CarHandler
extends AbstractArchiveHandler {
    @Inject
    @Named(value="car")
    private ArchiveDetector detector;
    private static final Logger _logger = Logger.getLogger("javax.enterprise.system.container.appclient", "org.glassfish.appclient.server.LogMessages");

    public String getArchiveType() {
        return this.detector.getArchiveType().toString();
    }

    public String getVersionIdentifier(ReadableArchive archive) {
        String versionIdentifier = null;
        try {
            GFCarXMLParser gfXMLParser = new GFCarXMLParser();
            versionIdentifier = gfXMLParser.extractVersionIdentifierValue(archive);
        }
        catch (IOException e) {
            _logger.log(Level.SEVERE, e.getMessage());
        }
        catch (XMLStreamException e) {
            _logger.log(Level.SEVERE, e.getMessage());
        }
        return versionIdentifier;
    }

    public boolean handles(ReadableArchive archive) throws IOException {
        return this.detector.handles(archive);
    }

    public ClassLoader getClassLoader(final ClassLoader parent, DeploymentContext context) {
        ASURLClassLoader cloader = AccessController.doPrivileged(new PrivilegedAction<ASURLClassLoader>(){

            @Override
            public ASURLClassLoader run() {
                return new ASURLClassLoader(parent);
            }
        });
        try {
            cloader.addURL(context.getSource().getURI().toURL());
            for (URL url : this.getManifestLibraries(context)) {
                cloader.addURL(url);
            }
            try {
                DeploymentContext dc = context;
                ASURLClassLoader cl = cloader;
                AccessController.doPrivileged(new PermsArchiveDelegate.SetPermissionsAction(SMGlobalPolicyUtil.CommponentType.car, dc, (ClassLoader)cl));
            }
            catch (PrivilegedActionException e) {
                throw new SecurityException(e.getException());
            }
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        return cloader;
    }

    private static class GFCarXMLParser {
        private XMLStreamReader parser = null;

        private GFCarXMLParser() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected String extractVersionIdentifierValue(ReadableArchive archive) throws XMLStreamException, IOException {
            InputStream input = null;
            String versionIdentifierValue = null;
            String rootElement = null;
            try {
                rootElement = "glassfish-application-client";
                input = archive.getEntry("META-INF/glassfish-application-client.xml");
                if (input != null) {
                    this.parser = CarHandler.getXMLInputFactory().createXMLStreamReader(input);
                    int event = 0;
                    this.skipRoot(rootElement);
                    while (this.parser.hasNext() && (event = this.parser.next()) != 8) {
                        if (event != 1) continue;
                        String name = this.parser.getLocalName();
                        if ("version-identifier".equals(name)) {
                            versionIdentifierValue = this.parser.getElementText();
                            continue;
                        }
                        this.skipSubTree(name);
                    }
                }
            }
            finally {
                if (this.parser != null) {
                    this.parser.close();
                }
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (Exception exception) {}
                }
            }
            return versionIdentifierValue;
        }

        private void skipRoot(String name) throws XMLStreamException {
            int event;
            while ((event = this.parser.next()) != 1) {
            }
            if (!name.equals(this.parser.getLocalName())) {
                throw new XMLStreamException();
            }
        }

        private void skipSubTree(String name) throws XMLStreamException {
            int event;
            do {
                if ((event = this.parser.next()) != 8) continue;
                throw new XMLStreamException();
            } while (event != 2 || !name.equals(this.parser.getLocalName()));
        }
    }
}

