/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.webservices;

import com.sun.xml.messaging.saaj.util.ByteInputStream;
import com.sun.xml.rpc.spi.JaxRpcObjectFactory;
import com.sun.xml.rpc.spi.runtime.SOAPConstants;
import com.sun.xml.rpc.spi.runtime.SOAPMessageContext;
import com.sun.xml.rpc.spi.runtime.StreamingHandler;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.namespace.QName;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.glassfish.ejb.api.EJBInvocation;
import org.glassfish.internal.api.Globals;
import org.glassfish.webservices.Ejb2RuntimeEndpointInfo;
import org.glassfish.webservices.EjbMessageDispatcher;
import org.glassfish.webservices.EjbRuntimeEndpointInfo;
import org.glassfish.webservices.LogUtils;
import org.glassfish.webservices.SecurityService;
import org.glassfish.webservices.WsUtil;
import org.glassfish.webservices.monitoring.HttpResponseInfoImpl;
import org.glassfish.webservices.monitoring.JAXRPCEndpointImpl;
import org.glassfish.webservices.monitoring.ThreadLocalInfo;
import org.glassfish.webservices.monitoring.WebServiceEngineImpl;

public class EjbWebServiceDispatcher
implements EjbMessageDispatcher {
    private static final Logger logger = LogUtils.getLogger();
    private JaxRpcObjectFactory rpcFactory;
    private final WsUtil wsUtil = new WsUtil();
    private WebServiceEngineImpl wsEngine;
    private static final QName FAULT_CODE_CLIENT = new QName("http://schemas.xmlsoap.org/soap/envelope/", "Client");
    private static final String HTTP_SERVLET_RESPONSE = "com.sun.xml.rpc.server.http.HttpServletResponse";
    SecurityService secServ;

    public EjbWebServiceDispatcher() {
        this.rpcFactory = JaxRpcObjectFactory.newInstance();
        this.wsEngine = WebServiceEngineImpl.getInstance();
        if (Globals.getDefaultHabitat() != null) {
            this.secServ = (SecurityService)Globals.get(SecurityService.class);
        }
    }

    @Override
    public void invoke(HttpServletRequest req, HttpServletResponse resp, ServletContext ctxt, EjbRuntimeEndpointInfo endpointInfo) {
        String method = req.getMethod();
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "AS-WSJSR109IMPL-00047", new Object[]{req.getMethod(), req.getRequestURI(), req.getQueryString()});
        }
        try {
            if (method.equals("POST")) {
                this.handlePost(req, resp, endpointInfo);
            } else if (method.equals("GET")) {
                this.handleGet(req, resp, ctxt, endpointInfo);
            } else {
                String errorMessage = MessageFormat.format(logger.getResourceBundle().getString("AS-WSJSR109IMPL-00070"), method, endpointInfo.getEndpoint().getEndpointName(), endpointInfo.getEndpointAddressUri());
                logger.log(Level.WARNING, errorMessage);
                this.wsUtil.writeInvalidMethodType(resp, errorMessage);
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "AS-WSJSR109IMPL-00048", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void handlePost(HttpServletRequest req, HttpServletResponse resp, EjbRuntimeEndpointInfo endpointInfo) throws IOException, SOAPException {
        endpoint = null;
        messageID = null;
        msgContext = null;
        try {
            headers = this.wsUtil.getHeaders(req);
            if (!this.wsUtil.hasTextXmlContentType(headers)) {
                this.wsUtil.writeInvalidContentType(resp);
                return;
            }
            msgContext = this.rpcFactory.createSOAPMessageContext();
            message = this.createSOAPMessage(req, headers);
            wssSucceded = true;
            if (message != null) {
                msgContext.setMessage(message);
                endpoint = (JAXRPCEndpointImpl)endpointInfo.getEndpoint().getExtraAttribute("MONITORING_ENDPOINT");
                if (endpoint != null) {
                    if (this.wsEngine.hasGlobalMessageListener()) {
                        messageID = this.wsEngine.preProcessRequest(endpoint);
                    }
                } else if (EjbWebServiceDispatcher.logger.isLoggable(Level.FINE)) {
                    EjbWebServiceDispatcher.logger.log(Level.FINE, "AS-WSJSR109IMPL-00074", req.getRequestURI());
                }
                aInfo = null;
                if (!(endpointInfo instanceof Ejb2RuntimeEndpointInfo)) {
                    throw new IllegalArgumentException(endpointInfo + "is not instance of Ejb2RuntimeEndpointInfo.");
                }
                try {
                    endpointInfo2 = (Ejb2RuntimeEndpointInfo)endpointInfo;
                    aInfo = endpointInfo2.getHandlerImplementor();
                    inv = aInfo.getInv();
                    if (inv instanceof EJBInvocation) {
                        ((EJBInvocation)EJBInvocation.class.cast(inv)).setMessageContext((MessageContext)msgContext);
                    }
                    msgContext.setProperty("com.sun.xml.rpc.server.http.HttpServletResponse", (Object)resp);
                    if (this.secServ != null) {
                        wssSucceded = this.secServ.validateRequest(endpointInfo2.getServerAuthConfig(), (StreamingHandler)aInfo.getHandler(), msgContext);
                    }
                    if (messageID != null || endpoint != null && endpoint.hasListeners()) {
                        threadLocalInfo = new ThreadLocalInfo(messageID, req);
                        this.wsEngine.getThreadLocal().set(threadLocalInfo);
                        if (endpoint != null) {
                            endpoint.processRequest(msgContext);
                        } else if (EjbWebServiceDispatcher.logger.isLoggable(Level.FINE)) {
                            EjbWebServiceDispatcher.logger.log(Level.FINE, "AS-WSJSR109IMPL-00074", req.getRequestURI());
                        }
                    }
                    if (!wssSucceded) ** GOTO lbl53
                    aInfo.getHandler().handle(msgContext);
                }
                finally {
                    if (aInfo != null) {
                        endpointInfo.releaseImplementor(aInfo.getInv());
                    }
                }
            } else {
                errorMsg = MessageFormat.format(EjbWebServiceDispatcher.logger.getResourceBundle().getString("AS-WSJSR109IMPL-00075"), new Object[]{endpointInfo.getEndpoint().getEndpointName(), endpointInfo.getEndpointAddressUri()});
                if (EjbWebServiceDispatcher.logger.isLoggable(Level.FINE)) {
                    EjbWebServiceDispatcher.logger.fine(errorMsg);
                }
                msgContext.writeSimpleErrorResponse(EjbWebServiceDispatcher.FAULT_CODE_CLIENT, errorMsg);
            }
lbl53:
            // 3 sources

            if (messageID != null || endpoint != null) {
                endpoint.processResponse(msgContext);
            }
            reply = msgContext.getMessage();
            if (this.secServ != null && wssSucceded) {
                if (!(endpointInfo instanceof Ejb2RuntimeEndpointInfo)) {
                    throw new IllegalArgumentException(endpointInfo + "is not instance of Ejb2RuntimeEndpointInfo.");
                }
                endpointInfo2 = (Ejb2RuntimeEndpointInfo)endpointInfo;
                this.secServ.secureResponse(endpointInfo2.getServerAuthConfig(), (StreamingHandler)endpointInfo2.getHandlerImplementor().getHandler(), msgContext);
            }
            if (reply.saveRequired()) {
                reply.saveChanges();
            }
            this.wsUtil.writeReply(resp, msgContext);
        }
        catch (Throwable e) {
            errorMessage = MessageFormat.format(EjbWebServiceDispatcher.logger.getResourceBundle().getString("AS-WSJSR109IMPL-00071"), new Object[]{endpointInfo.getEndpoint().getEndpointName(), endpointInfo.getEndpointAddressUri(), e.getMessage()});
            EjbWebServiceDispatcher.logger.log(Level.WARNING, errorMessage, e);
            errorMsgContext = this.rpcFactory.createSOAPMessageContext();
            errorMsgContext.writeSimpleErrorResponse(SOAPConstants.FAULT_CODE_SERVER, errorMessage);
            resp.setStatus(500);
            if (messageID != null || endpoint != null) {
                endpoint.processResponse(errorMsgContext);
            }
            this.wsUtil.writeReply(resp, errorMsgContext);
        }
        if (messageID != null) {
            response = new HttpResponseInfoImpl(resp);
            this.wsEngine.postProcessResponse(messageID, response);
        }
    }

    private void handleGet(HttpServletRequest req, HttpServletResponse resp, ServletContext ctxt, EjbRuntimeEndpointInfo endpointInfo) throws IOException {
        this.wsUtil.handleGet(req, resp, endpointInfo.getEndpoint());
    }

    protected SOAPMessage createSOAPMessage(HttpServletRequest request, MimeHeaders headers) throws IOException {
        ServletInputStream is = request.getInputStream();
        byte[] bytes = this.readFully((InputStream)is);
        int length = request.getContentLength() == -1 ? bytes.length : request.getContentLength();
        ByteInputStream in = new ByteInputStream(bytes, length);
        SOAPMessageContext msgContext = this.rpcFactory.createSOAPMessageContext();
        SOAPMessage message = msgContext.createMessage(headers, (InputStream)in);
        return message;
    }

    protected byte[] readFully(InputStream istream) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        byte[] buf = new byte[1024];
        int num = 0;
        while ((num = istream.read(buf)) != -1) {
            bout.write(buf, 0, num);
        }
        byte[] ret = bout.toByteArray();
        return ret;
    }
}

