/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config.modularity.command;

import com.sun.enterprise.config.modularity.ConfigModularityUtils;
import com.sun.enterprise.config.modularity.annotation.CustomConfiguration;
import com.sun.enterprise.config.modularity.command.AbstractConfigModularityCommand;
import com.sun.enterprise.config.modularity.customization.ConfigBeanDefaultValue;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.DomainExtension;
import com.sun.enterprise.config.util.ConfigApiLoggerInfo;
import com.sun.enterprise.module.bootstrap.StartupContext;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Named;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AccessRequired;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.AdminCommandSecurity;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.api.admin.config.ConfigExtension;
import org.glassfish.api.logging.LogHelper;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.server.ServerEnvironmentImpl;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;

@TargetType(value={CommandTarget.DAS, CommandTarget.CLUSTER, CommandTarget.CONFIG, CommandTarget.STANDALONE_INSTANCE, CommandTarget.DOMAIN})
@ExecuteOn(value={RuntimeType.ALL})
@Service(name="get-active-module-config")
@PerLookup
@I18n(value="get.active.config")
public final class GetActiveConfigCommand
extends AbstractConfigModularityCommand
implements AdminCommand,
AdminCommandSecurity.Preauthorization,
AdminCommandSecurity.AccessCheckProvider {
    private final Logger LOG = ConfigApiLoggerInfo.getLogger();
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(GetActiveConfigCommand.class);
    private ActionReport report;
    @Inject
    private Domain domain;
    @Inject
    private ConfigModularityUtils configModularityUtils;
    @Inject
    StartupContext startupContext;
    @Inject
    private ServiceLocator serviceLocator;
    @Param(name="target", optional=true, defaultValue="server")
    String target;
    @Param(optional=true, defaultValue="false", name="all")
    private Boolean isAll;
    @Param(name="serviceName", primary=true, optional=true)
    private String serviceName;
    @Inject
    @Named(value="default-instance-name")
    Config config;
    @Inject
    ServerEnvironmentImpl serverenv;

    public void execute(AdminCommandContext context) {
        if (this.serviceName != null) {
            String className = this.configModularityUtils.convertConfigElementNameToClassName(this.serviceName);
            Class configBeanType = this.configModularityUtils.getClassFor(this.serviceName);
            if (configBeanType == null) {
                String string = localStrings.getLocalString("get.active.config.not.such.a.service.found", "A ConfigBean of type {0} which translates to your service name\\'s does not exist.", new Object[]{className, this.serviceName});
                this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                this.report.setMessage(string);
                return;
            }
            try {
                String string = this.getActiveConfigFor(configBeanType);
                if (string != null) {
                    this.report.setMessage(string);
                    this.report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
                    return;
                }
            }
            catch (Exception exception) {
                String msg = localStrings.getLocalString("get.active.config.getting.active.config.for.service.failed", "Failed to get active configuration for {0} under the target {1} due to: {2}.", new Object[]{this.serviceName, this.target, exception.getMessage()});
                LogHelper.log((Logger)this.LOG, (Level)Level.INFO, (String)"NCLS-CFGAPI-00121", (Throwable)exception, (Object[])new Object[]{this.serviceName, this.target});
                this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                this.report.setMessage(msg);
                this.report.setFailureCause((Throwable)exception);
                return;
            }
        }
        if (this.isAll.booleanValue()) {
            List<Class> configBeans = this.configModularityUtils.getAnnotatedConfigBeans(CustomConfiguration.class);
            for (Class clazz : configBeans) {
                try {
                    String serviceDefaultConfig = this.getActiveConfigFor(clazz);
                    if (serviceDefaultConfig == null) continue;
                    this.report.setMessage(serviceDefaultConfig);
                    this.report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
                    return;
                }
                catch (Exception e) {
                    String msg = localStrings.getLocalString("get.active.config.getting.active.config.for.service.failed", "Failed to get active configuration for {0} under the target {1} due to: {2}.", new Object[]{this.serviceName, this.target, e.getMessage()});
                    LogHelper.log((Logger)this.LOG, (Level)Level.INFO, (String)"NCLS-CFGAPI-00121", (Throwable)e, (Object[])new Object[]{this.serviceName, this.target});
                    this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                    this.report.setMessage(msg);
                    this.report.setFailureCause((Throwable)e);
                    return;
                }
            }
        }
        List<Class> clzs = this.configModularityUtils.getAnnotatedConfigBeans(CustomConfiguration.class);
        StringBuilder sb = new StringBuilder();
        try {
            for (Class clz : clzs) {
                sb.append(this.getActiveConfigFor(clz));
                sb.append(LINE_SEPARATOR);
            }
            this.report.appendMessage(sb.toString());
        }
        catch (Exception exception) {
            String msg = localStrings.getLocalString("get.active.config.getting.active.config.for.service.failed", "Failed to get active configuration for {0} under the target {1} due to: {2}.", new Object[]{this.serviceName, this.target, exception.getMessage()});
            LogHelper.log((Logger)this.LOG, (Level)Level.INFO, (String)"NCLS-CFGAPI-00121", (Throwable)exception, (Object[])new Object[]{this.serviceName, this.target});
            this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            this.report.setMessage(msg);
            this.report.setFailureCause((Throwable)exception);
            return;
        }
    }

    private String getActiveConfigFor(Class configBeanType) throws InvocationTargetException, IllegalAccessException {
        if (this.configModularityUtils.hasCustomConfig(configBeanType)) {
            List<ConfigBeanDefaultValue> defaults = this.configModularityUtils.getDefaultConfigurations(configBeanType, this.configModularityUtils.getRuntimeTypePrefix(this.serverenv.getStartupContext()));
            return this.getCompleteConfiguration(defaults);
        }
        if (ConfigExtension.class.isAssignableFrom(configBeanType)) {
            if (this.config.checkIfExtensionExists(configBeanType)) {
                return this.configModularityUtils.serializeConfigBean((ConfigBeanProxy)this.config.getExtensionByType(configBeanType));
            }
            return this.configModularityUtils.serializeConfigBeanByType(configBeanType);
        }
        if (configBeanType.isAssignableFrom(DomainExtension.class)) {
            if (this.domain.checkIfExtensionExists(configBeanType)) {
                return this.configModularityUtils.serializeConfigBean((ConfigBeanProxy)this.domain.getExtensionByType(configBeanType));
            }
            return this.configModularityUtils.serializeConfigBeanByType(configBeanType);
        }
        return null;
    }

    private String getCompleteConfiguration(List<ConfigBeanDefaultValue> defaults) throws InvocationTargetException, IllegalAccessException {
        StringBuilder builder = new StringBuilder();
        for (ConfigBeanDefaultValue value : defaults) {
            builder.append(localStrings.getLocalString("at.location", "At Location: "));
            builder.append(this.replaceExpressionsWithValues(value.getLocation()));
            builder.append(LINE_SEPARATOR);
            String substituted = this.configModularityUtils.replacePropertiesWithCurrentValue(this.getDependentConfigElement(value), value);
            builder.append(substituted);
            builder.append(LINE_SEPARATOR);
        }
        builder.deleteCharAt(builder.length() - 1);
        return builder.toString();
    }

    private String getDependentConfigElement(ConfigBeanDefaultValue defaultValue) throws InvocationTargetException, IllegalAccessException {
        Object configBean = this.configModularityUtils.getCurrentConfigBeanForDefaultValue(defaultValue);
        if (configBean != null) {
            return this.configModularityUtils.serializeConfigBean((ConfigBeanProxy)configBean);
        }
        return defaultValue.getXmlConfiguration();
    }

    public Collection<? extends AccessRequired.AccessCheck> getAccessChecks() {
        Class configBeanType = null;
        if (this.serviceName == null && this.isAll.booleanValue()) {
            ArrayList<AccessRequired.AccessCheck> l = new ArrayList<AccessRequired.AccessCheck>();
            List<Class> clzs = this.configModularityUtils.getAnnotatedConfigBeans(CustomConfiguration.class);
            for (Class clz : clzs) {
                List<ConfigBeanDefaultValue> configBeanDefaultValueList = this.configModularityUtils.getDefaultConfigurations(clz, this.configModularityUtils.getRuntimeTypePrefix(this.startupContext));
                l.addAll(this.getAccessChecksForDefaultValue(configBeanDefaultValueList, this.target, Arrays.asList("read")));
            }
            return l;
        }
        if (this.serviceName == null) {
            return Collections.emptyList();
        }
        configBeanType = this.configModularityUtils.getClassFor(this.serviceName);
        if (configBeanType == null) {
            return Collections.emptyList();
        }
        if (this.configModularityUtils.hasCustomConfig(configBeanType)) {
            List<ConfigBeanDefaultValue> defaults = this.configModularityUtils.getDefaultConfigurations(configBeanType, this.configModularityUtils.getRuntimeTypePrefix(this.serverenv.getStartupContext()));
            return this.getAccessChecksForDefaultValue(defaults, this.target, Arrays.asList("read"));
        }
        if (ConfigExtension.class.isAssignableFrom(configBeanType)) {
            return this.getAccessChecksForConfigBean((ConfigBeanProxy)this.config.getExtensionByType(configBeanType), this.target, Arrays.asList("read"));
        }
        if (configBeanType.isAssignableFrom(DomainExtension.class)) {
            return this.getAccessChecksForConfigBean((ConfigBeanProxy)this.domain.getExtensionByType(configBeanType), this.target, Arrays.asList("read"));
        }
        return Collections.emptyList();
    }

    public boolean preAuthorization(AdminCommandContext context) {
        this.report = context.getActionReport();
        if (this.serviceName == null && !this.isAll.booleanValue()) {
            this.report.setMessage(localStrings.getLocalString("get.active.config.service.name.required", "You need to specify a service name to get it's active configuration."));
            this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return false;
        }
        if (this.target != null) {
            Config newConfig = this.getConfigForName(this.target, this.serviceLocator, this.domain);
            if (newConfig != null) {
                this.config = newConfig;
            }
            if (this.config == null) {
                this.report.setMessage(localStrings.getLocalString("get.active.config.target.name.invalid", "The target name you specified is invalid. Please double check the target name and try again"));
                this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return false;
            }
        }
        if (this.isAll.booleanValue() && this.serviceName != null) {
            this.report.setMessage(localStrings.getLocalString("get.active.config.target.service.and.all.exclusive", "Specifying a service name and using --all=true can not be used together."));
            this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return false;
        }
        return true;
    }
}

