/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.ee.rs.headerparam;

import ee.jakarta.tck.ws.rs.common.JAXRSCommonClient;
import ee.jakarta.tck.ws.rs.ee.rs.JaxrsParamClient;
import ee.jakarta.tck.ws.rs.ee.rs.ParamEntityPrototype;
import ee.jakarta.tck.ws.rs.ee.rs.ParamEntityThrowingExceptionGivenByName;
import ee.jakarta.tck.ws.rs.ee.rs.ParamEntityThrowingWebApplicationException;
import ee.jakarta.tck.ws.rs.ee.rs.ParamEntityWithConstructor;
import ee.jakarta.tck.ws.rs.ee.rs.ParamEntityWithFromString;
import ee.jakarta.tck.ws.rs.ee.rs.ParamEntityWithValueOf;
import ee.jakarta.tck.ws.rs.ee.rs.ParamTest;
import ee.jakarta.tck.ws.rs.ee.rs.RuntimeExceptionMapper;
import ee.jakarta.tck.ws.rs.ee.rs.WebApplicationExceptionMapper;
import ee.jakarta.tck.ws.rs.ee.rs.headerparam.HeaderParamTest;
import ee.jakarta.tck.ws.rs.ee.rs.headerparam.TSAppConfig;
import ee.jakarta.tck.ws.rs.lib.util.TestUtil;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.io.InputStream;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
public class JAXRSClientIT
extends JaxrsParamClient {
    private static final long serialVersionUID = 1L;

    public JAXRSClientIT() {
        this.setup();
        this.setContextRoot("/jaxrs_ee_rs_headerparam_web/HeaderParamTest");
    }

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        TestUtil.logMsg("STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        TestUtil.logMsg("FINISHED TEST : " + testInfo.getDisplayName());
    }

    @Deployment(testable=false)
    public static WebArchive createDeployment() throws IOException {
        InputStream inStream = JAXRSClientIT.class.getClassLoader().getResourceAsStream("ee/jakarta/tck/ws/rs/ee/rs/headerparam/web.xml.template");
        String webXml = JAXRSClientIT.editWebXmlString(inStream);
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"jaxrs_ee_rs_headerparam_web.war");
        archive.addClasses(new Class[]{TSAppConfig.class, HeaderParamTest.class, ParamEntityPrototype.class, ParamEntityWithConstructor.class, ParamEntityWithValueOf.class, ParamEntityWithFromString.class, ParamTest.class, JaxrsParamClient.CollectionName.class, ParamEntityThrowingWebApplicationException.class, ParamEntityThrowingExceptionGivenByName.class, RuntimeExceptionMapper.class, WebApplicationExceptionMapper.class});
        archive.setWebXML((Asset)new StringAsset(webXml));
        return archive;
    }

    @Test
    public void headerParamStringTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, "X-CTSTEST-HEADERTEST-STRINGTEST1: cts");
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, ""));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "stringtest1=cts");
        this.invoke();
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, "X-CTSTEST-HEADERTEST-STRINGTEST1: cts1");
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, "X-CTSTEST-HEADERTEST-STRINGTEST1: cts2");
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, ""));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "stringtest1=cts1");
        this.invoke();
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, "X-CTSTEST-HEADERTEST-STRINGTEST1: cts1");
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, "X-CTSTEST-HEADERTEST-STRINGTEST2: cts2");
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, ""));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "stringtest1=cts|stringtest2=cts2");
        this.invoke();
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, "X-CTSTEST-HEADERTEST-STRINGTEST1: cts1");
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, "X-CTSTEST-HEADERTEST-STRINGTEST2: cts2");
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, "X-CTSTEST-HEADERTEST-STRINGTEST1: newone");
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, ""));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "stringtest1=cts1|stringtest2=cts2");
        this.invoke();
    }

    @Test
    public void headerParamNoQueryTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, ""));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "No HeaderParam");
        this.invoke();
    }

    @Test
    public void headerParamIntTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, "X-CTSTEST-HEADERTEST-INTTEST1: 2147483647");
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, ""));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "inttest1=2147483647");
        this.invoke();
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, "X-CTSTEST-HEADERTEST-INTTEST1: -2147483648");
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, "X-CTSTEST-HEADERTEST-INTTEST1: 2147483647");
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, ""));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "inttest1=-2147483648");
        this.invoke();
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, "X-CTSTEST-HEADERTEST-INTTEST1: -2147483648");
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, "X-CTSTEST-HEADERTEST-INTTEST2: 2147483647");
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, ""));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "inttest1=-2147483648|inttest2=2147483647");
        this.invoke();
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, "X-CTSTEST-HEADERTEST-INTTEST1: -2147483648");
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, "X-CTSTEST-HEADERTEST-INTTEST2: 2147483647");
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, "X-CTSTEST-HEADERTEST-INTTEST1: 1234");
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, ""));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "inttest1=-2147483648|inttest2=2147483647");
        this.invoke();
    }

    @Test
    public void headerParamDoubleTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, "X-CTSTEST-HEADERTEST-DOUBLETEST1: 123");
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, ""));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "doubletest1=123.0");
        this.invoke();
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, "X-CTSTEST-HEADERTEST-DOUBLETEST1: 123.1");
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, "X-CTSTEST-HEADERTEST-DOUBLETEST1: 345");
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, ""));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "doubletest1=123.1");
        this.invoke();
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, "X-CTSTEST-HEADERTEST-DOUBLETEST1: 12.345");
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, "X-CTSTEST-HEADERTEST-DOUBLETEST2: 34.567");
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, ""));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "doubletest1=12.345|doubletest2=34.567");
        this.invoke();
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, "X-CTSTEST-HEADERTEST-DOUBLETEST1: 23.456");
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, "X-CTSTEST-HEADERTEST-DOUBLETEST2: 0.56789");
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, "X-CTSTEST-HEADERTEST-DOUBLETEST1: 1.234");
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, ""));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "doubletest1=23.456|doubletest2=0.56789");
        this.invoke();
    }

    @Test
    public void headerParamFloatTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, "X-CTSTEST-HEADERTEST-FLOATTEST1: 123");
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, ""));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "floattest1=123.0");
        this.invoke();
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, "X-CTSTEST-HEADERTEST-FLOATTEST1: 123.1");
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, "X-CTSTEST-HEADERTEST-FLOATTEST1: 345");
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, ""));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "floattest1=123.1");
        this.invoke();
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, "X-CTSTEST-HEADERTEST-FLOATTEST1: 12.345");
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, "X-CTSTEST-HEADERTEST-FLOATTEST2: 34.567");
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, ""));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "floattest1=12.345|floattest2=34.567");
        this.invoke();
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, "X-CTSTEST-HEADERTEST-FLOATTEST1: 23.456");
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, "X-CTSTEST-HEADERTEST-FLOATTEST2: 0.56789");
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, "X-CTSTEST-HEADERTEST-FLOATTEST1: 1.234");
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, ""));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "floattest1=23.456|floattest2=0.56789");
        this.invoke();
    }

    @Test
    public void headerParamLongTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, "X-CTSTEST-HEADERTEST-LONGTEST1: -9223372036854775808");
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, ""));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "longtest1=-9223372036854775808");
        this.invoke();
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, "X-CTSTEST-HEADERTEST-LONGTEST1: 9223372036854775807");
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, "X-CTSTEST-HEADERTEST-LONGTEST1: -9223372036854775808");
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, ""));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "longtest1=9223372036854775807");
        this.invoke();
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, "X-CTSTEST-HEADERTEST-LONGTEST1: -9223372036854775808");
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, "X-CTSTEST-HEADERTEST-LONGTEST2: 9223372036854775807");
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, ""));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "longtest1=-9223372036854775808|longtest2=9223372036854775807");
        this.invoke();
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, "X-CTSTEST-HEADERTEST-LONGTEST1: -9223372036854775808");
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, "X-CTSTEST-HEADERTEST-LONGTEST2: 9223372036854775807");
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, "X-CTSTEST-HEADERTEST-LONGTEST1: 1234");
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, ""));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "longtest1=-9223372036854775808|longtest2=9223372036854775807");
        this.invoke();
    }

    @Test
    public void headerParamShortTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, "X-CTSTEST-HEADERTEST-SHORTTEST1: -32768");
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, ""));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "shorttest1=-32768");
        this.invoke();
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, "X-CTSTEST-HEADERTEST-SHORTTEST1: 32767");
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, "X-CTSTEST-HEADERTEST-SHORTTEST1: -32768");
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, ""));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "shorttest1=32767");
        this.invoke();
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, "X-CTSTEST-HEADERTEST-SHORTTEST1: 32767");
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, "X-CTSTEST-HEADERTEST-SHORTTEST2: -32768");
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, ""));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "shorttest1=32767|shorttest2=-32768");
        this.invoke();
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, "X-CTSTEST-HEADERTEST-SHORTTEST1: 32767");
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, "X-CTSTEST-HEADERTEST-SHORTTEST2: -32768");
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, "X-CTSTEST-HEADERTEST-SHORTTEST1: 1234");
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, ""));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "shorttest1=32767|shorttest2=-32768");
        this.invoke();
    }

    @Test
    public void headerParamByteTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, "X-CTSTEST-HEADERTEST-BYTETEST1: 127");
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, ""));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "bytetest1=127");
        this.invoke();
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, "X-CTSTEST-HEADERTEST-BYTETEST1: -128");
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, "X-CTSTEST-HEADERTEST-BYTETEST1: 26");
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, ""));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "bytetest1=-128");
        this.invoke();
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, "X-CTSTEST-HEADERTEST-BYTETEST1: 127");
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, "X-CTSTEST-HEADERTEST-BYTETEST2: -128");
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, ""));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "bytetest1=127|bytetest2=-128");
        this.invoke();
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, "X-CTSTEST-HEADERTEST-BYTETEST1: 0");
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, "X-CTSTEST-HEADERTEST-BYTETEST2: -128");
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, "X-CTSTEST-HEADERTEST-BYTETEST1: 127");
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, ""));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "bytetest2=-128");
        this.setProperty(JAXRSCommonClient.Property.UNEXPECTED_RESPONSE_MATCH, "bytetest1");
        this.invoke();
    }

    @Test
    public void headerParamBooleanTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, "X-CTSTEST-HEADERTEST-BOOLEANTEST1: true");
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, ""));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "booleantest1=true");
        this.invoke();
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, "X-CTSTEST-HEADERTEST-BOOLEANTEST1: true");
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, "X-CTSTEST-HEADERTEST-BOOLEANTEST1: false");
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, ""));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "booleantest1=true");
        this.invoke();
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, "X-CTSTEST-HEADERTEST-BOOLEANTEST1: false");
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, "X-CTSTEST-HEADERTEST-BOOLEANTEST2: true");
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, ""));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "booleantest2=true");
        this.invoke();
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, "X-CTSTEST-HEADERTEST-BOOLEANTEST1: true");
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, "X-CTSTEST-HEADERTEST-BOOLEANTEST2: false");
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, "X-CTSTEST-HEADERTEST-BOOLEANTEST1: false");
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, ""));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "booleantest1=true");
        this.invoke();
    }

    @Test
    public void headerParamEntityWithConstructorTest() throws JAXRSCommonClient.Fault {
        super.paramEntityWithConstructorTest();
    }

    @Test
    public void headerParamEntityWithValueOfTest() throws JAXRSCommonClient.Fault {
        super.paramEntityWithValueOfTest();
    }

    @Test
    public void headerParamEntityWithFromStringTest() throws JAXRSCommonClient.Fault {
        super.paramEntityWithFromStringTest();
    }

    @Test
    public void headerParamSetEntityWithFromStringTest() throws JAXRSCommonClient.Fault {
        super.paramCollectionEntityWithFromStringTest(JaxrsParamClient.CollectionName.SET);
    }

    @Test
    public void headerParamSortedSetEntityWithFromStringTest() throws JAXRSCommonClient.Fault {
        super.paramCollectionEntityWithFromStringTest(JaxrsParamClient.CollectionName.SORTED_SET);
    }

    @Test
    public void headerParamListEntityWithFromStringTest() throws JAXRSCommonClient.Fault {
        super.paramCollectionEntityWithFromStringTest(JaxrsParamClient.CollectionName.LIST);
    }

    @Test
    public void headerFieldParamEntityWithConstructorTest() throws JAXRSCommonClient.Fault {
        super.fieldEntityWithConstructorTest();
    }

    @Test
    public void headerFieldParamEntityWithValueOfTest() throws JAXRSCommonClient.Fault {
        super.fieldEntityWithValueOfTest();
    }

    @Test
    public void headerFieldParamEntityWithFromStringTest() throws JAXRSCommonClient.Fault {
        super.fieldEntityWithFromStringTest();
    }

    @Test
    public void headerFieldParamSetEntityWithFromStringTest() throws JAXRSCommonClient.Fault {
        super.fieldCollectionEntityWithFromStringTest(JaxrsParamClient.CollectionName.SET);
    }

    @Test
    public void headerFieldParamSortedSetEntityWithFromStringTest() throws JAXRSCommonClient.Fault {
        super.fieldCollectionEntityWithFromStringTest(JaxrsParamClient.CollectionName.SORTED_SET);
    }

    @Test
    public void headerFieldParamListEntityWithFromStringTest() throws JAXRSCommonClient.Fault {
        super.fieldCollectionEntityWithFromStringTest(JaxrsParamClient.CollectionName.LIST);
    }

    @Test
    public void headerParamThrowingWebApplicationExceptionTest() throws JAXRSCommonClient.Fault {
        super.paramThrowingWebApplicationExceptionTest();
    }

    @Test
    public void headerFieldThrowingWebApplicationExceptionTest() throws JAXRSCommonClient.Fault {
        super.fieldThrowingWebApplicationExceptionTest();
    }

    @Test
    public void headerParamThrowingIllegalArgumentExceptionTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.UNORDERED_SEARCH_STRING, Response.Status.BAD_REQUEST.name());
        super.paramThrowingIllegalArgumentExceptionTest();
    }

    @Test
    public void headerFieldThrowingIllegalArgumentExceptionTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.UNORDERED_SEARCH_STRING, Response.Status.BAD_REQUEST.name());
        super.fieldThrowingIllegalArgumentExceptionTest();
    }

    @Override
    protected String buildRequest(String param) {
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, param.replace("=", ":"));
        return this.buildRequest(JAXRSCommonClient.Request.GET, "");
    }

    @Override
    protected String getDefaultValueOfParam(String param) {
        StringBuilder sb = new StringBuilder();
        sb.append(param).append("=");
        sb.append(HeaderParamTest.class.getSimpleName());
        return sb.toString();
    }
}

