/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ant.taskdefs.common;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Writer;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class Sed
extends Task {
    protected static final String NL = System.getProperty("line.separator", "\n");
    protected File thefile;
    protected String findthis;
    protected String replacewith;

    public void setFile(File file) {
        this.thefile = file;
    }

    public void setFind(String find) {
        this.findthis = find;
    }

    public void setReplace(String replace) {
        this.replacewith = replace;
    }

    public void execute() throws BuildException {
        this.checkPreconditions();
        this.doIt();
    }

    protected void checkPreconditions() throws BuildException {
        if (!this.thefile.exists()) {
            throw new BuildException("Error, \"" + this.thefile + "\" does not exist");
        }
        if (this.findthis == null || this.findthis.length() == 0) {
            throw new BuildException("Find string is empty, it can NOT be.");
        }
        if (this.replacewith == null || this.replacewith.length() == 0) {
            throw new BuildException("Replace string is empty, it can NOT be.");
        }
        this.checkPreconditions0();
    }

    protected void checkPreconditions0() throws BuildException {
    }

    protected String filterFile() throws BuildException {
        BufferedReader in = null;
        String line = null;
        StringBuffer filteredBuffer = new StringBuffer();
        try {
            String result;
            in = new BufferedReader(new FileReader(this.thefile));
            while ((line = in.readLine()) != null) {
                result = this.filterString(line);
                filteredBuffer.append(result + NL);
            }
            result = filteredBuffer.toString();
            return result;
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
        finally {
            try {
                in.close();
            }
            catch (Exception exception) {}
        }
    }

    protected String filterString(String line) {
        return line.replaceAll(this.findthis, this.replacewith);
    }

    protected void writeFile(String output) throws BuildException {
        Writer out = null;
        try {
            File outFile = new File(this.thefile.getPath() + ".temp");
            out = new FileWriter(outFile);
            out.write(output);
            out.flush();
            if (!this.thefile.delete()) {
                throw new BuildException("Could not delete \"" + this.thefile + "\"");
            }
            if (!outFile.renameTo(this.thefile)) {
                throw new BuildException("Could not rename \"" + outFile + "\" to \"" + this.thefile + "\"");
            }
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
        finally {
            try {
                out.close();
            }
            catch (Exception exception) {}
        }
    }

    protected void doIt() throws BuildException {
        String buf = this.filterFile();
        this.writeFile(buf);
    }
}

