/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.jsonp.api.jsonobjecttests;

import ee.jakarta.tck.jsonp.api.common.JsonAssert;
import ee.jakarta.tck.jsonp.api.common.SimpleValues;
import ee.jakarta.tck.jsonp.api.common.TestResult;
import jakarta.json.Json;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonValue;
import java.util.HashMap;
import java.util.logging.Logger;

public class CreateObjectBuilder {
    private static final Logger LOGGER = Logger.getLogger(CreateObjectBuilder.class.getName());

    TestResult test() {
        TestResult result = new TestResult("JsonObjectBuilder API factory methods added in JSON-P 1.1.");
        LOGGER.info("JsonObjectBuilder API factory methods added in JSON-P 1.1.");
        this.testCreateFromMap(result);
        this.testCreateFromJsonObject(result);
        return result;
    }

    private void testCreateFromMap(TestResult result) {
        LOGGER.info(" - Json#createObjectBuilder(Map<String,Object>)");
        JsonObject check = SimpleValues.createSimpleObjectWithStr();
        HashMap<String, String> values = new HashMap<String, String>(2);
        values.put("name", "John Smith");
        values.put("address", "In a galaxy far far away");
        JsonObjectBuilder builder = Json.createObjectBuilder(values);
        JsonObject out = builder.build();
        if (this.operationFailed((JsonValue)check, (JsonValue)out)) {
            result.fail("createObjectBuilder(Map<String,Object>)", "Builder output " + JsonAssert.valueToString((JsonValue)out) + " value shall be " + JsonAssert.valueToString((JsonValue)check));
        }
    }

    private void testCreateFromJsonObject(TestResult result) {
        LOGGER.info(" - Json#createObjectBuilder(JsonObject)");
        JsonObject check = SimpleValues.createSimpleObjectWithStr();
        JsonObjectBuilder builder = Json.createObjectBuilder((JsonObject)check);
        JsonObject out = builder.build();
        if (this.operationFailed((JsonValue)check, (JsonValue)out)) {
            result.fail("reateObjectBuilder(JsonObject)", "Builder output " + JsonAssert.valueToString((JsonValue)out) + " value shall be " + JsonAssert.valueToString((JsonValue)check));
        }
    }

    protected boolean operationFailed(JsonValue check, JsonValue out) {
        return out == null || !JsonAssert.assertEquals(check, out);
    }
}

