/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jpa.core.annotations.mapsid;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jpa.common.PMClientBase;
import com.sun.ts.tests.jpa.core.annotations.mapsid.DID1bDependent;
import com.sun.ts.tests.jpa.core.annotations.mapsid.DID1bDependentId;
import com.sun.ts.tests.jpa.core.annotations.mapsid.DID1bEmployee;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityTransaction;
import java.util.List;
import java.util.Properties;

public class Client
extends PMClientBase {
    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    @Override
    public void setup(String[] args, Properties p) throws EETest.Fault {
        TestUtil.logTrace((String)"setup");
        try {
            super.setup(args, p);
            this.removeTestData();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception: ", (Throwable)e);
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    public void persistMX1Test1() throws EETest.Fault {
        TestUtil.logTrace((String)"Begin persistMX1Test1");
        boolean pass = false;
        EntityManager em = null;
        EntityTransaction et = null;
        em = this.getEntityManager();
        et = this.getEntityTransaction();
        et.begin();
        try {
            DID1bEmployee employee1 = new DID1bEmployee(1L, "Duke");
            DID1bEmployee employee2 = new DID1bEmployee(2L, "foo");
            DID1bDependent dep1 = new DID1bDependent(new DID1bDependentId("Obama", 1L), employee1);
            DID1bDependent dep2 = new DID1bDependent(new DID1bDependentId("Michelle", 1L), employee1);
            DID1bDependent dep3 = new DID1bDependent(new DID1bDependentId("John", 2L), employee2);
            em.persist((Object)dep1);
            em.persist((Object)dep2);
            em.persist((Object)dep3);
            em.persist((Object)employee1);
            em.persist((Object)employee2);
            TestUtil.logTrace((String)"persisted Employees and Dependents");
            em.flush();
            DID1bDependent newDependent = (DID1bDependent)em.find(DID1bDependent.class, (Object)new DID1bDependentId("Obama", 1L));
            if (newDependent != null) {
                em.refresh((Object)newDependent);
            }
            List depList = em.createQuery("Select d from DID1bDependent d where d.id.name='Obama' and d.emp.name='Duke'").getResultList();
            newDependent = null;
            if (depList.size() > 0) {
                newDependent = (DID1bDependent)depList.get(0);
            }
            if (newDependent == dep1) {
                pass = true;
                TestUtil.logTrace((String)"Received Expected Dependent");
            } else {
                TestUtil.logTrace((String)"searched Dependent not found");
            }
            et.commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
            et.rollback();
        }
        if (!pass) {
            throw new EETest.Fault("persistMX1Test1 failed");
        }
    }

    @Override
    public void cleanup() throws EETest.Fault {
        TestUtil.logTrace((String)"cleanup");
        this.removeTestData();
        TestUtil.logTrace((String)"cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    private void removeTestData() {
        TestUtil.logTrace((String)"removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("Delete from DID1BDEPENDENT").executeUpdate();
            this.getEntityManager().createNativeQuery("Delete from DID1BEMPLOYEE").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

