/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb.ee.pm.oneXone.bi.btob;

import com.sun.ts.lib.util.RemoteLoggingInitException;
import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.ejb.ee.pm.oneXone.bi.btob.ADVC;
import com.sun.ts.tests.ejb.ee.pm.oneXone.bi.btob.ALocal;
import com.sun.ts.tests.ejb.ee.pm.oneXone.bi.btob.ALocalHome;
import com.sun.ts.tests.ejb.ee.pm.oneXone.bi.btob.BDVC;
import com.sun.ts.tests.ejb.ee.pm.oneXone.bi.btob.BLocal;
import com.sun.ts.tests.ejb.ee.pm.oneXone.bi.btob.BLocalHome;
import jakarta.ejb.CreateException;
import jakarta.ejb.EJBException;
import jakarta.ejb.EntityBean;
import jakarta.ejb.EntityContext;
import jakarta.ejb.RemoveException;
import java.util.Properties;
import javax.naming.NamingException;

public abstract class BeanEJB
implements EntityBean {
    private static final int NO_RELATION_SET = 0;
    private static final int NULL_RELATION_SET = 1;
    private static final int RELATION_SET = 2;
    private static final String ALocal = "java:comp/env/ejb/AEJBLocal";
    private static final String BLocal = "java:comp/env/ejb/BEJBLocal";
    private EntityContext context = null;
    private TSNamingContext nctx = null;

    public abstract String getId();

    public abstract void setId(String var1);

    public abstract String getName();

    public abstract void setName(String var1);

    public abstract int getValue();

    public abstract void setValue(int var1);

    public abstract ALocal getA1();

    public abstract void setA1(ALocal var1);

    public abstract ALocal getA2();

    public abstract void setA2(ALocal var1);

    public abstract BLocal getB1();

    public abstract void setB1(BLocal var1);

    public abstract BLocal getB2();

    public abstract void setB2(BLocal var1);

    public void init(Properties p) {
        TestUtil.logTrace((String)"init");
        try {
            TestUtil.init((Properties)p);
        }
        catch (RemoteLoggingInitException e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException(e.getMessage());
        }
    }

    private boolean nullTest() {
        TestUtil.logTrace((String)"nullTest");
        ALocal aOne = this.getA1();
        BLocal bOne = this.getB1();
        BLocal b1 = aOne.getB();
        ALocal a1 = bOne.getA();
        return a1 == null && b1 == null;
    }

    public boolean test0() {
        TestUtil.logTrace((String)"test0");
        return this.nullTest();
    }

    public boolean test1() {
        TestUtil.logTrace((String)"test1");
        return this.nullTest();
    }

    public boolean test2() {
        TestUtil.logTrace((String)"test2");
        ALocal aOne = this.getA1();
        ALocal aTwo = this.getA2();
        BLocal bOne = aOne.getB();
        BLocal bTwo = aTwo.getB();
        try {
            aOne.setB(aTwo.getB());
            ALocal a1 = bOne.getA();
            ALocal a2 = bTwo.getA();
            BLocal b1 = aOne.getB();
            BLocal b2 = aTwo.getB();
            if (b1.isIdentical(bTwo) && b2 == null && a1 == null && a2.isIdentical(aOne)) {
                TestUtil.logMsg((String)"Relationship assignment passed");
                return true;
            }
            TestUtil.logMsg((String)"Relationship assignment failed");
            if (!b1.isIdentical(bTwo)) {
                TestUtil.logErr((String)"b1 not identical to b2");
            }
            if (b2 != null) {
                TestUtil.logErr((String)"b2 not null");
            }
            if (a1 != null) {
                TestUtil.logErr((String)"a1 not null");
            }
            if (!a2.isIdentical(aOne)) {
                TestUtil.logErr((String)"a2 not identical to a1");
            }
            return false;
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Exception occurred: " + e), (Throwable)e);
            return false;
        }
    }

    public ADVC getAInfoFromB() {
        TestUtil.logTrace((String)"getAInfoFromB");
        BLocal b = this.getB1();
        return b.getAInfo();
    }

    public BDVC getBInfoFromA() {
        TestUtil.logTrace((String)"getBInfoFromA");
        ALocal a = this.getA1();
        return a.getBInfo();
    }

    private ALocal createALocal(String id, String name, int value) throws Exception {
        TestUtil.logTrace((String)"createALocal");
        this.nctx = new TSNamingContext();
        ALocalHome aLocalHome = (ALocalHome)this.nctx.lookup(ALocal);
        ALocal aLocal = aLocalHome.create(id, name, value);
        return aLocal;
    }

    private BLocal createBLocal(String id, String name, int value) throws Exception {
        TestUtil.logTrace((String)"createBLocal");
        this.nctx = new TSNamingContext();
        BLocalHome bLocalHome = (BLocalHome)this.nctx.lookup(BLocal);
        BLocal bLocal = bLocalHome.create(id, name, value);
        return bLocal;
    }

    public String ejbCreate(String id, String name, int value, ADVC a, BDVC b, int flag) throws CreateException {
        TestUtil.logTrace((String)"ejbCreate");
        try {
            this.setName(name);
            this.setValue(value);
            this.setId(id);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new CreateException("Exception occurred: " + e);
        }
        return null;
    }

    public void ejbPostCreate(String id, String name, int value, ADVC a, BDVC b, int flag) throws CreateException {
        TestUtil.logTrace((String)"ejbPostCreate");
        try {
            ALocal a1 = null;
            BLocal b1 = null;
            switch (flag) {
                case 0: {
                    a1 = this.createALocal(a.getId(), a.getName(), a.getValue());
                    b1 = this.createBLocal(b.getId(), b.getName(), b.getValue());
                    break;
                }
                case 1: {
                    a1 = this.createALocal(a.getId(), a.getName(), a.getValue());
                    b1 = this.createBLocal(b.getId(), b.getName(), b.getValue());
                    a1.setB(null);
                    b1.setA(null);
                    break;
                }
                case 2: {
                    a1 = this.createALocal(a.getId(), a.getName(), a.getValue());
                    b1 = this.createBLocal(b.getId(), b.getName(), b.getValue());
                    a1.setB(b1);
                    b1.setA(a1);
                }
            }
            this.setA1(a1);
            this.setB1(b1);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new CreateException("Exception occurred: " + e);
        }
    }

    public String ejbCreate(String id, String name, int value, ADVC aOne, BDVC bOne, ADVC aTwo, BDVC bTwo) throws CreateException {
        TestUtil.logTrace((String)"ejbCreateWith");
        try {
            this.setId(id);
            this.setName(name);
            this.setValue(value);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new CreateException("Exception occurred: " + e);
        }
        return null;
    }

    public void ejbPostCreate(String id, String name, int value, ADVC aOne, BDVC bOne, ADVC aTwo, BDVC bTwo) throws CreateException {
        TestUtil.logTrace((String)"ejbPostCreate");
        try {
            BLocal b1 = this.createBLocal(bOne.getId(), bOne.getName(), bOne.getValue());
            ALocal a1 = this.createALocal(aOne.getId(), aOne.getName(), aOne.getValue());
            a1.setB(b1);
            BLocal b2 = this.createBLocal(bTwo.getId(), bTwo.getName(), bTwo.getValue());
            ALocal a2 = this.createALocal(aTwo.getId(), aTwo.getName(), aTwo.getValue());
            a2.setB(b2);
            this.setA1(a1);
            this.setA2(a2);
            this.setB1(b1);
            this.setB2(b2);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new CreateException("Exception occurred: " + e);
        }
    }

    public void setEntityContext(EntityContext c) {
        TestUtil.logTrace((String)"setEntityContext");
        this.context = c;
        try {
            TestUtil.logMsg((String)"Obtain naming context");
            this.nctx = new TSNamingContext();
        }
        catch (NamingException e) {
            TestUtil.logErr((String)("NamingException ... " + e), (Throwable)e);
            throw new EJBException("unable to obtain naming context");
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Exception ... " + e), (Throwable)e);
            throw new EJBException("Exception occurred: " + e);
        }
    }

    public void unsetEntityContext() {
        TestUtil.logTrace((String)"unsetEntityContext");
    }

    public void ejbRemove() throws RemoveException {
        TestUtil.logTrace((String)"ejbRemove");
        if (this.getA1() != null) {
            TestUtil.logMsg((String)"deleting entity object relationship ... A1");
            this.getA1().remove();
        }
        if (this.getB1() != null) {
            TestUtil.logMsg((String)"deleting entity object relationship ... B1");
            this.getB1().remove();
        }
        if (this.getA2() != null) {
            TestUtil.logMsg((String)"deleting entity object relationship ... A2");
            this.getA2().remove();
        }
        if (this.getB2() != null) {
            TestUtil.logMsg((String)"deleting entity object relationship ... B2");
            this.getB2().remove();
        }
    }

    public void ejbActivate() {
        TestUtil.logTrace((String)"ejbActivate");
    }

    public void ejbPassivate() {
        TestUtil.logTrace((String)"ejbPassivate");
    }

    public void ejbLoad() {
        TestUtil.logTrace((String)"ejbLoad");
    }

    public void ejbStore() {
        TestUtil.logTrace((String)"ejbStore");
    }
}

