/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jpa.core.entitytest.persist.basic;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jpa.common.PMClientBase;
import com.sun.ts.tests.jpa.core.entitytest.persist.basic.A;
import java.util.Properties;

public class Client
extends PMClientBase {
    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    @Override
    public void setup(String[] args, Properties p) throws EETest.Fault {
        TestUtil.logTrace((String)"setup");
        try {
            super.setup(args, p);
            this.removeTestData();
        }
        catch (Exception e) {
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void persistBasicTest1() throws EETest.Fault {
        TestUtil.logTrace((String)"Begin persistBasicTest1");
        boolean pass = false;
        try {
            A aRef = new A("1", "A1", 1);
            this.getEntityTransaction().begin();
            if (!this.getInstanceStatus(aRef)) {
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in rollback:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new EETest.Fault("persistBasicTest1 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void persistBasicTest2() throws EETest.Fault {
        TestUtil.logTrace((String)"Begin persistBasicTest2");
        boolean pass = false;
        try {
            TestUtil.logTrace((String)"new A");
            A aRef = new A("2", "a2", 2);
            this.createA(aRef);
            A newA = this.findA("2");
            if (newA != null) {
                TestUtil.logTrace((String)"A IS NOT NULL");
            }
            this.getEntityTransaction().begin();
            pass = this.getInstanceStatus(this.findA("2"));
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in rollback:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new EETest.Fault("persistBasicTest2 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void persistBasicTest3() throws EETest.Fault {
        TestUtil.logTrace((String)"Begin persistBasicTest3");
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            A a1 = new A("3", "a3", 3);
            TestUtil.logTrace((String)"Persist Instance");
            this.getEntityManager().persist((Object)a1);
            this.getEntityManager().flush();
            TestUtil.logTrace((String)"find By Name");
            A result = (A)this.findByName("a3");
            TestUtil.logTrace((String)"Check to see that the entities are identical");
            if (result == a1) {
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                TestUtil.logErr((String)"Unexpected exception rolling back transaction", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new EETest.Fault("persistBasicTest3 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void persistBasicTest4() throws EETest.Fault {
        TestUtil.logTrace((String)"Begin persistBasicTest4");
        A aRef = new A("4", "a4", 4);
        boolean pass = false;
        try {
            TestUtil.logTrace((String)"Persist Instance");
            this.createA(aRef);
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"get Instance Status ");
            if (this.getInstanceStatus(this.findA("4"))) {
                try {
                    TestUtil.logTrace((String)"entity is managed, try to persist again ");
                    A newA = this.findA("4");
                    this.getEntityManager().persist((Object)newA);
                    TestUtil.logTrace((String)"Persist ignored on an already persisted entity as expected");
                    pass = true;
                }
                catch (Exception ee) {
                    TestUtil.logErr((String)"Unexpected exception trying to persist an already persisted entity", (Throwable)ee);
                    pass = false;
                }
            } else {
                TestUtil.logTrace((String)"Instance is not managed. Test Fails.");
                pass = false;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected exception rolling back transaction", (Throwable)re);
            }
        }
        if (!pass) {
            throw new EETest.Fault("persistBasicTest4 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void persistBasicTest5() throws EETest.Fault {
        TestUtil.logTrace((String)"Begin persistBasicTest5");
        A aRef = new A("5", "a5", 5);
        boolean pass = false;
        try {
            TestUtil.logTrace((String)"Persist Instance");
            this.createA(aRef);
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"get Instance Status ");
            if (this.getInstanceStatus(this.findA("5"))) {
                try {
                    TestUtil.logTrace((String)"entity is managed, try to change name and flush ");
                    A a2 = this.findA("5");
                    a2.setAName("a2");
                    this.getEntityManager().flush();
                    if (a2.getAName().equals("a2")) {
                        TestUtil.logTrace((String)"sync to database successful");
                        pass = true;
                    }
                }
                catch (Exception ee) {
                    TestUtil.logErr((String)"Unexpected exception trying to flush apersisted entity", (Throwable)ee);
                    pass = false;
                }
            } else {
                TestUtil.logTrace((String)"Instance is not already persisted. Test Fails.");
                pass = false;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected exception rolling back transaction", (Throwable)re);
            }
        }
        if (!pass) {
            throw new EETest.Fault("persistBasicTest5 failed");
        }
    }

    private void createA(A a) {
        TestUtil.logTrace((String)"Entered createA method");
        this.getEntityTransaction().begin();
        this.getEntityManager().persist((Object)a);
        this.getEntityManager().flush();
        this.getEntityTransaction().commit();
    }

    private A findA(String id) {
        TestUtil.logTrace((String)"Entered findA method");
        return (A)this.getEntityManager().find(A.class, (Object)id);
    }

    private Object findByName(String name) {
        TestUtil.logTrace((String)"Entered findByName method");
        return this.getEntityManager().createQuery("select a from A a where a.name = :name").setParameter("name", (Object)name).getSingleResult();
    }

    private boolean getInstanceStatus(Object o) {
        TestUtil.logTrace((String)"Entered getInstanceStatus method");
        return this.getEntityManager().contains(o);
    }

    @Override
    public void cleanup() throws EETest.Fault {
        TestUtil.logTrace((String)"Cleanup data");
        this.removeTestData();
        TestUtil.logTrace((String)"cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    private void removeTestData() {
        TestUtil.logTrace((String)"removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM AEJB_1XM_BI_BTOB").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

