/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jpa.core.criteriaapi.strquery;

import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.SetupMethod;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jpa.common.schema30.Alias;
import com.sun.ts.tests.jpa.common.schema30.CreditCard;
import com.sun.ts.tests.jpa.common.schema30.Customer;
import com.sun.ts.tests.jpa.common.schema30.LineItem;
import com.sun.ts.tests.jpa.common.schema30.Product;
import com.sun.ts.tests.jpa.common.schema30.Spouse;
import com.sun.ts.tests.jpa.common.schema30.Util;
import jakarta.persistence.NoResultException;
import jakarta.persistence.Tuple;
import jakarta.persistence.TypedQuery;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Fetch;
import jakarta.persistence.criteria.From;
import jakarta.persistence.criteria.Join;
import jakarta.persistence.criteria.JoinType;
import jakarta.persistence.criteria.Order;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import jakarta.persistence.criteria.Subquery;
import jakarta.persistence.metamodel.Attribute;
import java.sql.Date;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.Set;

public class Client
extends Util {
    @Override
    public void setup(String[] args, Properties p) throws EETest.Fault {
        TestUtil.logTrace((String)"Entering Setup");
        try {
            super.setup(args, p);
            this.getEntityManager();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    @SetupMethod(name="setupOrderData")
    public void queryTest1() throws EETest.Fault {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"find All Orders for Customer: Robert E. Bissett");
            CriteriaQuery cquery = cbuilder.createQuery(com.sun.ts.tests.jpa.common.schema30.Order.class);
            Root order = cquery.from(com.sun.ts.tests.jpa.common.schema30.Order.class);
            cquery.where((Expression)cbuilder.equal((Expression)order.get("customer").get("name"), (Expression)cbuilder.parameter(String.class, "name"))).select((Selection)order);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            tquery.setParameter("name", (Object)"Robert E. Bissett");
            List olist = tquery.getResultList();
            String[] expectedPKs = new String[]{"4", "9"};
            if (!this.checkEntityPK(olist, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 2 references, got: " + olist.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("queryTest1 failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void queryTest2() throws EETest.Fault {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"Execute findAllCustomers");
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root c = cquery.from(Customer.class);
            cquery.select((Selection)c);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List clist = tquery.getResultList();
            String[] expectedPKs = new String[this.customerRef.length];
            for (int i = 0; i < this.customerRef.length; ++i) {
                expectedPKs[i] = Integer.toString(i + 1);
            }
            if (!this.checkEntityPK(clist, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected " + this.customerRef.length + " references, got: " + clist.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("queryTest2 failed");
        }
    }

    @SetupMethod(name="setupAliasData")
    public void queryTest3() throws EETest.Fault {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"find All Customers with Alias: imc");
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            Join alias = customer.join("aliases");
            cquery.where((Expression)cbuilder.equal((Expression)alias.get("alias"), (Expression)cbuilder.parameter(String.class, "aName"))).select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            tquery.setParameter("aName", (Object)"imc");
            List clist = tquery.getResultList();
            String[] expectedPKs = new String[]{"8"};
            if (!this.checkEntityPK(clist, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 1 reference, got: " + clist.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("queryTest3 failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void queryTest4() throws EETest.Fault {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            Customer expected = (Customer)this.getEntityManager().find(Customer.class, (Object)"3");
            TestUtil.logTrace((String)"find Customer with Home Address in Swansea");
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            cquery.where(new Predicate[]{cbuilder.equal((Expression)customer.get("home").get("street"), (Expression)cbuilder.parameter(String.class, "street")), cbuilder.equal((Expression)customer.get("home").get("city"), (Expression)cbuilder.parameter(String.class, "city")), cbuilder.equal((Expression)customer.get("home").get("state"), (Expression)cbuilder.parameter(String.class, "state")), cbuilder.equal((Expression)customer.get("home").get("zip"), (Expression)cbuilder.parameter(String.class, "zip"))}).select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            tquery.setParameter("street", (Object)"125 Moxy Lane").setParameter("city", (Object)"Swansea").setParameter("state", (Object)"MA").setParameter("zip", (Object)"11345");
            Customer c = (Customer)tquery.getSingleResult();
            if (expected.equals((Object)c)) {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            } else {
                TestUtil.logErr((String)"Did not get expected results.");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("queryTest4 failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void queryTest5() throws EETest.Fault {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"find all Customers with AXP Credit Cards");
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            Join a = customer.join("creditCards");
            cquery.where((Expression)cbuilder.equal((Expression)a.get("type"), (Expression)cbuilder.parameter(String.class, "ccard")));
            cquery.select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            tquery.setParameter("ccard", (Object)"AXP");
            List clist = tquery.getResultList();
            String[] expectedPKs = new String[]{"1", "4", "5", "8", "9", "12", "15"};
            if (!this.checkEntityPK(clist, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 7 references, got: " + clist.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("queryTest5 failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void queryTest6() throws EETest.Fault {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"find Customers with Home Address Information");
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            cquery.select((Selection)customer);
            cquery.where((Expression)cbuilder.or(new Predicate[]{cbuilder.equal((Expression)customer.get("home").get("street"), (Expression)cbuilder.parameter(String.class, "street")), cbuilder.equal((Expression)customer.get("home").get("city"), (Expression)cbuilder.parameter(String.class, "city")), cbuilder.equal((Expression)customer.get("home").get("state"), (Expression)cbuilder.parameter(String.class, "state")), cbuilder.equal((Expression)customer.get("home").get("zip"), (Expression)cbuilder.parameter(String.class, "zip"))}));
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            tquery.setParameter("street", (Object)"47 Skyline Drive");
            tquery.setParameter("city", (Object)"Chelmsford");
            tquery.setParameter("state", (Object)"VT");
            tquery.setParameter("zip", (Object)"02155");
            List clist = tquery.getResultList();
            String[] expectedPKs = new String[]{"1", "10", "11", "13"};
            if (!this.checkEntityPK(clist, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 4 references, got: " + clist.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("queryTest6 failed");
        }
    }

    @SetupMethod(name="setupProductData")
    public void queryTest7() throws EETest.Fault {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"find All Products");
            CriteriaQuery cquery = cbuilder.createQuery(Product.class);
            Root product = cquery.from(Product.class);
            cquery.where((Expression)cbuilder.lt((Expression)product.get("quantity"), (Number)10));
            cquery.select((Selection)product);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List plist = tquery.getResultList();
            String[] expectedPKs = new String[]{"15", "21"};
            if (!this.checkEntityPK(plist, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected " + expectedPKs.length + "references, got: " + plist.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("queryTest7 failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void queryTest8() throws EETest.Fault {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"find all orders where the total price is NOT less than $4500");
            CriteriaQuery cquery = cbuilder.createQuery(com.sun.ts.tests.jpa.common.schema30.Order.class);
            Root order = cquery.from(com.sun.ts.tests.jpa.common.schema30.Order.class);
            cquery.where((Expression)cbuilder.lt((Expression)order.get("totalPrice"), (Number)4500).not());
            cquery.select((Selection)order);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List olist = tquery.getResultList();
            String[] expectedPKs = new String[]{"5", "11", "16"};
            if (!this.checkEntityPK(olist, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 3 references, got: " + olist.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("queryTest8 failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void queryTest9() throws EETest.Fault {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"find all orders where the customer name is Karen R. Tegan OR the total price is less than $100");
            CriteriaQuery cquery = cbuilder.createQuery(com.sun.ts.tests.jpa.common.schema30.Order.class);
            Root order = cquery.from(com.sun.ts.tests.jpa.common.schema30.Order.class);
            cquery.where((Expression)cbuilder.or((Expression)cbuilder.equal((Expression)order.get("customer").get("name"), (Object)"Karen R. Tegan"), (Expression)cbuilder.lt((Expression)order.get("totalPrice"), (Number)100)));
            cquery.select((Selection)order);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List olist = tquery.getResultList();
            String[] expectedPKs = new String[]{"6", "9", "10", "12", "13"};
            if (!this.checkEntityPK(olist, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 5 references, got: " + olist.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("queryTest9 failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void queryTest10() throws EETest.Fault {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"find all orders where line item quantity is 1 AND the order total less than 100 or customer name is Robert E. Bissett");
            CriteriaQuery cquery = cbuilder.createQuery(com.sun.ts.tests.jpa.common.schema30.Order.class);
            Root order = cquery.from(com.sun.ts.tests.jpa.common.schema30.Order.class);
            Join l = order.join("lineItemsCollection");
            cquery.where((Expression)cbuilder.or((Expression)cbuilder.and((Expression)cbuilder.lt((Expression)l.get("quantity"), (Number)2), (Expression)cbuilder.lt((Expression)order.get("totalPrice"), cbuilder.sum(cbuilder.sum(cbuilder.literal((Object)3), cbuilder.prod(cbuilder.literal((Object)54), (Number)2)), (Number)-8))), (Expression)cbuilder.equal((Expression)order.get("customer").get("name"), (Object)"Robert E. Bissett")));
            cquery.select((Selection)order).distinct(true);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List olist = tquery.getResultList();
            String[] expectedPKs = new String[]{"4", "9", "12", "13"};
            if (!this.checkEntityPK(olist, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 4 references, got: " + olist.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("queryTest10 failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void queryTest11() throws EETest.Fault {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"find all orders with line item quantity < 2 for customer Robert E. Bissett");
            CriteriaQuery cquery = cbuilder.createQuery(com.sun.ts.tests.jpa.common.schema30.Order.class);
            Root order = cquery.from(com.sun.ts.tests.jpa.common.schema30.Order.class);
            Join l = order.join("lineItemsCollection");
            cquery.where((Expression)cbuilder.and((Expression)cbuilder.lt((Expression)l.get("quantity"), (Number)2), (Expression)cbuilder.equal((Expression)order.get("customer").get("name"), (Object)"Robert E. Bissett")));
            cquery.select((Selection)order).distinct(true);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List olist = tquery.getResultList();
            String[] expectedPKs = new String[]{"4", "9"};
            if (!this.checkEntityPK(olist, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 2 references, got: " + olist.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("queryTest11 failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void queryTest12() throws EETest.Fault {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"find all orders with a total price BETWEEN $1000 and $1200");
            CriteriaQuery cquery = cbuilder.createQuery(com.sun.ts.tests.jpa.common.schema30.Order.class);
            Root order = cquery.from(com.sun.ts.tests.jpa.common.schema30.Order.class);
            cquery.where((Expression)cbuilder.between((Expression)order.get("totalPrice"), (Comparable)Double.valueOf(1000.0), (Comparable)Double.valueOf(1200.0))).select((Selection)order);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List olist = tquery.getResultList();
            String[] expectedPKs = new String[]{"1", "3", "7", "8", "14"};
            if (!this.checkEntityPK(olist, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 5 references, got: " + olist.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("queryTest12 failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void queryTest13() throws EETest.Fault {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"find all orders with a total price NOT BETWEEN $1000 and $1200");
            CriteriaQuery cquery = cbuilder.createQuery(com.sun.ts.tests.jpa.common.schema30.Order.class);
            Root order = cquery.from(com.sun.ts.tests.jpa.common.schema30.Order.class);
            cquery.where((Expression)cbuilder.between((Expression)order.get("totalPrice"), (Comparable)Double.valueOf(1000.0), (Comparable)Double.valueOf(1200.0)).not()).select((Selection)order);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List olist = tquery.getResultList();
            String[] expectedPKs = new String[]{"2", "4", "5", "6", "9", "10", "11", "12", "13", "15", "16", "17", "18", "19", "20"};
            if (!this.checkEntityPK(olist, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 15 references, got: " + olist.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("queryTest13 failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void queryTest14() throws EETest.Fault {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"find all orders that do not have approved Credit Cards");
            CriteriaQuery cquery = cbuilder.createQuery(com.sun.ts.tests.jpa.common.schema30.Order.class);
            Root order = cquery.from(com.sun.ts.tests.jpa.common.schema30.Order.class);
            cquery.where((Expression)cbuilder.isFalse((Expression)order.get("creditCard").get("approved")));
            cquery.select((Selection)order);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List olist = tquery.getResultList();
            String[] expectedPKs = new String[]{"1", "7", "11", "13", "18", "20"};
            if (!this.checkEntityPK(olist, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 6 references, got: " + olist.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("queryTest14 failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void queryTest15() throws EETest.Fault {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            Customer expected = (Customer)this.getEntityManager().find(Customer.class, (Object)"5");
            TestUtil.logTrace((String)"find customer with name: Stephen S. D'Milla");
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            cquery.where((Expression)cbuilder.equal((Expression)customer.get("name"), (Expression)cbuilder.parameter(String.class, "cName")));
            cquery.select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            tquery.setParameter("cName", (Object)"Stephen S. D'Milla");
            Customer c = (Customer)tquery.getSingleResult();
            if (expected.equals((Object)c)) {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            } else {
                TestUtil.logErr((String)"Did not get expected results.");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("queryTest15 failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void queryTest16() throws EETest.Fault {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"find all customers IN home city: Lexington");
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            cquery.where((Expression)customer.get("home").get("city").in(new Object[]{"Lexington"}));
            cquery.select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List clist = tquery.getResultList();
            String[] expectedPKs = new String[]{"2"};
            if (!this.checkEntityPK(clist, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 1 reference, got: " + clist.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("queryTest16 failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void queryTest17() throws EETest.Fault {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"find all customers NOT IN home city: Swansea or Brookline");
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            Join h = customer.join("home", JoinType.LEFT);
            cquery.where((Expression)h.get("city").in(new Object[]{"Swansea", "Brookline"}).not());
            cquery.select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List clist = tquery.getResultList();
            String[] expectedPKs = new String[]{"1", "2", "5", "6", "7", "8", "10", "11", "12", "13", "14", "15", "16", "17", "18"};
            if (!this.checkEntityPK(clist, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 15 references, got: " + clist.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("queryTest17 failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void queryTest18() throws EETest.Fault {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"find All Customers with home ZIP CODE that ends in 77");
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            cquery.where((Expression)cbuilder.like((Expression)customer.get("home").get("zip"), "%77"));
            cquery.select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List clist = tquery.getResultList();
            String[] expectedPKs = new String[]{"2"};
            if (!this.checkEntityPK(clist, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 1 reference, got: " + clist.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("queryTest18 failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void queryTest19() throws EETest.Fault {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"find all customers with a home zip code that does not contain 44 in the third and fourth position");
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            cquery.where((Expression)cbuilder.notLike((Expression)customer.get("home").get("zip"), "%44_"));
            cquery.select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List clist = tquery.getResultList();
            String[] expectedPKs = new String[]{"1", "2", "3", "4", "5", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18"};
            if (!this.checkEntityPK(clist, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 15 references, got: " + clist.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("queryTest19 failed");
        }
    }

    @SetupMethod(name="setupAliasData")
    public void queryTest20() throws EETest.Fault {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"find all customers who do not have aliases");
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            cquery.where((Expression)cbuilder.isEmpty((Expression)customer.get("aliases")));
            cquery.select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List clist = tquery.getResultList();
            String[] expectedPKs = new String[]{"6", "15", "16", "17", "18", "19", "20"};
            if (!this.checkEntityPK(clist, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 7 references, got: " + clist.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("queryTest20 failed");
        }
    }

    @SetupMethod(name="setupAliasData")
    public void queryTest21() throws EETest.Fault {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"find all customers who have aliases");
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            cquery.where((Expression)cbuilder.isNotEmpty((Expression)customer.get("aliases")));
            cquery.select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List clist = tquery.getResultList();
            String[] expectedPKs = new String[]{"1", "2", "3", "4", "5", "7", "8", "9", "10", "11", "12", "13", "14"};
            if (!this.checkEntityPK(clist, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 15 reference, got: " + clist.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("queryTest21 failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void queryTest22() throws EETest.Fault {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"find All Customers who have a null work zip code");
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            cquery.where((Expression)customer.get("work").get("zip").isNull());
            cquery.select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List clist = tquery.getResultList();
            String[] expectedPKs = new String[]{"13"};
            if (!this.checkEntityPK(clist, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 1 reference, got: " + clist.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("queryTest22 failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void queryTest23() throws EETest.Fault {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"find all customers who do not have null work zip code entry");
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            cquery.where((Expression)customer.get("work").get("zip").isNotNull());
            cquery.select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List clist = tquery.getResultList();
            String[] expectedPKs = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "14", "15", "16", "17", "18"};
            if (!this.checkEntityPK(clist, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 17 references, got: " + clist.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("queryTest23 failed");
        }
    }

    @SetupMethod(name="setupAliasData")
    public void queryTest24() throws EETest.Fault {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"find all aliases who have match: stevie");
            CriteriaQuery cquery = cbuilder.createQuery(Alias.class);
            Root alias = cquery.from(Alias.class);
            cquery.where((Expression)cbuilder.equal((Expression)alias.get("alias"), cbuilder.concat(cbuilder.literal((Object)"ste"), "vie")));
            cquery.select((Selection)alias);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List alist = tquery.getResultList();
            String[] expectedPKs = new String[]{"14"};
            if (!this.checkEntityPK(alist, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 1 reference, got: " + alist.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("queryTest24 failed");
        }
    }

    @SetupMethod(name="setupAliasData")
    public void queryTest25() throws EETest.Fault {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"find all aliases containing the substring: iris");
            CriteriaQuery cquery = cbuilder.createQuery(Alias.class);
            Root alias = cquery.from(Alias.class);
            cquery.where((Expression)cbuilder.equal((Expression)alias.get("alias"), cbuilder.substring((Expression)cbuilder.parameter(String.class, "string1"), (Expression)cbuilder.parameter(Integer.class, "int2"), (Expression)cbuilder.parameter(Integer.class, "int3"))));
            cquery.select((Selection)alias);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            tquery.setParameter("string1", (Object)"iris");
            tquery.setParameter("int2", (Object)1);
            tquery.setParameter("int3", (Object)4);
            List alist = tquery.getResultList();
            String[] expectedPKs = new String[]{"20"};
            if (!this.checkEntityPK(alist, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 1 reference, got: " + alist.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("queryTest25 failed");
        }
    }

    @SetupMethod(name="setupAliasData")
    public void queryTest26() throws EETest.Fault {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"find aliases whose alias name is greater than 4 characters");
            CriteriaQuery cquery = cbuilder.createQuery(Alias.class);
            Root alias = cquery.from(Alias.class);
            cquery.where((Expression)cbuilder.gt(cbuilder.length((Expression)alias.get("alias")), (Number)4));
            cquery.select((Selection)alias);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List alist = tquery.getResultList();
            String[] expectedPKs = new String[]{"8", "10", "13", "14", "18", "28", "29"};
            if (!this.checkEntityPK(alist, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 7 references, got: " + alist.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("queryTest26 failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void queryTest27() throws EETest.Fault {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"find all Orders with a total price greater than 1180");
            CriteriaQuery cquery = cbuilder.createQuery(com.sun.ts.tests.jpa.common.schema30.Order.class);
            Root order = cquery.from(com.sun.ts.tests.jpa.common.schema30.Order.class);
            cquery.where((Expression)cbuilder.lt((Expression)cbuilder.parameter(Double.class, "dbl"), cbuilder.abs((Expression)order.get("totalPrice"))));
            cquery.select((Selection)order);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            tquery.setParameter("dbl", (Object)1180.0);
            List olist = tquery.getResultList();
            String[] expectedPKs = new String[]{"1", "2", "4", "5", "6", "11", "16", "17", "18"};
            if (!this.checkEntityPK(olist, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 9 references, got: " + olist.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("queryTest27 failed");
        }
    }

    @SetupMethod(name="setupAliasData")
    public void queryTest28() throws EETest.Fault {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"find all aliases who contain the string: ev in their alias name");
            CriteriaQuery cquery = cbuilder.createQuery(Alias.class);
            Root alias = cquery.from(Alias.class);
            cquery.where((Expression)cbuilder.equal(cbuilder.locate((Expression)alias.get("alias"), "ev"), (Object)3));
            cquery.select((Selection)alias);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List alist = tquery.getResultList();
            String[] expectedPKs = new String[]{"13", "14", "18"};
            if (!this.checkEntityPK(alist, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 3 references, got: " + alist.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("queryTest28 failed");
        }
    }

    @SetupMethod(name="setupAliasData")
    public void queryTest29() throws EETest.Fault {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"find aliases who are members of customersNoop");
            CriteriaQuery cquery = cbuilder.createQuery(Alias.class);
            Root alias = cquery.from(Alias.class);
            cquery.where((Expression)cbuilder.isMember((Expression)alias.get("customerNoop"), (Expression)alias.get("customersNoop")));
            cquery.select((Selection)alias);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List alist = tquery.getResultList();
            String[] expectedPKs = new String[]{};
            if (!this.checkEntityPK(alist, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 0 references, got: " + alist.size()));
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("queryTest29 failed");
        }
    }

    @SetupMethod(name="setupAliasData")
    public void queryTest30() throws EETest.Fault {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"find aliases who are NOT members of collection");
            CriteriaQuery cquery = cbuilder.createQuery(Alias.class);
            Root alias = cquery.from(Alias.class);
            cquery.where((Expression)cbuilder.isNotMember((Expression)alias.get("customerNoop"), (Expression)alias.get("customersNoop")));
            cquery.select((Selection)alias);
            cquery.distinct(true);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List alist = tquery.getResultList();
            String[] expectedPKs = new String[this.aliasRef.length];
            for (int i = 0; i < this.aliasRef.length; ++i) {
                expectedPKs[i] = Integer.toString(i + 1);
            }
            if (!this.checkEntityPK(alist, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected " + this.aliasRef.length + " references, got: " + alist.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("queryTest30 failed");
        }
    }

    @SetupMethod(name="setupAliasData")
    public void queryTest31() throws EETest.Fault {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"find all customers with an alias LIKE: sh_ll");
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            Join a = customer.join("aliases");
            cquery.where((Expression)cbuilder.like((Expression)a.get("alias"), "sh\\_ll", '\\'));
            cquery.select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List clist = tquery.getResultList();
            String[] expectedPKs = new String[]{"3"};
            if (!this.checkEntityPK(clist, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 1 reference, got: " + clist.size()));
                TestUtil.logTrace((String)"Expected results received");
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("queryTest31 failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void queryTest32() throws EETest.Fault {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"find all orders where line items are members of the orders");
            CriteriaQuery cquery = cbuilder.createQuery(com.sun.ts.tests.jpa.common.schema30.Order.class);
            Root order = cquery.from(com.sun.ts.tests.jpa.common.schema30.Order.class);
            Root l = cquery.from(LineItem.class);
            cquery.where((Expression)cbuilder.isMember((Expression)l, (Expression)order.get("lineItemsCollection")));
            cquery.select((Selection)order).distinct(true);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List olist = tquery.getResultList();
            String[] expectedPKs = new String[this.orderRef.length];
            for (int i = 0; i < this.orderRef.length; ++i) {
                expectedPKs[i] = Integer.toString(i + 1);
            }
            if (!this.checkEntityPK(olist, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected " + this.orderRef.length + "references, got: " + olist.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("queryTest32 failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void queryTest33() throws EETest.Fault {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"find orders whose orders are do NOT contain the specified line items");
            LineItem liDvc = (LineItem)this.getEntityManager().find(LineItem.class, (Object)"30");
            CriteriaQuery cquery = cbuilder.createQuery(com.sun.ts.tests.jpa.common.schema30.Order.class);
            Root order = cquery.from(com.sun.ts.tests.jpa.common.schema30.Order.class);
            cquery.where((Expression)cbuilder.isNotMember((Expression)cbuilder.parameter(LineItem.class, "liDvc"), (Expression)order.get("lineItemsCollection")));
            cquery.select((Selection)order);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            tquery.setParameter("liDvc", (Object)liDvc);
            List olist = tquery.getResultList();
            String[] expectedPKs = new String[]{"1", "2", "3", "4", "5", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20"};
            if (!this.checkEntityPK(olist, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 19 references, got: " + olist.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("queryTest33 failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void queryTest34() throws EETest.Fault {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"find orders who have Samples in their orders");
            CriteriaQuery cquery = cbuilder.createQuery(com.sun.ts.tests.jpa.common.schema30.Order.class);
            Root order = cquery.from(com.sun.ts.tests.jpa.common.schema30.Order.class);
            cquery.where((Expression)cbuilder.isMember((Expression)order.get("sampleLineItem"), (Expression)order.get("lineItemsCollection")));
            cquery.select((Selection)order);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List olist = tquery.getResultList();
            String[] expectedPKs = new String[]{"1", "6"};
            if (!this.checkEntityPK(olist, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 2 references, got: " + olist.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("queryTest34 failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void queryTest35() throws EETest.Fault {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"find all orders which contain lineitems not of quantities 1 or 5");
            CriteriaQuery cquery = cbuilder.createQuery(com.sun.ts.tests.jpa.common.schema30.Order.class);
            Root order = cquery.from(com.sun.ts.tests.jpa.common.schema30.Order.class);
            Join l = order.join("lineItemsCollection");
            cquery.where((Expression)l.get("quantity").in(new Object[]{1, 5}).not());
            cquery.select((Selection)order).distinct(true);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List olist = tquery.getResultList();
            String[] expectedPKs = new String[]{"10", "12", "14", "15", "16", "17", "18", "19", "20"};
            if (!this.checkEntityPK(olist, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 9 references, got: " + olist.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("queryTest35 failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void queryTest36() throws EETest.Fault {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"find all customers who lives in city Attleboro");
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            cquery.where((Expression)customer.get("home").get("city").in(new Expression[]{cbuilder.parameter(String.class, "city")}));
            cquery.select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            tquery.setParameter("city", (Object)"Attleboro");
            List clist = tquery.getResultList();
            String[] expectedPKs = new String[]{"13"};
            if (!this.checkEntityPK(clist, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 1 reference, got: " + clist.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("queryTest36 failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void queryTest37() throws EETest.Fault {
        boolean pass1 = false;
        boolean pass2 = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"Execute two queries composed differently and verify results");
            CriteriaQuery cquery1 = cbuilder.createQuery(Customer.class);
            Root customer1 = cquery1.from(Customer.class);
            cquery1.where((Expression)customer1.get("home").get("state").in(new Object[]{"NH", "RI"})).select((Selection)customer1);
            TypedQuery tquery1 = this.getEntityManager().createQuery(cquery1);
            List clist1 = tquery1.getResultList();
            String[] expectedPKs = new String[]{"5", "6", "12", "14", "16"};
            CriteriaQuery cquery2 = cbuilder.createQuery(Customer.class);
            Root customer2 = cquery2.from(Customer.class);
            cquery2.where((Expression)cbuilder.or((Expression)cbuilder.equal((Expression)customer2.get("home").get("state"), (Object)"NH"), (Expression)cbuilder.equal((Expression)customer2.get("home").get("state"), (Object)"RI"))).select((Selection)customer2);
            TypedQuery tquery2 = this.getEntityManager().createQuery(cquery2);
            List clist2 = tquery2.getResultList();
            String[] expectedPKs2 = new String[]{"5", "6", "12", "14", "16"};
            if (!this.checkEntityPK(clist1, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results for first query.  Expected 5 reference, got: " + clist1.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received for first query");
                pass1 = true;
            }
            if (!this.checkEntityPK(clist2, expectedPKs2)) {
                TestUtil.logErr((String)("Did not get expected results for second query.  Expected 5 reference, got: " + clist2.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received for second query");
                pass2 = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass1 || !pass2) {
            throw new EETest.Fault("queryTest37 failed");
        }
    }

    @SetupMethod(name="setupProductData")
    public void queryTest38() throws EETest.Fault {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"find orders that have the quantity of 50 available");
            CriteriaQuery cquery = cbuilder.createQuery(Product.class);
            Root product = cquery.from(Product.class);
            cquery.where((Expression)cbuilder.equal(cbuilder.mod(cbuilder.literal((Object)550), Integer.valueOf(100)), (Expression)product.get("quantity")));
            cquery.select((Selection)product);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List plist = tquery.getResultList();
            String[] expectedPKs = new String[]{"5", "20"};
            if (!this.checkEntityPK(plist, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 2 references, got: " + plist.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("queryTest38 failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void queryTest39() throws EETest.Fault {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        double dbl = 50.0;
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"find customers with specific credit card balance");
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            Join b = customer.join("creditCards");
            cquery.where((Expression)cbuilder.equal(cbuilder.sqrt((Expression)b.get("balance")), (Expression)cbuilder.parameter(Double.class, "dbl")));
            cquery.select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            tquery.setParameter("dbl", (Object)50.0);
            List clist = tquery.getResultList();
            String[] expectedPKs = new String[]{"3"};
            if (!this.checkEntityPK(clist, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 1 reference, got: " + clist.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("queryTest39 failed");
        }
    }

    @SetupMethod(name="setupProductData")
    public void queryTest40() throws EETest.Fault {
        boolean pass1 = false;
        boolean pass2 = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"Execute two queries composed differently and verify results Execute Query 1");
            CriteriaQuery cquery1 = cbuilder.createQuery(Product.class);
            Root product1 = cquery1.from(Product.class);
            cquery1.where((Expression)cbuilder.between((Expression)product1.get("quantity"), (Comparable)Integer.valueOf(10), (Comparable)Integer.valueOf(20)));
            cquery1.select((Selection)product1);
            TypedQuery tquery1 = this.getEntityManager().createQuery(cquery1);
            List plist1 = tquery1.getResultList();
            String[] expectedPKs = new String[]{"8", "9", "17", "27", "28", "31", "36"};
            TestUtil.logTrace((String)"Execute Query 2");
            CriteriaQuery cquery2 = cbuilder.createQuery(Product.class);
            Root product2 = cquery2.from(Product.class);
            cquery2.where((Expression)cbuilder.and((Expression)cbuilder.ge((Expression)product2.get("quantity"), (Number)10), (Expression)cbuilder.le((Expression)product2.get("quantity"), (Number)20))).select((Selection)product2);
            TypedQuery tquery2 = this.getEntityManager().createQuery(cquery2);
            List plist2 = tquery2.getResultList();
            String[] expectedPKs2 = new String[]{"8", "9", "17", "27", "28", "31", "36"};
            if (!this.checkEntityPK(plist1, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results for first query in queryTest40.   Expected 7 references, got: " + plist1.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received for first query in queryTest40.");
                pass1 = true;
            }
            if (!this.checkEntityPK(plist2, expectedPKs2)) {
                TestUtil.logErr((String)("Did not get expected results for second query in queryTest40.   Expected 7 references, got: " + plist2.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received for second query in queryTest40.");
                pass2 = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass1 || !pass2) {
            throw new EETest.Fault("queryTest40 failed");
        }
    }

    @SetupMethod(name="setupProductData")
    public void queryTest41() throws EETest.Fault {
        boolean pass1 = false;
        boolean pass2 = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"Execute two queries composed differently and verify results Execute first query");
            CriteriaQuery cquery1 = cbuilder.createQuery(Product.class);
            Root product1 = cquery1.from(Product.class);
            cquery1.where((Expression)cbuilder.between((Expression)product1.get("quantity"), (Comparable)Integer.valueOf(10), (Comparable)Integer.valueOf(20)).not());
            cquery1.select((Selection)product1);
            TypedQuery tquery1 = this.getEntityManager().createQuery(cquery1);
            List plist1 = tquery1.getResultList();
            String[] expectedPKs = new String[]{"1", "2", "3", "4", "5", "6", "7", "10", "11", "12", "13", "14", "15", "16", "18", "19", "20", "21", "22", "23", "24", "25", "26", "29", "30", "32", "33", "34", "35", "37", "38"};
            TestUtil.logTrace((String)"Execute second query");
            CriteriaQuery cquery2 = cbuilder.createQuery(Product.class);
            Root product2 = cquery2.from(Product.class);
            cquery2.where((Expression)cbuilder.or((Expression)cbuilder.lt((Expression)product2.get("quantity"), (Number)10), (Expression)cbuilder.gt((Expression)product2.get("quantity"), (Number)20))).select((Selection)product2);
            TypedQuery tquery2 = this.getEntityManager().createQuery(cquery2);
            List plist2 = tquery2.getResultList();
            String[] expectedPKs2 = new String[]{"1", "2", "3", "4", "5", "6", "7", "10", "11", "12", "13", "14", "15", "16", "18", "19", "20", "21", "22", "23", "24", "25", "26", "29", "30", "32", "33", "34", "35", "37", "38"};
            if (!this.checkEntityPK(plist1, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results for first query.  Expected 31 references, got: " + plist1.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received for first query");
                pass1 = true;
            }
            if (!this.checkEntityPK(plist2, expectedPKs2)) {
                TestUtil.logErr((String)("Did not get expected results for second query.  Expected 31 references, got: " + plist2.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received for second query");
                pass2 = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass1 || !pass2) {
            throw new EETest.Fault("queryTest41 failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void queryTest42() throws EETest.Fault {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"find all orders where related customer name is not null");
            CriteriaQuery cquery = cbuilder.createQuery(com.sun.ts.tests.jpa.common.schema30.Order.class);
            Root order = cquery.from(com.sun.ts.tests.jpa.common.schema30.Order.class);
            cquery.where((Expression)cbuilder.isNotNull((Expression)order.get("customer").get("name")));
            cquery.select((Selection)order);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List olist = tquery.getResultList();
            String[] expectedPKs = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "14", "15", "16", "17", "18", "19", "20"};
            if (!this.checkEntityPK(olist, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 19 references, got: " + olist.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("queryTest42 failed");
        }
    }

    @SetupMethod(name="setupProductData")
    public void queryTest43() throws EETest.Fault {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"Check results of AND operator: False AND False = False");
            CriteriaQuery cquery = cbuilder.createQuery(Product.class);
            Root product = cquery.from(Product.class);
            cquery.where((Expression)cbuilder.and((Expression)cbuilder.gt((Expression)product.get("quantity"), cbuilder.sum(cbuilder.literal((Object)500), (Expression)cbuilder.parameter(Integer.class, "int1"))), (Expression)cbuilder.isNull((Expression)product.get("partNumber"))));
            cquery.select((Selection)product);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            tquery.setParameter("int1", (Object)100);
            List plist = tquery.getResultList();
            String[] expectedPKs = new String[]{};
            if (!this.checkEntityPK(plist, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 0 references, got: " + plist.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("queryTest43 failed");
        }
    }

    @SetupMethod(name="setupProductData")
    public void queryTest44() throws EETest.Fault {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"provide a null value for a comparison operation and verify the results");
            CriteriaQuery cquery = cbuilder.createQuery(Product.class);
            Root product = cquery.from(Product.class);
            cquery.where((Expression)cbuilder.equal((Expression)product.get("name"), (Expression)cbuilder.parameter(String.class, "num1")));
            cquery.select((Selection)product);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            tquery.setParameter("num1", null);
            List plist = tquery.getResultList();
            String[] expectedPKs = new String[]{};
            if (!this.checkEntityPK(plist, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 0 references, got: " + plist.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("queryTest44 failed");
        }
    }

    @SetupMethod(name="setupAliasData")
    public void queryTest45() throws EETest.Fault {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"find customers whose id is greater than 1 OR where the relationship is NOT EMPTY");
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            cquery.where((Expression)cbuilder.or((Expression)cbuilder.isNotEmpty((Expression)customer.get("aliasesNoop")), (Expression)cbuilder.notEqual((Expression)customer.get("id"), (Object)"1")));
            cquery.select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List clist = tquery.getResultList();
            String[] expectedPKs = new String[]{"2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20"};
            if (!this.checkEntityPK(clist, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 19 references, got: " + clist.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("queryTest45 failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void queryTest47() throws EETest.Fault {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        Object[] expectedZips = new String[]{"00252", "00252", "00252", "00252", "00252", "00252", "00252", "00252", "00252", "00252", "00252", "00252", "00252", "00252", "00252", "00252", "11345"};
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"find work zip codes that are not null");
            CriteriaQuery cquery = cbuilder.createQuery(String.class);
            Root customer = cquery.from(Customer.class);
            cquery.where((Expression)cbuilder.isNotNull((Expression)customer.get("work").get("zip"))).select((Selection)customer.get("work").get("zip")).orderBy(new Order[]{cbuilder.asc((Expression)customer.get("work").get("zip"))});
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List clist = tquery.getResultList();
            Object[] result = clist.toArray(new String[clist.size()]);
            TestUtil.logTrace((String)"Compare results of work zip codes");
            pass = Arrays.equals(expectedZips, result);
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("queryTest47 failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void queryTest48() throws EETest.Fault {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        Object[] expectedBalances = new Double[]{400.0, 500.0, 750.0, 1000.0, 1400.0, 1500.0, 2000.0, 2500.0, 4400.0, 5000.0, 5500.0, 7000.0, 7400.0, 8000.0, 9500.0, 13000.0, 15000.0, 23000.0};
        try {
            Object[] result;
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"find all credit card balances");
            CriteriaQuery cquery = cbuilder.createQuery(Double.class);
            Root order = cquery.from(com.sun.ts.tests.jpa.common.schema30.Order.class);
            cquery.select((Selection)order.get("creditCard").get("balance")).distinct(true);
            cquery.orderBy(new Order[]{cbuilder.asc((Expression)order.get("creditCard").get("balance"))});
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List olist = tquery.getResultList();
            for (Double d : result = olist.toArray(new Double[olist.size()])) {
                TestUtil.logTrace((String)("query results returned:  " + d));
            }
            TestUtil.logTrace((String)"Compare expected results to query results");
            pass = Arrays.equals(expectedBalances, result);
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("queryTest48 failed");
        }
    }

    @SetupMethod(name="setupAliasData")
    public void queryTest49() throws EETest.Fault {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"find All Customers who have a null relationship");
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            Join a = customer.join("aliases");
            cquery.where((Expression)cbuilder.isNull((Expression)a.get("customerNoop")));
            cquery.select((Selection)customer).distinct(true);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List clist = tquery.getResultList();
            String[] expectedPKs = new String[]{"1", "2", "3", "4", "5", "7", "8", "9", "10", "11", "12", "13", "14"};
            if (!this.checkEntityPK(clist, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 13 references, got: " + clist.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("queryTest49 failed");
        }
    }

    @SetupMethod(name="setupAliasData")
    public void queryTest50() throws EETest.Fault {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"find all customers with an alias that contains an underscore");
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            Join a = customer.join("aliases");
            cquery.where((Expression)cbuilder.like((Expression)a.get("alias"), "%\\_%", '\\'));
            cquery.select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List clist = tquery.getResultList();
            String[] expectedPKs = new String[]{"3"};
            if (!this.checkEntityPK(clist, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 1 reference, got: " + clist.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("queryTest50 failed");
        }
    }

    @SetupMethod(name="setupAliasData")
    public void queryTest51() throws EETest.Fault {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"find All Customers who do not have null relationship");
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            Join a = customer.join("aliases");
            cquery.where((Expression)cbuilder.isNotNull((Expression)a.get("customerNoop")));
            cquery.select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List clist = tquery.getResultList();
            if (clist.size() != 0) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 0 references, got: " + clist.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("queryTest51 failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void queryTest52() throws EETest.Fault {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            cquery.where((Expression)cbuilder.and((Expression)cbuilder.isNotNull((Expression)customer.get("country")), (Expression)cbuilder.equal((Expression)customer.get("name"), (Expression)cbuilder.parameter(String.class, "cName"))));
            cquery.select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            tquery.setParameter("cName", (Object)"Shelly D. McGowan");
            List clist = tquery.getResultList();
            String[] expectedPKs = new String[]{"3"};
            if (!this.checkEntityPK(clist, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 1 reference, got: " + clist.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("queryTest52 failed");
        }
    }

    @SetupMethod(name="setupAliasData")
    public void queryTest53() throws EETest.Fault {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"determine if customer has a NULL relationship");
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            Join a = customer.join("aliases");
            cquery.where((Expression)cbuilder.or((Expression)cbuilder.equal((Expression)customer.get("name"), (Expression)cbuilder.parameter(String.class, "cName")), (Expression)cbuilder.isNull((Expression)a.get("customerNoop"))));
            cquery.select((Selection)customer).distinct(true);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            tquery.setParameter("cName", (Object)"Arthur D. Frechette");
            List clist = tquery.getResultList();
            String[] expectedPKs = new String[]{"1", "2", "3", "4", "5", "7", "8", "9", "10", "11", "12", "13", "14"};
            if (!this.checkEntityPK(clist, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 13 references, got: " + clist.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("queryTest53 failed");
        }
    }

    @SetupMethod(name="setupAliasData")
    public void queryTest54() throws EETest.Fault {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"determine if customers have a NULL relationship");
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            Join a = customer.join("aliases");
            cquery.where((Expression)cbuilder.isNotNull((Expression)a.get("customerNoop")));
            cquery.select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List clist = tquery.getResultList();
            if (clist.size() != 0) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 0 references, got: " + clist.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("queryTest54 failed");
        }
    }

    @SetupMethod(name="setupPhoneData")
    public void queryTest55() throws EETest.Fault {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"determine which customers have an area code beginning with 9");
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            Join p = customer.join("home").join("phones");
            cquery.where((Expression)cbuilder.like((Expression)p.get("area"), (Expression)cbuilder.parameter(String.class, "area")));
            cquery.select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            tquery.setParameter("area", (Object)"9%");
            List clist = tquery.getResultList();
            String[] expectedPKs = new String[]{"3", "12", "16"};
            if (!this.checkEntityPK(clist, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 3 references, got: " + clist.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("queryTest55 failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void queryTest56() throws EETest.Fault {
        boolean pass1 = false;
        boolean pass2 = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        String[] expectedZips = new String[]{"00252", "00252", "00252", "00252", "00252", "00252", "00252", "00252", "00252", "00252", "00252", "00252", "00252", "00252", "00252", "00252", "11345"};
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"find all work zip codes");
            CriteriaQuery cquery = cbuilder.createQuery(String.class);
            Root customer = cquery.from(Customer.class);
            cquery.select((Selection)customer.get("work").get("zip"));
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List clist = tquery.getResultList();
            if (clist.size() != 18) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 18 references, got: " + clist.size()));
            } else {
                pass1 = true;
                int numOfNull = 0;
                int foundZip = 0;
                block2: for (String s : clist) {
                    TestUtil.logTrace((String)"Check contents of List for null");
                    String o = s;
                    if (o == null) {
                        ++numOfNull;
                        continue;
                    }
                    TestUtil.logTrace((String)"Check List for expected zip codes");
                    for (int l = 0; l < 17; ++l) {
                        if (!expectedZips[l].equals(o)) continue;
                        ++foundZip;
                        continue block2;
                    }
                }
                if (numOfNull != 1 || foundZip != 17) {
                    TestUtil.logErr((String)"Did not get expected results");
                } else {
                    TestUtil.logTrace((String)"Expected results received");
                    pass2 = true;
                }
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass1 || !pass2) {
            throw new EETest.Fault("queryTest56 failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void queryTest58() throws EETest.Fault {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"find home zip codes");
            CriteriaQuery cquery = cbuilder.createQuery(String.class);
            Root customer = cquery.from(Customer.class);
            cquery.where((Expression)cbuilder.equal((Expression)customer.get("home").get("street"), (Object)"212 Edgewood Drive")).select((Selection)customer.get("name"));
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            Object s = tquery.getSingleResult();
            if (s != null) {
                TestUtil.logErr((String)"Did not get expected results.  Expected null.");
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("queryTest58 failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void queryTest59() throws EETest.Fault {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"determine which customers have an null name");
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            cquery.where((Expression)cbuilder.isNull((Expression)customer.get("name")));
            cquery.select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List clist = tquery.getResultList();
            String[] expectedPKs = new String[]{"12"};
            if (!this.checkEntityPK(clist, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 1 reference, got: " + clist.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("queryTest59 failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void queryTest60() throws EETest.Fault {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"find Customers with an Order");
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            customer.join("orders");
            cquery.select((Selection)customer).distinct(true);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List clist = tquery.getResultList();
            String[] expectedPKs = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18"};
            if (!this.checkEntityPK(clist, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 18 references, got: " + clist.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("queryTest60 failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void queryTest61() throws EETest.Fault {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            Join w = customer.join("work", JoinType.LEFT);
            cquery.where((Expression)cbuilder.isNull((Expression)w.get("zip")));
            cquery.select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List clist = tquery.getResultList();
            String[] expectedPKs = new String[]{"13", "19", "20"};
            if (!this.checkEntityPK(clist, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 3 references, got: " + clist.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("queryTest61 failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void queryTest62() throws EETest.Fault {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            cquery.where((Expression)cbuilder.ge(cbuilder.size((Expression)customer.get("orders")), (Number)2));
            cquery.select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List clist = tquery.getResultList();
            String[] expectedPKs = new String[]{"4", "14"};
            if (!this.checkEntityPK(clist, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 2 references, got: " + clist.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("queryTest62 failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void queryTest63() throws EETest.Fault {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            cquery.where((Expression)cbuilder.gt(cbuilder.size((Expression)customer.get("orders")), (Number)100));
            cquery.select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List clist = tquery.getResultList();
            String[] expectedPKs = new String[]{};
            if (!this.checkEntityPK(clist, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 0 references, got: " + clist.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("queryTest63 failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void queryTest64() throws EETest.Fault {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            cquery.where((Expression)cbuilder.equal((Expression)customer.get("work").get("city"), (Expression)cbuilder.parameter(String.class, "workcity")));
            cquery.select((Selection)cbuilder.construct(Customer.class, new Selection[]{customer.get("id"), customer.get("name")}));
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            tquery.setParameter("workcity", (Object)"Burlington");
            List clist = tquery.getResultList();
            String[] expectedPKs = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18"};
            if (!this.checkEntityPK(clist, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 18 references, got: " + clist.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("queryTest64 failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void queryTest65() throws EETest.Fault {
        boolean pass = false;
        String s1 = "4";
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            TestUtil.logTrace((String)"find MINIMUM order id for Robert E. Bissett");
            CriteriaQuery cquery = cbuilder.createQuery(String.class);
            Root order = cquery.from(com.sun.ts.tests.jpa.common.schema30.Order.class);
            cquery.where((Expression)cbuilder.equal((Expression)order.get("customer").get("name"), (Object)"Robert E. Bissett")).select((Selection)cbuilder.least((Expression)order.get("id")));
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            String s2 = (String)tquery.getSingleResult();
            if (s2.equals("4")) {
                TestUtil.logTrace((String)"Successfully returned expected results");
                pass = true;
            } else {
                TestUtil.logTrace((String)("queryTest65 returned " + s2 + "expected: 4"));
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("queryTest65 failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void queryTest66() throws EETest.Fault {
        boolean pass = false;
        Integer i1 = 8;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            TestUtil.logTrace((String)"find MAXIMUM number of lineItem quantities available an order may have");
            CriteriaQuery cquery = cbuilder.createQuery(Integer.class);
            Root l = cquery.from(LineItem.class);
            cquery.select((Selection)cbuilder.max((Expression)l.get("quantity")));
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            Integer i2 = (Integer)tquery.getSingleResult();
            if (i2.equals(i1)) {
                TestUtil.logTrace((String)"Successfully returned expected results");
                pass = true;
            } else {
                TestUtil.logTrace((String)("queryTest66 returned:" + i2 + "expected: " + i1));
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("queryTest66 failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void queryTest67() throws EETest.Fault {
        boolean pass = false;
        Double d1 = 1487.29;
        Double d2 = 1487.3;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            TestUtil.logTrace((String)"find AVERAGE price of all orders");
            CriteriaQuery cquery = cbuilder.createQuery(Double.class);
            Root order = cquery.from(com.sun.ts.tests.jpa.common.schema30.Order.class);
            cquery.select((Selection)cbuilder.avg((Expression)order.get("totalPrice")));
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            Double d3 = (Double)tquery.getSingleResult();
            if (d3 >= d1 && d3 < d2) {
                TestUtil.logTrace((String)("queryTest67 returned expected results: " + d1));
                pass = true;
            } else {
                TestUtil.logTrace((String)("queryTest67 returned " + d3 + "expected: " + d1));
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("queryTest67 failed");
        }
    }

    @SetupMethod(name="setupProductData")
    public void queryTest68() throws EETest.Fault {
        boolean pass = false;
        Double d1 = 33387.14;
        Double d2 = 33387.15;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            TestUtil.logTrace((String)"find SUM of all product prices");
            CriteriaQuery cquery = cbuilder.createQuery(Double.class);
            Root product = cquery.from(Product.class);
            cquery.select((Selection)cbuilder.sum((Expression)product.get("price")));
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            Double d3 = (Double)tquery.getSingleResult();
            if (d3 >= d1 && d3 < d2) {
                TestUtil.logTrace((String)("queryTest68 returned expected results: " + d1));
                pass = true;
            } else {
                TestUtil.logTrace((String)("queryTest68 returned " + d3 + "expected: " + d1));
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("queryTest68 failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void queryTest69() throws EETest.Fault {
        boolean pass1 = false;
        boolean pass2 = false;
        Long expectedResult1 = 17L;
        Long expectedResult2 = 16L;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            CriteriaQuery cquery1 = cbuilder.createQuery(Long.class);
            Root customer1 = cquery1.from(Customer.class);
            cquery1.select((Selection)cbuilder.count((Expression)customer1.get("home").get("city")));
            TypedQuery tquery1 = this.getEntityManager().createQuery(cquery1);
            Long result1 = (Long)tquery1.getSingleResult();
            if (!result1.equals(expectedResult1)) {
                TestUtil.logErr((String)("Query1 in queryTest69 returned:" + result1 + " expected: " + expectedResult1));
            } else {
                TestUtil.logTrace((String)"pass:  Query1 in queryTest69 returned expected results");
                pass1 = true;
            }
            CriteriaQuery cquery2 = cbuilder.createQuery(Long.class);
            Root customer2 = cquery2.from(Customer.class);
            cquery2.select((Selection)cbuilder.countDistinct((Expression)customer2.get("home").get("city")));
            TypedQuery tquery2 = this.getEntityManager().createQuery(cquery2);
            Long result2 = (Long)tquery2.getSingleResult();
            if (!result2.equals(expectedResult2)) {
                TestUtil.logErr((String)("Query 2 in queryTest69 returned:" + result2 + " expected: " + expectedResult2));
            } else {
                TestUtil.logTrace((String)"pass:  Query 2 in queryTest69 returned expected results");
                pass2 = true;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass1 || !pass2) {
            throw new EETest.Fault("queryTest69 failed");
        }
    }

    @SetupMethod(name="setupProductData")
    public void queryTest70() throws EETest.Fault {
        boolean pass = false;
        Integer expectedValue = 3277;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            TestUtil.logTrace((String)"find SUM of all product prices");
            CriteriaQuery cquery = cbuilder.createQuery(Integer.class);
            Root product = cquery.from(Product.class);
            cquery.select((Selection)cbuilder.sum((Expression)product.get("quantity")));
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            Integer result = (Integer)tquery.getSingleResult();
            if (expectedValue.equals(result)) {
                TestUtil.logTrace((String)("queryTest70 returned expected results: " + result));
                pass = true;
            } else {
                TestUtil.logTrace((String)("queryTest70 returned " + result + "expected: " + expectedValue));
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("queryTest70 failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void queryTest71() throws EETest.Fault {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"Check if a spouse is related to a customer");
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root spouse = cquery.from(Spouse.class);
            cquery.where((Expression)cbuilder.equal((Expression)spouse.get("id"), (Object)"7")).select((Selection)spouse.get("customer"));
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            tquery.getSingleResult();
            this.getEntityTransaction().commit();
        }
        catch (NoResultException e) {
            TestUtil.logTrace((String)("queryTest71: NoResultException caught as expected : " + e));
            pass = true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("queryTest71 failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void test_leftouterjoin_1xM() throws EETest.Fault {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            customer.join("creditCards", JoinType.LEFT);
            cquery.where((Expression)cbuilder.like((Expression)customer.get("name"), "%Caruso")).select((Selection)customer).distinct(true);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List clist = tquery.getResultList();
            String[] expectedPKs = new String[]{"7", "8"};
            if (!this.checkEntityPK(clist, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 2 references, got: " + clist.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("test_leftouterjoin_1xM failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void test_leftouterjoin_Mx1() throws EETest.Fault {
        boolean pass1 = false;
        boolean pass2 = true;
        Object[][] expectedResultSet = new Object[][]{{"15", "14"}, {"16", "14"}};
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createTupleQuery();
            Root order = cquery.from(com.sun.ts.tests.jpa.common.schema30.Order.class);
            Join c = order.join("customer", JoinType.LEFT);
            cquery.where((Expression)cbuilder.equal((Expression)c.get("name"), (Expression)cbuilder.parameter(String.class, "one")));
            cquery.multiselect(new Selection[]{order.get("id"), c.get("id")});
            cquery.orderBy(new Order[]{cbuilder.asc((Expression)order.get("id"))});
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            tquery.setParameter("one", (Object)"Kellie A. Sanborn");
            List q = tquery.getResultList();
            if (q.size() != 2) {
                TestUtil.logTrace((String)("test_leftouterjoin_Mx1:  Did not get expected results. Expected 2,  got: " + q.size()));
            } else {
                pass1 = true;
                TestUtil.logTrace((String)"Expected size received, verify contents . . . ");
                for (int i = 0; i < q.size(); ++i) {
                    Object obj = q.get(i);
                    Object[] orderAndCustomerExpected = expectedResultSet[i];
                    Tuple orderAndCustomerTuple = null;
                    Object[] orderAndCustomer = null;
                    if (obj instanceof Tuple) {
                        TestUtil.logTrace((String)"The element in the result list is of type Object[], continue . . .");
                        orderAndCustomerTuple = (Tuple)obj;
                        orderAndCustomer = orderAndCustomerTuple.toArray();
                        if (Arrays.equals(orderAndCustomerExpected, orderAndCustomer)) continue;
                        TestUtil.logErr((String)("Expecting element value: " + Arrays.asList(orderAndCustomerExpected) + ", actual element value: " + Arrays.asList(orderAndCustomer)));
                        pass2 = false;
                        break;
                    }
                    TestUtil.logErr((String)("The element in the result list is not of type Object[]:" + obj));
                    break;
                }
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass1 || !pass2) {
            throw new EETest.Fault("test_leftouterjoin_Mx1 failed");
        }
    }

    @SetupMethod(name="setupAliasData")
    public void test_leftouterjoin_MxM() throws EETest.Fault {
        boolean pass1 = false;
        boolean pass2 = true;
        Object[][] expectedResultSet = new Object[][]{{"7", "sjc"}, {"5", "ssd"}, {"7", "stevec"}, {"5", "steved"}, {"5", "stevie"}, {"7", "stevie"}};
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createTupleQuery();
            Root customer = cquery.from(Customer.class);
            Join a = customer.join("aliases", JoinType.LEFT);
            cquery.where((Expression)cbuilder.like((Expression)customer.get("name"), "Ste%"));
            cquery.multiselect(new Selection[]{customer.get("id"), a.get("alias")}).orderBy(new Order[]{cbuilder.asc((Expression)a.get("alias")), cbuilder.asc((Expression)customer.get("id"))});
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List q = tquery.getResultList();
            if (q.size() != 6) {
                TestUtil.logTrace((String)("test_leftouterjoin_MxM:  Did not get expected results. Expected 6,  got: " + q.size()));
            } else {
                pass1 = true;
                TestUtil.logTrace((String)"Expected size received, verify contents . . . ");
                for (int i = 0; i < q.size(); ++i) {
                    Object obj = q.get(i);
                    Object[] customerAndAliasExpected = expectedResultSet[i];
                    Tuple customerAndAliasTuple = null;
                    Object[] customerAndAlias = null;
                    if (obj instanceof Tuple) {
                        TestUtil.logTrace((String)"The element in the result list is of type Object[], continue . . .");
                        customerAndAliasTuple = (Tuple)obj;
                        customerAndAlias = customerAndAliasTuple.toArray();
                        if (Arrays.equals(customerAndAliasExpected, customerAndAlias)) continue;
                        TestUtil.logErr((String)("Expecting element value: " + Arrays.asList(customerAndAliasExpected) + ", actual element value: " + Arrays.asList(customerAndAlias)));
                        pass2 = false;
                        break;
                    }
                    TestUtil.logErr((String)("The element in the result list is not of type Object[]:" + obj));
                    break;
                }
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass1 || !pass2) {
            throw new EETest.Fault("test_leftouterjoin_MxM failed");
        }
    }

    @SetupMethod(name="setupAliasData")
    public void test_upperStringExpression() throws EETest.Fault {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            Join a = customer.join("aliases");
            cquery.where((Expression)cbuilder.equal(cbuilder.upper((Expression)a.get("alias")), (Object)"SJC"));
            cquery.select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List result = tquery.getResultList();
            String[] expectedPKs = new String[]{"7"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 1 references, got: " + result.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("test_upperStringExpression failed");
        }
    }

    @SetupMethod(name="setupAliasData")
    public void test_lowerStringExpression() throws EETest.Fault {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            Join a = customer.join("aliases");
            cquery.where((Expression)cbuilder.equal(cbuilder.lower((Expression)a.get("alias")), (Object)"sjc")).select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List result = tquery.getResultList();
            String[] expectedPKs = new String[]{"7"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 1 references, got: " + result.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("test_lowerStringExpression failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void test_groupBy() throws EETest.Fault {
        boolean pass = false;
        Object[] expectedCodes = new String[]{"CHA", "GBR", "IRE", "JPN", "USA"};
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(String.class);
            Root customer = cquery.from(Customer.class);
            cquery.select((Selection)customer.get("country").get("code"));
            cquery.groupBy(new Expression[]{customer.get("country").get("code")});
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List result = tquery.getResultList();
            Object[] output = result.toArray(new String[result.size()]);
            Arrays.sort(output);
            pass = Arrays.equals(expectedCodes, output);
            if (!pass) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 4 Country Codes: CHA, GBR, JPN, USA. Received: " + result.size()));
                for (String s : result) {
                    TestUtil.logErr((String)(" Credit Card Type: " + s));
                }
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("test_groupBy failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void test_groupBy_1() throws EETest.Fault {
        boolean pass = false;
        Object[] expectedTypes = new String[]{"AXP", "MCARD", "VISA"};
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(String.class);
            Root cc = cquery.from(CreditCard.class);
            cquery.select((Selection)cc.get("type")).groupBy(new Expression[]{cc.get("type")});
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List result = tquery.getResultList();
            Object[] output = result.toArray(new String[result.size()]);
            Arrays.sort(output);
            pass = Arrays.equals(expectedTypes, output);
            if (!pass) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 3 Credit Card Types: AXP, MCARD, VISA. Received: " + result.size()));
                for (String s : result) {
                    TestUtil.logErr((String)(" Credit Card Type: " + s));
                }
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("test_groupBy_1 failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void test_innerjoin_1x1() throws EETest.Fault {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            customer.join("spouse");
            cquery.select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List result = tquery.getResultList();
            String[] expectedPKs = new String[]{"7", "10", "11", "12", "13"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 5 references, got: " + result.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("test_innerjoin_1x1 failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void test_innerjoin_1xM() throws EETest.Fault {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            Join cc = customer.join("creditCards");
            cquery.where((Expression)cbuilder.equal((Expression)cc.get("type"), (Object)"VISA")).select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List result = tquery.getResultList();
            String[] expectedPKs = new String[]{"1", "2", "3", "6", "7", "10", "14", "17"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 8 references, got: " + result.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("test_innerjoin_1xM failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void test_innerjoin_Mx1() throws EETest.Fault {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(com.sun.ts.tests.jpa.common.schema30.Order.class);
            Root order = cquery.from(com.sun.ts.tests.jpa.common.schema30.Order.class);
            Join c = order.join("customer");
            cquery.where((Expression)cbuilder.equal((Expression)c.get("name"), (Expression)cbuilder.parameter(String.class, "one")));
            cquery.select((Selection)order);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            tquery.setParameter("one", (Object)"Kellie A. Sanborn");
            List result = tquery.getResultList();
            String[] expectedPKs = new String[]{"15", "16"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 2 references, got: " + result.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("test_innerjoin_Mx1 failed");
        }
    }

    @SetupMethod(name="setupAliasData")
    public void test_innerjoin_MxM() throws EETest.Fault {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            Join a = customer.join("aliases");
            cquery.where((Expression)cbuilder.equal((Expression)a.get("alias"), (Expression)cbuilder.parameter(String.class, "aName")));
            cquery.select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            tquery.setParameter("aName", (Object)"fish");
            List result = tquery.getResultList();
            String[] expectedPKs = new String[]{"1", "2"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 2 references, got: " + result.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("test_innerjoin_MxM failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void test_fetchjoin_1x1() throws EETest.Fault {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            customer.fetch("spouse");
            cquery.select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List result = tquery.getResultList();
            String[] expectedPKs = new String[]{"7", "10", "11", "12", "13"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results. Expected 5 references, got: " + result.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("test_fetchjoin_1x1 failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void test_fetchjoin_1xM() throws EETest.Fault {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            cquery.where((Expression)customer.get("home").get("state").in(new Object[]{"NY", "RI"}));
            cquery.select((Selection)customer).distinct(true);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List result = tquery.getResultList();
            String[] expectedPKs = new String[]{"14", "17"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 2 references, got: " + result.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("test_fetchjoin_1xM failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void test_fetchjoin_Mx1() throws EETest.Fault {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(com.sun.ts.tests.jpa.common.schema30.Order.class);
            Root order = cquery.from(com.sun.ts.tests.jpa.common.schema30.Order.class);
            cquery.where((Expression)cbuilder.equal((Expression)order.get("customer").get("home").get("city"), (Object)"Lawrence")).select((Selection)order);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List result = tquery.getResultList();
            String[] expectedPKs = new String[]{"15", "16"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 8 references, got: " + result.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("test_fetchjoin_Mx1 failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void test_fetchjoin_Mx1_1() throws EETest.Fault {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(com.sun.ts.tests.jpa.common.schema30.Order.class);
            Root order = cquery.from(com.sun.ts.tests.jpa.common.schema30.Order.class);
            cquery.where((Expression)cbuilder.like((Expression)order.get("customer").get("name"), "%Caruso")).select((Selection)order);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List result = tquery.getResultList();
            String[] expectedPKs = new String[]{"7", "8"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 2 references, got: " + result.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("test_fetchjoin_Mx1_1 failed");
        }
    }

    @SetupMethod(name="setupAliasData")
    public void test_fetchjoin_MxM() throws EETest.Fault {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"FETCHJOIN-MXM Executing Query");
            CriteriaQuery cquery = cbuilder.createQuery(Alias.class);
            Root alias = cquery.from(Alias.class);
            cquery.where((Expression)cbuilder.like((Expression)alias.get("alias"), "a%")).select((Selection)alias);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List result = tquery.getResultList();
            String[] expectedPKs = new String[]{"1", "2", "5", "6"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 4 references, got: " + result.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("test_fetchjoin_MxM failed");
        }
    }

    @SetupMethod(name="setupProductData")
    public void test_betweenDates() throws EETest.Fault {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            Date date1 = this.getSQLDate(2000, 2, 14);
            Date date6 = this.getSQLDate(2005, 2, 18);
            TestUtil.logTrace((String)("The dates used in test_betweenDates is : " + date1 + " and " + date6));
            CriteriaQuery cquery = cbuilder.createQuery(Product.class);
            Root product = cquery.from(Product.class);
            cquery.where((Expression)cbuilder.between((Expression)product.get("shelfLife").get("soldDate"), (Expression)cbuilder.parameter(Date.class, "date1"), (Expression)cbuilder.parameter(Date.class, "date6")));
            cquery.select((Selection)product);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            tquery.setParameter("date1", (Object)date1);
            tquery.setParameter("date6", (Object)date6);
            List result = tquery.getResultList();
            String[] expectedPKs = new String[]{"31", "32", "33", "37"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 3 references, got: " + result.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("test_betweenDates failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void test_notBetweenArithmetic() throws EETest.Fault {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(com.sun.ts.tests.jpa.common.schema30.Order.class);
            Root order = cquery.from(com.sun.ts.tests.jpa.common.schema30.Order.class);
            cquery.where((Expression)cbuilder.not((Expression)cbuilder.between((Expression)order.get("totalPrice"), (Comparable)Double.valueOf(1000.0), (Comparable)Double.valueOf(1200.0))));
            cquery.select((Selection)order);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List result = tquery.getResultList();
            String[] expectedPKs = new String[]{"2", "4", "5", "6", "9", "10", "11", "12", "13", "15", "16", "17", "18", "19", "20"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 15 references, got: " + result.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("test_notBetweenArithmetic failed");
        }
    }

    @SetupMethod(name="setupProductData")
    public void test_notBetweenDates() throws EETest.Fault {
        boolean pass = false;
        Date date1 = this.getSQLDate("2000-02-14");
        Date newdate = this.getSQLDate("2005-02-17");
        TestUtil.logTrace((String)("The dates used in test_betweenDates is : " + date1 + " and " + newdate));
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Product.class);
            Root product = cquery.from(Product.class);
            cquery.where((Expression)cbuilder.not((Expression)cbuilder.between((Expression)product.get("shelfLife").get("soldDate"), (Expression)cbuilder.parameter(Date.class, "date1"), (Expression)cbuilder.parameter(Date.class, "newdate"))));
            cquery.select((Selection)product);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            tquery.setParameter("date1", (Object)date1);
            tquery.setParameter("newdate", (Object)newdate);
            List result = tquery.getResultList();
            String[] expectedPKs = new String[]{"31"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 1 references, got: " + result.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("test_notBetweenDates failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void test_ANDconditionTT() throws EETest.Fault {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(com.sun.ts.tests.jpa.common.schema30.Order.class);
            Root order = cquery.from(com.sun.ts.tests.jpa.common.schema30.Order.class);
            cquery.where((Expression)cbuilder.and((Expression)cbuilder.equal((Expression)order.get("customer").get("name"), (Object)"Karen R. Tegan"), (Expression)cbuilder.gt((Expression)order.get("totalPrice"), (Number)500)));
            cquery.select((Selection)order);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List result = tquery.getResultList();
            String[] expectedPKs = new String[]{"6"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 1 reference, got: " + result.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("test_ANDconditionTT failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void test_ANDconditionTF() throws EETest.Fault {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(com.sun.ts.tests.jpa.common.schema30.Order.class);
            Root order = cquery.from(com.sun.ts.tests.jpa.common.schema30.Order.class);
            cquery.where((Expression)cbuilder.and((Expression)cbuilder.equal((Expression)order.get("customer").get("name"), (Object)"Karen R. Tegan"), (Expression)cbuilder.gt((Expression)order.get("totalPrice"), (Number)10000)));
            cquery.select((Selection)order);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List result = tquery.getResultList();
            if (result.size() == 0) {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            } else {
                TestUtil.logErr((String)("Did not get expected results.  Expected 0 references, got: " + result.size()));
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("test_ANDconditionTF failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void test_ANDconditionFT() throws EETest.Fault {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(com.sun.ts.tests.jpa.common.schema30.Order.class);
            Root order = cquery.from(com.sun.ts.tests.jpa.common.schema30.Order.class);
            cquery.where(new Predicate[]{cbuilder.equal((Expression)order.get("customer").get("id"), (Object)"1001"), cbuilder.lt((Expression)order.get("totalPrice"), (Number)1000)}).select((Selection)order);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List result = tquery.getResultList();
            if (result.size() == 0) {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            } else {
                TestUtil.logErr((String)("Did not get expected results.  Expected 0 references, got: " + result.size()));
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("test_ANDconditionFT failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void test_ANDconditionFF() throws EETest.Fault {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(com.sun.ts.tests.jpa.common.schema30.Order.class);
            Root order = cquery.from(com.sun.ts.tests.jpa.common.schema30.Order.class);
            cquery.where((Expression)cbuilder.and((Expression)cbuilder.equal((Expression)order.get("customer").get("id"), (Object)"1001"), (Expression)cbuilder.gt((Expression)order.get("totalPrice"), (Number)10000))).select((Selection)order);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List result = tquery.getResultList();
            if (result.size() == 0) {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            } else {
                TestUtil.logErr((String)("Did not get expected results.  Expected 0 references, got: " + result.size()));
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("test_ANDconditionFF failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void test_ORconditionTT() throws EETest.Fault {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(com.sun.ts.tests.jpa.common.schema30.Order.class);
            Root order = cquery.from(com.sun.ts.tests.jpa.common.schema30.Order.class);
            cquery.where((Expression)cbuilder.or((Expression)cbuilder.equal((Expression)order.get("customer").get("name"), (Object)"Karen R. Tegan"), (Expression)cbuilder.gt((Expression)order.get("totalPrice"), (Number)5000))).select((Selection)order);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List result = tquery.getResultList();
            String[] expectedPKs = new String[]{"6", "11", "16"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 3 references, got: " + result.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("test_ORconditionTT failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void test_ORconditionTF() throws EETest.Fault {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(com.sun.ts.tests.jpa.common.schema30.Order.class);
            Root order = cquery.from(com.sun.ts.tests.jpa.common.schema30.Order.class);
            cquery.where((Expression)cbuilder.or((Expression)cbuilder.equal((Expression)order.get("customer").get("name"), (Object)"Karen R. Tegan"), (Expression)cbuilder.gt((Expression)order.get("totalPrice"), (Number)10000))).select((Selection)order);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List result = tquery.getResultList();
            String[] expectedPKs = new String[]{"6"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 1 references, got: " + result.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("test_ORconditionTF failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void test_ORconditionFT() throws EETest.Fault {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(com.sun.ts.tests.jpa.common.schema30.Order.class);
            Root order = cquery.from(com.sun.ts.tests.jpa.common.schema30.Order.class);
            cquery.where((Expression)cbuilder.or((Expression)cbuilder.equal((Expression)order.get("customer").get("id"), (Object)"1001"), (Expression)cbuilder.lt((Expression)order.get("totalPrice"), (Number)1000))).select((Selection)order);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List result = tquery.getResultList();
            String[] expectedPKs = new String[]{"9", "10", "12", "13", "15", "19", "20"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 7 references, got: " + result.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("test_ORconditionFT failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void test_ORconditionFF() throws EETest.Fault {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(com.sun.ts.tests.jpa.common.schema30.Order.class);
            Root order = cquery.from(com.sun.ts.tests.jpa.common.schema30.Order.class);
            cquery.where((Expression)cbuilder.or((Expression)cbuilder.equal((Expression)order.get("customer").get("id"), (Object)"1001"), (Expression)cbuilder.gt((Expression)order.get("totalPrice"), (Number)10000))).select((Selection)order);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List result = tquery.getResultList();
            if (result.size() == 0) {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            } else {
                TestUtil.logErr((String)("Did not get expected results.  Expected 0 references, got: " + result.size()));
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("test_ORconditionFF failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void test_groupByWhereClause() throws EETest.Fault {
        boolean pass = false;
        Object[] expectedCusts = new String[]{"Jonathan K. Smith", "Kellie A. Sanborn", "Robert E. Bissett"};
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(String.class);
            Root customer = cquery.from(Customer.class);
            Join o = customer.join("orders");
            cquery.where((Expression)cbuilder.between((Expression)o.get("totalPrice"), (Comparable)Double.valueOf(90.0), (Comparable)Double.valueOf(160.0))).groupBy(new Expression[]{customer.get("name")}).select((Selection)customer.get("name"));
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List result = tquery.getResultList();
            Object[] output = result.toArray(new String[result.size()]);
            Arrays.sort(output);
            pass = Arrays.equals(expectedCusts, output);
            if (!pass) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 3 Customers : Jonathan K. Smith, Kellie A. Sanborn and Robert E. Bissett. Received: " + result.size()));
                for (String s : result) {
                    TestUtil.logTrace((String)(" Customer: " + s));
                }
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("test_groupByWhereClause failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void test_groupByHaving() throws EETest.Fault {
        boolean pass = false;
        Long expectedGBR = 2L;
        Long expectedCHA = 4L;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Long.class);
            Root customer = cquery.from(Customer.class);
            cquery.groupBy(new Expression[]{customer.get("country").get("code")}).having((Expression)customer.get("country").get("code").in(new Object[]{"GBR", "CHA"})).select((Selection)cbuilder.count((Expression)customer));
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List result = tquery.getResultList();
            int numOfExpected = 0;
            TestUtil.logTrace((String)"Check result received . . . ");
            for (Long l : result) {
                if (!l.equals(expectedGBR) && !l.equals(expectedCHA)) continue;
                ++numOfExpected;
            }
            if (numOfExpected != 2) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 2 Values returned : 2 with Country Code GBR and 4 with Country Code CHA. Received: " + result.size()));
                for (Long l : result) {
                    TestUtil.logTrace((String)("count of Codes Returned: " + l));
                }
            } else {
                TestUtil.logTrace((String)"Expected results received.");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("test_groupByHaving failed");
        }
    }

    @SetupMethod(name="setupAliasData")
    public void test_substringHavingClause() throws EETest.Fault {
        boolean pass = false;
        Long expectedCount = 2L;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"Executing Query");
            CriteriaQuery cquery = cbuilder.createQuery(Long.class);
            Root customer = cquery.from(Customer.class);
            Join a = customer.join("aliases");
            cquery.select((Selection)cbuilder.count((Expression)customer)).groupBy(new Expression[]{a.get("alias")}).having((Expression)cbuilder.equal((Expression)a.get("alias"), cbuilder.substring((Expression)cbuilder.parameter(String.class, "string1"), (Expression)cbuilder.parameter(Integer.class, "int1"), (Expression)cbuilder.parameter(Integer.class, "int2"))));
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            tquery.setParameter("string1", (Object)"fish");
            tquery.setParameter("int1", (Object)1);
            tquery.setParameter("int2", (Object)4);
            Long result = (Long)tquery.getSingleResult();
            TestUtil.logTrace((String)"Check results received .  .  .");
            if (expectedCount.equals(result)) {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            } else {
                TestUtil.logErr((String)("Did not get expected results. Expected Count of 2, got: " + result));
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault(" test_substringHavingClause failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void test_concatHavingClause() throws EETest.Fault {
        boolean pass = false;
        String expectedCustomer = "Margaret Mills";
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(String.class);
            Root customer = cquery.from(Customer.class);
            cquery.select((Selection)customer.get("name")).groupBy(new Expression[]{customer.get("name")}).having((Expression)cbuilder.equal((Expression)customer.get("name"), cbuilder.concat("Margaret ", (Expression)cbuilder.parameter(String.class, "lname"))));
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            tquery.setParameter("lname", (Object)"Mills");
            String result = (String)tquery.getSingleResult();
            if (result.equals("Margaret Mills")) {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            } else {
                TestUtil.logTrace((String)("test_concatHavingClause:  Did not get expected results. Expected: Margaret Mills, got: " + result));
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("test_concatHavingClause failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void test_lowerHavingClause() throws EETest.Fault {
        boolean pass = false;
        Long expectedCount = 2L;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Long.class);
            Root customer = cquery.from(Customer.class);
            cquery.select((Selection)cbuilder.count((Expression)customer.get("country").get("code"))).groupBy(new Expression[]{customer.get("country").get("code")}).having((Expression)cbuilder.equal(cbuilder.lower((Expression)customer.get("country").get("code")), (Object)"gbr"));
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List result = tquery.getResultList();
            for (Long l : result) {
                if (l.equals(expectedCount)) {
                    pass = true;
                    TestUtil.logTrace((String)"Expected results received");
                    pass = true;
                    continue;
                }
                TestUtil.logErr((String)("Did not get expected results. Expected 2 references, got: " + result.size()));
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault(" test_lowerHavingClause failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void test_upperHavingClause() throws EETest.Fault {
        boolean pass = false;
        Long expectedCount = 2L;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Long.class);
            Root customer = cquery.from(Customer.class);
            cquery.select((Selection)cbuilder.count((Expression)customer.get("country").get("country"))).groupBy(new Expression[]{customer.get("country").get("country")}).having((Expression)cbuilder.equal(cbuilder.upper((Expression)customer.get("country").get("country")), (Object)"ENGLAND"));
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List result = tquery.getResultList();
            for (Long l : result) {
                if (l.equals(expectedCount)) {
                    pass = true;
                    TestUtil.logTrace((String)"Expected results received");
                    pass = true;
                    continue;
                }
                TestUtil.logErr((String)("Did not get expected results. Expected 2 references, got: " + result.size()));
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("test_upperHavingClause failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void test_lengthHavingClause() throws EETest.Fault {
        boolean pass = false;
        Object[] expectedCities = new String[]{"Burlington", "Chelmsford", "Roslindale"};
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(String.class);
            Root customer = cquery.from(Customer.class);
            Join a = customer.join("home");
            cquery.groupBy(new Expression[]{a.get("city")}).having((Expression)cbuilder.equal(cbuilder.length((Expression)a.get("city")), (Object)10)).select((Selection)a.get("city"));
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List result = tquery.getResultList();
            Object[] output = result.toArray(new String[result.size()]);
            Arrays.sort(output);
            pass = Arrays.equals(expectedCities, output);
            if (!pass) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 2 Cities, got: " + result.size()));
                for (Object s : expectedCities) {
                    TestUtil.logErr((String)("Expected:" + (String)s));
                }
                for (Object s : output) {
                    TestUtil.logErr((String)("Actual:" + (String)s));
                }
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("test_lengthHavingClause failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void test_locateHavingClause() throws EETest.Fault {
        boolean pass = false;
        Object[] expectedCusts = new String[]{"Alan E. Frechette", "Arthur D. Frechette"};
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(String.class);
            Root customer = cquery.from(Customer.class);
            cquery.groupBy(new Expression[]{customer.get("name")}).having((Expression)cbuilder.gt(cbuilder.locate((Expression)customer.get("name"), "Frechette"), (Number)0)).select((Selection)customer.get("name"));
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List result = tquery.getResultList();
            Object[] output = result.toArray(new String[result.size()]);
            Arrays.sort(output);
            pass = Arrays.equals(expectedCusts, output);
            if (!pass) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 2 Customers, got: " + result.size()));
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault(" test_locateHavingClause failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void test_ABSHavingClause() throws EETest.Fault {
        boolean pass = false;
        Double expectedPrice = 10191.9;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Double.class);
            Root order = cquery.from(com.sun.ts.tests.jpa.common.schema30.Order.class);
            cquery.select((Selection)cbuilder.sum((Expression)order.get("totalPrice"))).groupBy(new Expression[]{order.get("totalPrice")}).having((Expression)cbuilder.equal(cbuilder.abs((Expression)order.get("totalPrice")), (Expression)cbuilder.parameter(Double.class, "doubleValue")));
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            tquery.setParameter("doubleValue", (Object)5095.95);
            Double result = (Double)tquery.getSingleResult();
            if (expectedPrice.equals(result)) {
                pass = true;
                TestUtil.logTrace((String)"Expected results received");
            } else {
                TestUtil.logErr((String)("test_ABSHavingClause:  Did not get expected results.Expected:" + expectedPrice + ", got: " + result));
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("test_ABSHavingClause failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void test_SQRTWhereClause() throws EETest.Fault {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"SQRT: Executing Query");
            CriteriaQuery cquery = cbuilder.createQuery(com.sun.ts.tests.jpa.common.schema30.Order.class);
            Root order = cquery.from(com.sun.ts.tests.jpa.common.schema30.Order.class);
            cquery.where((Expression)cbuilder.gt(cbuilder.sqrt((Expression)order.get("totalPrice")), (Expression)cbuilder.parameter(Double.class, "doubleValue"))).select((Selection)order);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            tquery.setParameter("doubleValue", (Object)70.0);
            List result = tquery.getResultList();
            String[] expectedPKs = new String[]{"11", "16"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                TestUtil.logErr((String)("test_SQRTWhereClause:  Did not get expected results.  Expected 2 references, got: " + result.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault(" test_SQRTWhereClause failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void test_subquery_exists_01() throws EETest.Fault {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            cquery.select((Selection)customer);
            Subquery sq = cquery.subquery(com.sun.ts.tests.jpa.common.schema30.Order.class);
            Root sqc = sq.correlate(customer);
            Join sqo = sqc.join("orders");
            sq.select((Expression)sqo);
            cquery.where((Expression)cbuilder.not((Expression)cbuilder.exists(sq)));
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List result = tquery.getResultList();
            String[] expectedPKs = new String[]{"19", "20"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                TestUtil.logErr((String)("test_subquery_exists_01:  Did not get expected results.  Expected 2 references, got: " + result.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault(" test_subquery_exists_01 failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void test_subquery_exists_02() throws EETest.Fault {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            cquery.select((Selection)customer);
            Subquery sq = cquery.subquery(com.sun.ts.tests.jpa.common.schema30.Order.class);
            Root sqc = sq.correlate(customer);
            Join sqo = sqc.join("orders");
            sq.where((Expression)cbuilder.gt((Expression)sqo.get("totalPrice"), (Number)1500.0));
            cquery.where((Expression)cbuilder.exists(sq));
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List result = tquery.getResultList();
            String[] expectedPKs = new String[]{"5", "10", "14", "15"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                TestUtil.logErr((String)("test_subquery_exists_02:  Did not get expected results.  Expected 4 references, got: " + result.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault(" test_subquery_exists_02 failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void test_subquery_like() throws EETest.Fault {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(com.sun.ts.tests.jpa.common.schema30.Order.class);
            Root order = cquery.from(com.sun.ts.tests.jpa.common.schema30.Order.class);
            cquery.select((Selection)order);
            Subquery sq = cquery.subquery(Customer.class);
            Root sqo = sq.correlate(order);
            Join sqc = sqo.join("customer");
            sq.where((Expression)cbuilder.like((Expression)sqc.get("name"), "%Caruso")).select((Expression)sqc);
            cquery.where((Expression)cbuilder.exists(sq));
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List result = tquery.getResultList();
            String[] expectedPKs = new String[]{"7", "8"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                TestUtil.logErr((String)("test_subquery_like:  Did not get expected  results.  Expected 2 references, got: " + result.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault(" test_subquery_like failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void test_subquery_in() throws EETest.Fault {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            cquery.select((Selection)customer);
            Subquery sq = cquery.subquery(String.class);
            boolean isCorr = customer.isCorrelated();
            if (!isCorr) {
                TestUtil.logTrace((String)"Root.isCorrelated() return false");
            } else {
                TestUtil.logErr((String)("Expected Root.isCorrelated() to return false, actual:" + isCorr));
            }
            Root sqc = sq.correlate(customer);
            isCorr = sqc.isCorrelated();
            if (isCorr) {
                TestUtil.logTrace((String)"Root.isCorrelated() return true");
            } else {
                TestUtil.logErr((String)("Expected Root.isCorrelated() to return true, actual:" + isCorr));
            }
            From f = sqc.getCorrelationParent();
            String name = f.getJavaType().getSimpleName();
            if (name.equals("Customer")) {
                TestUtil.logTrace((String)("Received expected parent:" + name));
            } else {
                TestUtil.logErr((String)("Expected getCorrelationParent() to return Customer, actual:" + name));
            }
            Join w = sqc.join("work");
            sq.select((Expression)w.get("state"));
            sq.where((Expression)cbuilder.equal((Expression)w.get("state"), (Expression)cbuilder.parameter(String.class, "state")));
            cquery.where((Expression)customer.get("home").get("state").in(new Expression[]{sq}));
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            tquery.setParameter("state", (Object)"MA");
            List result = tquery.getResultList();
            String[] expectedPKs = new String[]{"1", "2", "3", "4", "7", "8", "9", "11", "13", "15", "18"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                TestUtil.logErr((String)("test_subquery_in:  Did not get expected results.  Expected 11 references, got: " + result.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("test_subquery_in failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void fromIsCorrelatedTest() throws EETest.Fault {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            Root customer;
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root rCustomer = customer = cquery.from(Customer.class);
            boolean isCorr = rCustomer.isCorrelated();
            if (!isCorr) {
                TestUtil.logTrace((String)"isCorrelated() return false");
            } else {
                TestUtil.logErr((String)("Expected isCorrelated() to return false, actual:" + isCorr));
            }
            cquery.select((Selection)customer);
            Subquery sq = cquery.subquery(String.class);
            Root sqc = sq.correlate(customer);
            isCorr = sqc.isCorrelated();
            if (isCorr) {
                TestUtil.logTrace((String)"isCorrelated() return true");
            } else {
                TestUtil.logErr((String)("Expected isCorrelated() to return true, actual:" + isCorr));
            }
            Join w = sqc.join("work");
            sq.select((Expression)w.get("state"));
            sq.where((Expression)cbuilder.equal((Expression)w.get("state"), (Expression)cbuilder.parameter(String.class, "state")));
            cquery.where((Expression)customer.get("home").get("state").in(new Expression[]{sq}));
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            tquery.setParameter("state", (Object)"MA");
            List result = tquery.getResultList();
            String[] expectedPKs = new String[]{"1", "2", "3", "4", "7", "8", "9", "11", "13", "15", "18"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                TestUtil.logErr((String)("test_subquery_in:  Did not get expected results.  Expected 11 references, got: " + result.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("fromIsCorrelatedTest failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void test_subquery_between() throws EETest.Fault {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"Execute query for test_subquery_between");
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            Subquery sq = cquery.subquery(com.sun.ts.tests.jpa.common.schema30.Order.class);
            Root sqc = sq.correlate(customer);
            Join sqo = sqc.join("orders");
            sq.where((Expression)cbuilder.between((Expression)sqo.get("totalPrice"), (Comparable)Double.valueOf(1000.0), (Comparable)Double.valueOf(1200.0)));
            cquery.where((Expression)cbuilder.exists(sq));
            cquery.select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List result = tquery.getResultList();
            String[] expectedPKs = new String[]{"1", "3", "7", "8", "13"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                TestUtil.logErr((String)("test_subquery_between:  Did not get expected  results.  Expected 5 references, got: " + result.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault(" test_subquery_between failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void test_subquery_join() throws EETest.Fault {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            Join o = customer.join("orders");
            Subquery sq = cquery.subquery(com.sun.ts.tests.jpa.common.schema30.Order.class);
            Join sqo = sq.correlate(o);
            Join sql = sqo.join("lineItemsCollection");
            sq.where((Expression)cbuilder.gt((Expression)sql.get("quantity"), (Number)3)).select((Expression)sqo);
            cquery.select((Selection)customer);
            cquery.where((Expression)cbuilder.exists(sq));
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List result = tquery.getResultList();
            String[] expectedPKs = new String[]{"6", "9", "11", "13", "16"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                TestUtil.logErr((String)("test_subquery_join:  Did not get expected results.  Expected 5 references, got: " + result.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault(" test_subquery_join failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void test_subquery_ALL_GT() throws EETest.Fault {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            Join o = customer.join("orders");
            Subquery sq = cquery.subquery(Double.class);
            Root sqo = sq.from(com.sun.ts.tests.jpa.common.schema30.Order.class);
            Join l = sqo.join("lineItemsCollection");
            sq.where((Expression)cbuilder.gt((Expression)l.get("quantity"), (Number)3));
            sq.select((Expression)sqo.get("totalPrice"));
            cquery.select((Selection)customer);
            cquery.where((Expression)cbuilder.gt((Expression)o.get("totalPrice"), cbuilder.all(sq)));
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List result = tquery.getResultList();
            String[] expectedPKs = new String[]{"5", "10", "14", "15"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                TestUtil.logErr((String)("test_subquery_ALL_GT:  Did not get expected results.  Expected 4 references, got: " + result.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault(" test_subquery_ALL_GT failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void test_subquery_ALL_LT() throws EETest.Fault {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            Join o = customer.join("orders");
            cquery.select((Selection)customer);
            Subquery sq = cquery.subquery(Double.class);
            Root sqo = sq.from(com.sun.ts.tests.jpa.common.schema30.Order.class);
            Join sql = sqo.join("lineItemsCollection");
            sq.where((Expression)cbuilder.gt((Expression)sql.get("quantity"), (Number)3));
            sq.select((Expression)sqo.get("totalPrice"));
            cquery.where((Expression)cbuilder.lt((Expression)o.get("totalPrice"), cbuilder.all(sq)));
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List result = tquery.getResultList();
            String[] expectedPKs = new String[]{"12"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                TestUtil.logErr((String)("test_subquery_ALL_LT:  Did not get expected results.  Expected 1 reference, got: " + result.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("test_subquery_ALL_LT failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void test_subquery_ALL_EQ() throws EETest.Fault {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            Join o = customer.join("orders");
            cquery.select((Selection)customer);
            Subquery sq = cquery.subquery(Double.class);
            Root sqo = sq.from(com.sun.ts.tests.jpa.common.schema30.Order.class);
            sq.select(cbuilder.min((Expression)sqo.get("totalPrice")));
            cquery.where((Expression)cbuilder.equal((Expression)o.get("totalPrice"), cbuilder.all(sq)));
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List result = tquery.getResultList();
            String[] expectedPKs = new String[]{"12"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                TestUtil.logErr((String)("test_subquery_ALL_EQ:  Did not get expected results.  Expected 1 reference, got: " + result.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("test_subquery_ALL_EQ failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void test_subquery_ALL_LTEQ() throws EETest.Fault {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            Join o = customer.join("orders");
            Subquery sq = cquery.subquery(Double.class);
            Root sqo = sq.from(com.sun.ts.tests.jpa.common.schema30.Order.class);
            Join sql = sqo.join("lineItemsCollection");
            sq.select((Expression)sqo.get("totalPrice"));
            sq.where((Expression)cbuilder.gt((Expression)sql.get("quantity"), (Number)3));
            cquery.where((Expression)cbuilder.le((Expression)o.get("totalPrice"), cbuilder.all(sq))).select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List result = tquery.getResultList();
            String[] expectedPKs = new String[]{"9", "12"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                TestUtil.logErr((String)("test_subquery_ALL_LTEQ:  Did not get expected results.  Expected 2 references, got: " + result.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("test_subquery_ALL_LTEQ failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void test_subquery_ALL_GTEQ() throws EETest.Fault {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            Join o = customer.join("orders");
            Subquery sq = cquery.subquery(Double.class);
            Root sqo = sq.from(com.sun.ts.tests.jpa.common.schema30.Order.class);
            Join sql = sqo.join("lineItemsCollection");
            sq.select((Expression)sqo.get("totalPrice"));
            sq.where((Expression)cbuilder.ge((Expression)sql.get("quantity"), (Number)3));
            cquery.where((Expression)cbuilder.ge((Expression)o.get("totalPrice"), cbuilder.all(sq))).select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List result = tquery.getResultList();
            String[] expectedPKs = new String[]{"10", "14"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                TestUtil.logErr((String)("test_subquery_ALL_GTEQ:  Did not get expected results.  Expected 2 references, got: " + result.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("test_subquery_ALL_GTEQ failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void test_subquery_ALL_NOTEQ() throws EETest.Fault {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            Join o = customer.join("orders");
            Subquery sq = cquery.subquery(Double.class);
            Root sqo = sq.from(com.sun.ts.tests.jpa.common.schema30.Order.class);
            sq.select(cbuilder.min((Expression)sqo.get("totalPrice")));
            cquery.where((Expression)cbuilder.notEqual((Expression)o.get("totalPrice"), cbuilder.all(sq))).select((Selection)customer).distinct(true);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List result = tquery.getResultList();
            String[] expectedPKs = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "13", "14", "15", "16", "17", "18"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                TestUtil.logErr((String)("test_subquery_ALL_NOTEQ:  Did not get expected results.  Expected 17 references, got: " + result.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("test_subquery_ALL_NOTEQ failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void test_subquery_ANY_GT() throws EETest.Fault {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            Join o = customer.join("orders");
            Subquery sq = cquery.subquery(Double.class);
            Root sqo = sq.from(com.sun.ts.tests.jpa.common.schema30.Order.class);
            Join sql = sqo.join("lineItemsCollection");
            sq.select((Expression)sqo.get("totalPrice"));
            sq.where((Expression)cbuilder.equal((Expression)sql.get("quantity"), (Object)3));
            cquery.where((Expression)cbuilder.gt((Expression)o.get("totalPrice"), cbuilder.any(sq))).select((Selection)customer).distinct(true);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List result = tquery.getResultList();
            String[] expectedPKs = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "10", "11", "13", "14", "15", "16", "17", "18"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                TestUtil.logErr((String)("test_subquery_ANY_GT:  Did not get expected results.   Expected 16 references, got: " + result.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("test_subquery_ANY_GT failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void test_subquery_ANY_LT() throws EETest.Fault {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            Join o = customer.join("orders");
            Subquery sq = cquery.subquery(Double.class);
            Root sqo = sq.from(com.sun.ts.tests.jpa.common.schema30.Order.class);
            Join sql = sqo.join("lineItemsCollection");
            sq.select((Expression)sqo.get("totalPrice"));
            sq.where((Expression)cbuilder.equal((Expression)sql.get("quantity"), (Object)3));
            cquery.where((Expression)cbuilder.lt((Expression)o.get("totalPrice"), cbuilder.any(sq))).select((Selection)customer).distinct(true);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List result = tquery.getResultList();
            String[] expectedPKs = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "11", "12", "13", "14", "15", "16", "17", "18"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                TestUtil.logErr((String)("test_subquery_ANY_LT:  Did not get expected results.  Expected 17 references, got: " + result.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("test_subquery_ANY_LT failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void test_subquery_ANY_EQ() throws EETest.Fault {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            Join o = customer.join("orders");
            Subquery sq = cquery.subquery(Double.class);
            Root sqo = sq.from(com.sun.ts.tests.jpa.common.schema30.Order.class);
            sq.select(cbuilder.max((Expression)sqo.get("totalPrice")));
            cquery.where((Expression)cbuilder.equal((Expression)o.get("totalPrice"), cbuilder.any(sq))).select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List result = tquery.getResultList();
            String[] expectedPKs = new String[]{"10", "14"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                TestUtil.logErr((String)("test_subquery_ANY_EQ:  Did not get expected results.  Expected 2 references, got: " + result.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("test_subquery_ANY_EQ failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void test_subquery_SOME_LTEQ() throws EETest.Fault {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            Join o = customer.join("orders");
            Subquery sq = cquery.subquery(Double.class);
            Root sqo = sq.from(com.sun.ts.tests.jpa.common.schema30.Order.class);
            Join sql = sqo.join("lineItemsCollection");
            sq.select((Expression)sqo.get("totalPrice"));
            sq.where((Expression)cbuilder.equal((Expression)sql.get("quantity"), (Object)3));
            cquery.where((Expression)cbuilder.le((Expression)o.get("totalPrice"), cbuilder.some(sq))).select((Selection)customer).distinct(true);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List result = tquery.getResultList();
            String[] expectedPKs = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                TestUtil.logErr((String)("test_subquery_SOME_LTEQ:  Did not get expected results.  Expected 18 references, got: " + result.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault(" test_subquery_SOME_LTEQ failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void test_subquery_SOME_GTEQ() throws EETest.Fault {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            Join o = customer.join("orders");
            Subquery sq = cquery.subquery(Double.class);
            Root sqo = sq.from(com.sun.ts.tests.jpa.common.schema30.Order.class);
            Join sql = sqo.join("lineItemsCollection");
            sq.select((Expression)sqo.get("totalPrice"));
            sq.where((Expression)cbuilder.equal((Expression)sql.get("quantity"), (Object)3));
            cquery.where((Expression)cbuilder.ge((Expression)o.get("totalPrice"), cbuilder.some(sq))).select((Selection)customer).distinct(true);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List result = tquery.getResultList();
            String[] expectedPKs = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "13", "14", "15", "16", "17", "18"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                TestUtil.logErr((String)("test_subquery_SOME_GTEQ:  Did not get expected results.  Expected 17 references, got: " + result.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("test_subquery_SOME_GTEQ failed");
        }
    }

    public void joinTest() throws EETest.Fault {
        boolean pass1 = false;
        boolean pass2 = false;
        boolean pass3 = false;
        boolean pass4 = false;
        boolean pass5 = false;
        try {
            CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            TestUtil.logMsg((String)"Testing default getJoinType");
            JoinType jt = customer.join("aliases").getJoinType();
            if (jt.equals((Object)JoinType.INNER)) {
                TestUtil.logTrace((String)("Received expected:" + jt.name()));
                pass1 = true;
            } else {
                TestUtil.logErr((String)("Expected:" + JoinType.INNER.name() + ", actual:" + jt));
            }
            cquery = null;
            TestUtil.logMsg((String)"Testing INNER getJoinType");
            cquery = cbuilder.createQuery(Customer.class);
            customer = cquery.from(Customer.class);
            jt = customer.join("aliases", JoinType.INNER).getJoinType();
            if (jt.equals((Object)JoinType.INNER)) {
                TestUtil.logTrace((String)("Received expected:" + jt.name()));
                pass2 = true;
            } else {
                TestUtil.logErr((String)("Expected:" + JoinType.INNER.name() + ", actual:" + jt));
            }
            cquery = null;
            TestUtil.logMsg((String)"Testing LEFT getJoinType");
            cquery = cbuilder.createQuery(Customer.class);
            customer = cquery.from(Customer.class);
            jt = customer.join("aliases", JoinType.LEFT).getJoinType();
            if (jt.equals((Object)JoinType.LEFT)) {
                TestUtil.logTrace((String)("Received expected:" + jt.name()));
                pass3 = true;
            } else {
                TestUtil.logErr((String)("Expected:" + JoinType.LEFT.name() + ", actual:" + jt));
            }
            cquery = null;
            TestUtil.logMsg((String)"Testing INNER getAttribute");
            cquery = cbuilder.createQuery(Customer.class);
            customer = cquery.from(Customer.class);
            Attribute attr = customer.join("aliases").getAttribute();
            if (attr.getName().equals("aliases")) {
                TestUtil.logTrace((String)("Received expected:" + attr.getName()));
                pass4 = true;
            } else {
                TestUtil.logErr((String)("Expected:aliases, actual:" + attr.getName()));
            }
            cquery = null;
            TestUtil.logMsg((String)"Testing getParent");
            cquery = cbuilder.createQuery(Customer.class);
            customer = cquery.from(Customer.class);
            From from = customer.join("aliases").getParent();
            if (from.getClass().getName().equals(customer.getClass().getName())) {
                TestUtil.logTrace((String)("Received expected:" + from.getClass().getName()));
                pass5 = true;
            } else {
                TestUtil.logErr((String)("Expected:" + customer.getClass().getName() + ", actual:" + from.getClass().getName()));
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!(pass1 && pass2 && pass3 && pass4 && pass5)) {
            throw new EETest.Fault("joinTest failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void fetchStringTest() throws EETest.Fault {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            customer.fetch("spouse");
            cquery.select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List result = tquery.getResultList();
            String[] expectedPKs = new String[]{"7", "10", "11", "12", "13"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results. Expected 5 references, got: " + result.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("fetchStringTest failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void fetchStringJoinTypeTest() throws EETest.Fault {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            customer.fetch("spouse", JoinType.INNER);
            Set s = customer.getFetches();
            if (s.size() == 1) {
                TestUtil.logTrace((String)("Received expected size:" + s.size()));
                for (Fetch f : s) {
                    String name = f.getAttribute().getName();
                    if (name.equals("spouse")) {
                        TestUtil.logTrace((String)("Received expected attribute:" + name));
                    } else {
                        TestUtil.logErr((String)("Expected attribute: spouse, actual:" + name));
                    }
                    JoinType type = f.getJoinType();
                    if (type.equals((Object)JoinType.INNER)) {
                        TestUtil.logTrace((String)("Received expected JoinType:" + type));
                        continue;
                    }
                    TestUtil.logErr((String)("Expected JoinType:" + JoinType.INNER + ", actual:" + type));
                }
            } else {
                TestUtil.logErr((String)("Expected size: 1, actual:" + s.size()));
            }
            cquery.select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List result = tquery.getResultList();
            String[] expectedPKs = new String[]{"7", "10", "11", "12", "13"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results. Expected 5 references, got: " + result.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("fetchStringJoinTypeTest failed");
        }
    }

    public void fetchStringAndStringJoinTypeIllegalArgumentException() throws EETest.Fault {
        Root customer;
        CriteriaQuery cquery;
        boolean pass1 = false;
        boolean pass2 = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        TestUtil.logMsg((String)"Testing String");
        try {
            cquery = cbuilder.createQuery(Customer.class);
            customer = cquery.from(Customer.class);
            customer.fetch("doesnotexist");
            TestUtil.logErr((String)"did not throw IllegalArgumentException");
        }
        catch (IllegalArgumentException iae) {
            TestUtil.logTrace((String)"Received expected IllegalArgumentException");
            pass1 = true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        TestUtil.logMsg((String)"Testing String, JoinType");
        try {
            cquery = cbuilder.createQuery(Customer.class);
            customer = cquery.from(Customer.class);
            customer.fetch("doesnotexist", JoinType.INNER);
            TestUtil.logErr((String)"did not throw IllegalArgumentException");
        }
        catch (IllegalArgumentException iae) {
            TestUtil.logTrace((String)"Received expected IllegalArgumentException");
            pass2 = true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception:", (Throwable)e);
        }
        if (!pass1 || !pass2) {
            throw new EETest.Fault("fetchStringAndStringJoinTypeIllegalArgumentException failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void isNullOneToOneTest() throws EETest.Fault {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"find All Customers who have a null work zip code");
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            cquery.where((Expression)customer.get("home").isNull());
            cquery.select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List clist = tquery.getResultList();
            String[] expectedPKs = new String[]{"19", "20"};
            if (!this.checkEntityPK(clist, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 1 reference, got: " + clist.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("isNullOneToOneTest failed");
        }
    }
}

