/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jdbc.ee.callStmt.callStmt1;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.util.TSNamingContextInterface;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jdbc.ee.common.DataSourceConnection;
import com.sun.ts.tests.jdbc.ee.common.DriverManagerConnection;
import com.sun.ts.tests.jdbc.ee.common.JDBCTestMsg;
import com.sun.ts.tests.jdbc.ee.common.rsSchema;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.DataSource;

public class callStmtClient1
extends ServiceEETest
implements Serializable {
    private static final String testName = "jdbc.ee.callStmt.callStmt1";
    private TSNamingContextInterface jc = null;
    private transient Connection conn = null;
    private DataSource ds1 = null;
    private rsSchema rsSch = null;
    private JDBCTestMsg msg = null;
    private String drManager = null;
    private Properties sqlp = null;
    private CallableStatement cstmt = null;

    public static void main(String[] args) {
        callStmtClient1 theTests = new callStmtClient1();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        try {
            try {
                this.drManager = p.getProperty("DriverManager", "");
                if (this.drManager.length() == 0) {
                    throw new EETest.Fault("Invalid DriverManager Name");
                }
                this.sqlp = p;
                if (this.drManager.equals("yes")) {
                    this.logTrace("Using DriverManager");
                    DriverManagerConnection dmCon = new DriverManagerConnection();
                    this.conn = dmCon.getConnection(p);
                } else {
                    this.logTrace("Using DataSource");
                    DataSourceConnection dsCon = new DataSourceConnection();
                    this.conn = dsCon.getConnection(p);
                }
                this.rsSch = new rsSchema();
                this.msg = new JDBCTestMsg();
            }
            catch (SQLException ex) {
                this.logErr("SQL Exception : " + ex.getMessage(), ex);
            }
        }
        catch (Exception e) {
            this.logErr("Setup Failed!");
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetBigDecimal01() throws EETest.Fault {
        BigDecimal maxBigDecimalVal = null;
        BigDecimal oRetVal = null;
        try {
            this.rsSch.createTab("Numeric_Tab", this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Numeric_Proc(?,?,?)}");
            this.msg.setMsg("Register the output parameter");
            this.cstmt.registerOutParameter(1, 2, 15);
            this.cstmt.registerOutParameter(2, 2, 15);
            this.cstmt.registerOutParameter(3, 2, 15);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            this.msg.setMsg("invoke getBigDecimal method");
            oRetVal = this.cstmt.getBigDecimal(1);
            String sRetStr = this.rsSch.extractVal("Numeric_Tab", 1, this.sqlp, this.conn);
            this.msg.setMsg("extracted MAX_VAL from Numeric_Tab");
            maxBigDecimalVal = new BigDecimal(sRetStr);
            this.msg.addOutputMsg("" + maxBigDecimalVal, "" + oRetVal);
            if (oRetVal.compareTo(maxBigDecimalVal) == 0) {
                this.msg.setMsg("getBigDecimal returns the Maximum value ");
            } else {
                this.msg.printTestError("getBigDecimal() did not return the Maximum value", "test getBigDecimal Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getBigDecimal Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getBigDecimal Failed!");
        }
        finally {
            try {
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Numeric_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetBigDecimal02() throws EETest.Fault {
        BigDecimal oRetVal = null;
        BigDecimal minBigDecimalVal = null;
        try {
            this.rsSch.createTab("Numeric_Tab", this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Numeric_Proc(?,?,?)}");
            this.msg.setMsg("Register the output parameter");
            this.cstmt.registerOutParameter(1, 2, 15);
            this.cstmt.registerOutParameter(2, 2, 15);
            this.cstmt.registerOutParameter(3, 2, 15);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            this.msg.setMsg("invoke getBigDecimal method");
            oRetVal = this.cstmt.getBigDecimal(2);
            String sRetStr = this.rsSch.extractVal("Numeric_Tab", 2, this.sqlp, this.conn);
            this.msg.setMsg("extracted MIN_VAL from Numeric_Tab");
            minBigDecimalVal = new BigDecimal(sRetStr);
            this.msg.addOutputMsg(sRetStr, oRetVal.toString());
            if (oRetVal.compareTo(minBigDecimalVal) == 0) {
                this.msg.setMsg("getBigDecimal returns the Minimum value ");
            } else {
                this.msg.printTestError("getBigDecimal() did not return the Minimum value", "test getBigdecimal failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getBigDecimal Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getBigDecimal Failed!");
        }
        finally {
            try {
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Numeric_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    public void testGetBigDecimal03() throws EETest.Fault {
        try {
            this.rsSch.createTab("Numeric_Tab", this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Numeric_Proc(?,?,?)}");
            this.msg.setMsg("Register the output parameter");
            this.cstmt.registerOutParameter(1, 2, 15);
            this.cstmt.registerOutParameter(2, 2, 15);
            this.cstmt.registerOutParameter(3, 2, 15);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            this.msg.setMsg("invoke getBigDecimal method");
            BigDecimal oRetVal = this.cstmt.getBigDecimal(3);
            this.msg.addOutputMsg("null", "" + oRetVal);
            if (oRetVal == null) {
                this.msg.setMsg("getBigDecimal returns the Null value ");
            } else {
                this.msg.printTestError("getBigDecimal() did not return the Null value", "test getBigDecimal Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getBigDecimal Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getBigDecimal Failed!");
        }
        finally {
            try {
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Numeric_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetDouble01() throws EETest.Fault {
        Double oRetVal = null;
        Double maxDoubleVal = null;
        try {
            this.rsSch.createTab("Double_Tab", this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Double_Proc(?,?,?)}");
            this.msg.setMsg("register the output parameters");
            this.cstmt.registerOutParameter(1, 8);
            this.cstmt.registerOutParameter(2, 8);
            this.cstmt.registerOutParameter(3, 8);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            this.msg.setMsg("invoke getDouble method");
            double fRetVal = this.cstmt.getDouble(1);
            oRetVal = new Double(fRetVal);
            String sRetStr = this.rsSch.extractVal("Double_Tab", 1, this.sqlp, this.conn);
            this.msg.setMsg("extracted MAX_VAL from Double_Tab");
            maxDoubleVal = new Double(sRetStr);
            this.msg.addOutputMsg(sRetStr, oRetVal.toString());
            if (oRetVal.equals(maxDoubleVal)) {
                this.msg.setMsg("getDouble returns the Maximum value ");
            } else {
                this.msg.printTestError("getDouble() did not return the Maximum value", "test getDouble Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getDouble Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getDouble Failed!");
        }
        finally {
            try {
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Float_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetDouble02() throws EETest.Fault {
        Double oRetVal = null;
        Double minDoubleVal = null;
        try {
            this.rsSch.createTab("Double_Tab", this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Double_Proc(?,?,?)}");
            this.msg.setMsg("Register the output parameters");
            this.cstmt.registerOutParameter(1, 8);
            this.cstmt.registerOutParameter(2, 8);
            this.cstmt.registerOutParameter(3, 8);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            this.msg.setMsg("invoke getDouble method");
            double fRetVal = this.cstmt.getDouble(2);
            oRetVal = new Double(fRetVal);
            String sRetStr = this.rsSch.extractVal("Double_Tab", 2, this.sqlp, this.conn);
            this.msg.setMsg("extracted MIN_VAL from Double_Tab");
            minDoubleVal = new Double(sRetStr);
            this.msg.addOutputMsg(sRetStr, oRetVal.toString());
            if (oRetVal.equals(minDoubleVal)) {
                this.msg.setMsg("getDouble returns the Minimum value ");
            } else {
                this.msg.printTestError("getDouble() did not return the Minimum value", "test getDouble Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getDouble Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getDouble Failed!");
        }
        finally {
            try {
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Float_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    public void testGetDouble03() throws EETest.Fault {
        try {
            this.rsSch.createTab("Double_Tab", this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Double_Proc(?,?,?)}");
            this.msg.setMsg("register the output parameters");
            this.cstmt.registerOutParameter(1, 8);
            this.cstmt.registerOutParameter(2, 8);
            this.cstmt.registerOutParameter(3, 8);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            this.msg.setMsg("invoke getFloat method");
            double oRetVal = this.cstmt.getDouble(3);
            this.msg.addOutputMsg("0.0", new Double(oRetVal).toString());
            if (oRetVal == 0.0) {
                this.msg.setMsg("getDouble returns the Null value ");
            } else {
                this.msg.printTestError("getDouble() did not return the Null value", "test getDouble Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getDouble Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getDouble Failed!");
        }
        finally {
            try {
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Float_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetShort01() throws EETest.Fault {
        Short oRetVal = null;
        Short maxShortVal = null;
        try {
            this.rsSch.createTab("Smallint_Tab", this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Smallint_Proc(?,?,?)}");
            this.msg.setMsg("register the output parameters");
            this.cstmt.registerOutParameter(1, 5, 0);
            this.cstmt.registerOutParameter(2, 5, 0);
            this.cstmt.registerOutParameter(3, 5, 0);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            this.msg.setMsg("invoke getShort method");
            short rRetVal = this.cstmt.getShort(1);
            oRetVal = new Short(rRetVal);
            String sRetStr = this.rsSch.extractVal("Smallint_Tab", 1, this.sqlp, this.conn);
            this.msg.setMsg("extracted MAX_VAL from Smallint_Tab");
            maxShortVal = new Short(sRetStr);
            this.msg.addOutputMsg(sRetStr, oRetVal.toString());
            if (oRetVal.equals(maxShortVal)) {
                this.msg.setMsg("getShort returns the Maximum value ");
            } else {
                this.msg.printTestError("getShort() did not return the Maximum value", "test getShort Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getShort is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getShort Failed!");
        }
        finally {
            try {
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Smallint_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetShort02() throws EETest.Fault {
        Short oRetVal = null;
        Short minShortVal = null;
        try {
            this.rsSch.createTab("Smallint_Tab", this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Smallint_Proc(?,?,?)}");
            this.msg.setMsg("register the output parameters");
            this.cstmt.registerOutParameter(1, 5, 0);
            this.cstmt.registerOutParameter(2, 5, 15);
            this.cstmt.registerOutParameter(3, 5, 0);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            this.msg.setMsg("invoke getShort method");
            short rRetVal = this.cstmt.getShort(2);
            oRetVal = new Short(rRetVal);
            String sRetStr = this.rsSch.extractVal("Smallint_Tab", 2, this.sqlp, this.conn);
            this.msg.setMsg("extracted MIN_VAL from Smallint_Tab");
            minShortVal = new Short(sRetStr);
            this.msg.addOutputMsg(sRetStr, oRetVal.toString());
            if (oRetVal.equals(minShortVal)) {
                this.msg.setMsg("getShort returns the Minimum value ");
            } else {
                this.msg.printTestError("getShort() did not return the Minimum value", "test getShort Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getShort is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getShort Failed!");
        }
        finally {
            try {
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Smallint_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    public void testGetShort03() throws EETest.Fault {
        try {
            this.rsSch.createTab("Smallint_Tab", this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Smallint_Proc(?,?,?)}");
            this.msg.setMsg("register the output parameters");
            this.cstmt.registerOutParameter(1, 5, 0);
            this.cstmt.registerOutParameter(2, 5, 0);
            this.cstmt.registerOutParameter(3, 5, 0);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            this.msg.setMsg("invoke getShort method");
            short rRetVal = this.cstmt.getShort(3);
            this.msg.addOutputMsg("0", Short.toString(rRetVal));
            if (rRetVal == 0) {
                this.msg.setMsg("getShort returns the Null value ");
            } else {
                this.msg.printTestError("getShort() did not return the Null value", "test getShort Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getShort is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getShort Failed!");
        }
        finally {
            try {
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Smallint_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    public void testGetString01() throws EETest.Fault {
        try {
            this.rsSch.createTab("Char_Tab", this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Char_Proc(?,?)}");
            this.msg.setMsg("register the output parameters");
            this.cstmt.registerOutParameter(1, 1);
            this.cstmt.registerOutParameter(2, 1);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            this.msg.setMsg("invoke getString method");
            String sRetVal = this.cstmt.getString(1);
            sRetVal = sRetVal.trim();
            String sRetStr = this.rsSch.extractVal("Char_Tab", 1, this.sqlp, this.conn);
            this.msg.setMsg("extracted MAX_VAL from Smallint_Tab");
            sRetStr = sRetStr.trim();
            this.msg.addOutputMsg(sRetStr, sRetVal);
            if (sRetVal.equals(sRetStr.substring(1, sRetStr.length() - 1))) {
                this.msg.setMsg("getString returns the non null String value");
            } else {
                this.msg.printTestError("getString() did not return the non null String value", "test getString Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getString is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getString Failed!");
        }
        finally {
            try {
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Char_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    public void testGetString02() throws EETest.Fault {
        try {
            this.rsSch.createTab("Char_Tab", this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Char_Proc(?,?)}");
            this.msg.setMsg("register the output parameters");
            this.cstmt.registerOutParameter(1, 1);
            this.cstmt.registerOutParameter(2, 1);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            this.msg.setMsg("invoke getString method");
            String sRetVal = this.cstmt.getString(2);
            this.msg.addOutputMsg("null", sRetVal);
            if (sRetVal == null) {
                this.msg.setMsg("getString returns null value" + sRetVal);
            } else {
                this.msg.printTestError("getString() did not return the null value", "test getString Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getString is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getString Failed!");
        }
        finally {
            try {
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Char_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetInt01() throws EETest.Fault {
        Integer oRetVal = null;
        Integer maxIntegerVal = null;
        try {
            this.rsSch.createTab("Integer_Tab", this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Integer_Proc(?,?,?)}");
            this.msg.setMsg("register the output parameters");
            this.cstmt.registerOutParameter(1, 4);
            this.cstmt.registerOutParameter(2, 4);
            this.cstmt.registerOutParameter(3, 4);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            this.msg.setMsg("invoke getInt method");
            int nRetVal = this.cstmt.getInt(1);
            oRetVal = new Integer(nRetVal);
            String sRetStr = this.rsSch.extractVal("Integer_Tab", 1, this.sqlp, this.conn);
            this.msg.setMsg("extracted MAX_VAL from Integer_Tab");
            maxIntegerVal = new Integer(sRetStr);
            this.msg.addOutputMsg(sRetStr, oRetVal.toString());
            if (oRetVal.equals(maxIntegerVal)) {
                this.msg.setMsg("getInt returns the Maximum value ");
            } else {
                this.msg.printTestError("getInt() did not return the Maximum value", "test getInt Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getInt is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getInt is Failed!");
        }
        finally {
            try {
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Integer_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetInt02() throws EETest.Fault {
        Integer oRetVal = null;
        Integer minIntegerVal = null;
        try {
            this.rsSch.createTab("Integer_Tab", this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Integer_Proc(?,?,?)}");
            this.msg.setMsg("register the output parameters");
            this.cstmt.registerOutParameter(1, 4);
            this.cstmt.registerOutParameter(2, 4);
            this.cstmt.registerOutParameter(3, 4);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            this.msg.setMsg("invoke getInt method");
            int nRetVal = this.cstmt.getInt(2);
            oRetVal = new Integer(nRetVal);
            String sRetStr = this.rsSch.extractVal("Integer_Tab", 2, this.sqlp, this.conn);
            this.msg.setMsg("extracted MIN_VAL from Integer_Tab");
            minIntegerVal = new Integer(sRetStr);
            this.msg.addOutputMsg(sRetStr, oRetVal.toString());
            if (oRetVal.equals(minIntegerVal)) {
                this.msg.setMsg("getInt returns the Minimum value ");
            } else {
                this.msg.printTestError("getInt() did not return the Maximum value", "test getInt Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getInt is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getInt is Failed!");
        }
        finally {
            try {
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Integer_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    public void testGetInt03() throws EETest.Fault {
        try {
            this.rsSch.createTab("Integer_Tab", this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Integer_Proc(?,?,?)}");
            this.msg.setMsg("register the output parameters");
            this.cstmt.registerOutParameter(1, 4);
            this.cstmt.registerOutParameter(2, 4);
            this.cstmt.registerOutParameter(3, 4);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            this.msg.setMsg("invoke getInt method");
            int nRetVal = this.cstmt.getInt(3);
            this.msg.addOutputMsg("0", new Integer(nRetVal).toString());
            if (nRetVal == 0) {
                this.msg.setMsg("getInt returns the Null value ");
            } else {
                this.msg.printTestError("getInt() did not return the null value", "test getInt Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getInt is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getInt is Failed!");
        }
        finally {
            try {
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Integer_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetBoolean01() throws EETest.Fault {
        Boolean oRetVal = null;
        Boolean maxBooleanVal = null;
        try {
            this.rsSch.createTab("Bit_Tab", this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Bit_Proc(?,?,?)}");
            this.msg.setMsg("register the output parameters");
            this.cstmt.registerOutParameter(1, -7);
            this.cstmt.registerOutParameter(2, -7);
            this.cstmt.registerOutParameter(3, -7);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            this.msg.setMsg("invoke getBoolean method");
            boolean bRetVal = this.cstmt.getBoolean(1);
            oRetVal = new Boolean(bRetVal);
            String sRetStr = this.rsSch.extractVal("Boolean_Tab", 1, this.sqlp, this.conn);
            this.msg.setMsg("extracted MAX_VAL from Boolean_Tab");
            maxBooleanVal = new Boolean(sRetStr);
            this.msg.addOutputMsg(sRetStr, oRetVal.toString());
            if (oRetVal.equals(maxBooleanVal)) {
                this.msg.setMsg("getBoolean returns the Maximum value ");
            } else {
                this.msg.printTestError("getBoolean() did not return the Maximum value", "test getBoolean failed");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getBoolean is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getBoolean is Failed!");
        }
        finally {
            try {
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Bit_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetBoolean02() throws EETest.Fault {
        Boolean oRetVal = null;
        Boolean minBooleanVal = null;
        try {
            this.rsSch.createTab("Bit_Tab", this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Bit_Proc(?,?,?)}");
            this.msg.setMsg("register the output parameters");
            this.cstmt.registerOutParameter(1, -7);
            this.cstmt.registerOutParameter(2, -7);
            this.cstmt.registerOutParameter(3, -7);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            this.msg.setMsg("invoke getBoolean method");
            boolean bRetVal = this.cstmt.getBoolean(2);
            oRetVal = new Boolean(bRetVal);
            String sRetStr = this.rsSch.extractVal("Boolean_Tab", 2, this.sqlp, this.conn);
            this.msg.setMsg("extracted MIN_VAL from Boolean_Tab");
            minBooleanVal = new Boolean(sRetStr);
            this.msg.addOutputMsg(sRetStr, oRetVal.toString());
            if (oRetVal.equals(minBooleanVal)) {
                this.msg.setMsg("getBoolean returns the Minimum value ");
            } else {
                this.msg.printTestError("getBoolean() did not return the Minimum value", "getBoolean Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getBoolean is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getBoolean is Failed!");
        }
        finally {
            try {
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Bit_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetLong01() throws EETest.Fault {
        Long oRetVal = null;
        Long maxLongVal = null;
        try {
            this.rsSch.createTab("Bigint_Tab", this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Bigint_Proc(?,?,?)}");
            this.msg.setMsg("register the output parameters");
            this.cstmt.registerOutParameter(1, -5);
            this.cstmt.registerOutParameter(2, -5);
            this.cstmt.registerOutParameter(3, -5);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            this.msg.setMsg("invoke getLong method");
            long lRetVal = this.cstmt.getLong(1);
            oRetVal = new Long(lRetVal);
            String sRetStr = this.rsSch.extractVal("Bigint_Tab", 1, this.sqlp, this.conn);
            this.msg.setMsg("extracted MAX_VAL from Bigint_Tab");
            maxLongVal = new Long(sRetStr);
            this.msg.addOutputMsg(sRetStr, oRetVal.toString());
            if (oRetVal.equals(maxLongVal)) {
                this.msg.setMsg("getLong returns the Maximum value ");
            } else {
                this.msg.printTestError("getLong() did not return the Maximum value", "test getLong Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getLong is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getLong is Failed!");
        }
        finally {
            try {
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Bigint_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetLong02() throws EETest.Fault {
        Long oRetVal = null;
        Long minLongVal = null;
        try {
            this.rsSch.createTab("Bigint_Tab", this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Bigint_Proc(?,?,?)}");
            this.msg.setMsg("register the output parameters");
            this.cstmt.registerOutParameter(1, -5);
            this.cstmt.registerOutParameter(2, -5);
            this.cstmt.registerOutParameter(3, -5);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            this.msg.setMsg("invoke getLong method");
            long lRetVal = this.cstmt.getLong(2);
            oRetVal = new Long(lRetVal);
            String sRetStr = this.rsSch.extractVal("Bigint_Tab", 2, this.sqlp, this.conn);
            minLongVal = new Long(sRetStr);
            this.msg.setMsg("extracted MIN_VAL from Bigint_Tab");
            this.msg.addOutputMsg(sRetStr, oRetVal.toString());
            if (oRetVal.equals(minLongVal)) {
                this.msg.setMsg("getLong returns the Minimum value ");
            } else {
                this.msg.printTestError("getLong() did not return the Minimum value", "test getLong Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getLong is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getLong is Failed!");
        }
        finally {
            try {
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Bigint_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    public void testGetLong03() throws EETest.Fault {
        try {
            this.rsSch.createTab("Bigint_Tab", this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Bigint_Proc(?,?,?)}");
            this.msg.setMsg("register the output parameters");
            this.cstmt.registerOutParameter(1, -5);
            this.cstmt.registerOutParameter(2, -5);
            this.cstmt.registerOutParameter(3, -5);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            this.msg.setMsg("invoke getLong method");
            long lRetVal = this.cstmt.getLong(3);
            this.msg.addOutputMsg("0", new Long(lRetVal).toString());
            if (lRetVal == 0L) {
                this.msg.setMsg("getLong returns the Null value ");
            } else {
                this.msg.printTestError("getLong() did not return the null value", "test getLong Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getLong is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getLong is Failed!");
        }
        finally {
            try {
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Bigint_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    public void cleanup() throws EETest.Fault {
        try {
            this.rsSch.dbUnConnect(this.conn);
            this.logMsg("Cleanup ok;");
        }
        catch (Exception e) {
            this.logErr("An error occurred while closing the database connection", e);
        }
    }
}

