/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb32.lite.timer.schedule.tz;

import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.ejb30.common.helper.Helper;
import com.sun.ts.tests.ejb30.timer.common.TimerBeanBaseWithoutTimeOutMethod;
import com.sun.ts.tests.ejb30.timer.common.TimerUtil;
import jakarta.ejb.ScheduleExpression;
import jakarta.ejb.Stateless;
import jakarta.ejb.Timeout;
import jakarta.ejb.Timer;
import jakarta.ejb.TimerConfig;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.TimeZone;
import java.util.logging.Level;

@Stateless
public class TZScheduleBareBean
extends TimerBeanBaseWithoutTimeOutMethod {
    protected static final String DEFAULT_TZ = "DEFAULT_TZ";
    protected static final String PROGRAMMATIC_TIMER_DEFAULT_TZ = "PROGRAMMATIC_TIMER_DEFAULT_TZ";
    protected static final String AMERICA_ARGENTINA_SAN_LUIS = "  America/Argentina/San_Luis  ";
    protected static final String AMERICA_ARGENTINA_USHUAIA = "America/Argentina/Ushuaia";
    protected static final String ASIA_SHANGHAI = "Asia/Shanghai";
    private static final String ZONE_TAB = "zone.tab";
    protected List<String> zoneTab;

    @Timeout
    protected void year5000() {
        throw new IllegalStateException("We will not see this in our life.");
    }

    public String defaultTZ() {
        TimerConfig config = new TimerConfig((Serializable)((Object)PROGRAMMATIC_TIMER_DEFAULT_TZ), false);
        ScheduleExpression exp = new ScheduleExpression().year(5000);
        this.timerService.createCalendarTimer(exp, config);
        return this.verifyTZ(DEFAULT_TZ, null, new StringBuilder[0]) + TestUtil.NEW_LINE + this.verifyTZ(PROGRAMMATIC_TIMER_DEFAULT_TZ, null, new StringBuilder[0]);
    }

    public String shanghaiAndArgentinaTZ() {
        return this.verifyTZ(ASIA_SHANGHAI, ASIA_SHANGHAI, new StringBuilder[0]) + TestUtil.NEW_LINE + this.verifyTZ(AMERICA_ARGENTINA_SAN_LUIS, AMERICA_ARGENTINA_SAN_LUIS, new StringBuilder[0]) + TestUtil.NEW_LINE + this.verifyTZ(AMERICA_ARGENTINA_USHUAIA, AMERICA_ARGENTINA_USHUAIA, new StringBuilder[0]);
    }

    public String allTZ() {
        StringBuilder sb = new StringBuilder();
        ArrayList<Timer> timers = new ArrayList<Timer>();
        TimerConfig config = new TimerConfig();
        config.setPersistent(false);
        ScheduleExpression exp = new ScheduleExpression().year(5000);
        for (String z : this.zoneTab) {
            exp = exp.timezone(z);
            config.setInfo((Serializable)((Object)z));
            timers.add(this.timerService.createCalendarTimer(exp, config));
        }
        for (String z : this.zoneTab) {
            this.verifyTZ(z, z, sb);
            sb.append(TestUtil.NEW_LINE);
        }
        return sb.toString();
    }

    public Timer expireInLaterTZ() {
        TimerConfig config = new TimerConfig((Serializable)((Object)"expireInAnotherTZ"), false);
        Calendar cal = Calendar.getInstance();
        cal.add(13, 1);
        ScheduleExpression exp = TimerUtil.getPreciseScheduleExpression(cal);
        exp.timezone(this.getLaterTZ());
        Timer t = this.timerService.createCalendarTimer(exp, config);
        Helper.getLogger().fine("Created a timer with schedule " + exp);
        return t;
    }

    protected String verifyTZ(String timerName, String expected, StringBuilder ... sbs) {
        StringBuilder sb = sbs.length == 0 ? new StringBuilder() : sbs[0];
        Timer t = this.findTimer(timerName);
        ScheduleExpression exp = t.getSchedule();
        sb.append("Check TZ in schedule: ").append(TimerUtil.toString(exp));
        String expectedTrimmedUp = expected == null ? expected : expected.trim().toUpperCase();
        String actualTrimmedUp = exp.getTimezone() == null ? null : exp.getTimezone().trim().toUpperCase();
        Helper.assertEquals(" ", expectedTrimmedUp, actualTrimmedUp, sb);
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initZoneTab() {
        this.zoneTab = new ArrayList<String>();
        InputStream is = this.getClass().getResourceAsStream(ZONE_TAB);
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        String line = null;
        try {
            while ((line = br.readLine()) != null) {
                if ((line = line.trim()).length() < 3) continue;
                this.zoneTab.add(line);
            }
        }
        catch (IOException e) {
            Helper.getLogger().log(Level.WARNING, "Failed to read zone.tab", e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
        if (this.zoneTab.size() == 0) {
            Helper.getLogger().warning("0 entries read from zone.tab");
            this.zoneTab = null;
        }
    }

    protected String getLaterTZ() {
        int defaultTZOffset;
        TimeZone laterTZ = null;
        TimeZone defaultTZ = TimeZone.getDefault();
        int laterTZOffset = defaultTZOffset = defaultTZ.getRawOffset();
        for (int i = 0; i < this.zoneTab.size() && laterTZOffset >= defaultTZOffset; ++i) {
            laterTZ = TimeZone.getTimeZone(this.zoneTab.get(i));
            laterTZOffset = laterTZ.getRawOffset();
        }
        if (laterTZOffset >= defaultTZOffset) {
            Helper.getLogger().warning("Searched all entries in zone.tab, but couldn't find a TZ later than the default TZ:" + defaultTZ + ", defaultTZOffset=" + defaultTZOffset + ", laterTZOffset=" + laterTZOffset);
        } else {
            Helper.getLogger().fine("defaultTZ=" + defaultTZ + TestUtil.NEW_LINE + "laterTZ=" + laterTZ);
        }
        return laterTZ.getID();
    }
}

