/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb.ee.bb.session.stateful.sessioncontexttest;

import com.sun.ts.lib.util.RemoteLoggingInitException;
import com.sun.ts.lib.util.TestUtil;
import jakarta.ejb.CreateException;
import jakarta.ejb.SessionBean;
import jakarta.ejb.SessionContext;
import jakarta.transaction.UserTransaction;
import java.util.Properties;

public class TestBean2EJB
implements SessionBean {
    private SessionContext sctx = null;
    private Properties harnessProps = null;

    public void ejbCreate(Properties p) throws CreateException {
        TestUtil.logTrace((String)"ejbCreate");
        this.harnessProps = p;
        try {
            TestUtil.logMsg((String)"initialize remote logging");
            TestUtil.init((Properties)p);
        }
        catch (RemoteLoggingInitException e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new CreateException(e.getMessage());
        }
    }

    public void setSessionContext(SessionContext sc) {
        TestUtil.logTrace((String)"setSessionContext");
        this.sctx = sc;
    }

    public void ejbRemove() {
        TestUtil.logTrace((String)"ejbRemove");
    }

    public void ejbActivate() {
        TestUtil.logTrace((String)"ejbActivate");
    }

    public void ejbPassivate() {
        TestUtil.logTrace((String)"ejbPassivate");
    }

    public boolean getUserTransactionTest() {
        TestUtil.logTrace((String)"getUserTransactionTest");
        boolean pass = true;
        TestUtil.logMsg((String)"invoke SessionContext.getUserTransaction() method");
        try {
            UserTransaction ut = this.sctx.getUserTransaction();
            TestUtil.logErr((String)"IllegalStateException not received - unexpected");
            pass = false;
        }
        catch (IllegalStateException e) {
            TestUtil.logMsg((String)"IllegalStateException received - expected");
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        return pass;
    }

    public boolean setRollbackOnlyTest() {
        TestUtil.logTrace((String)"setRollbackOnlyTest");
        boolean pass = true;
        try {
            TestUtil.logMsg((String)"get rollback status");
            if (this.sctx.getRollbackOnly()) {
                TestUtil.logMsg((String)"transaction marked for rollback - unexpected");
                return false;
            }
            TestUtil.logMsg((String)"transaction not marked for rollback - expected");
            TestUtil.logMsg((String)"mark transaction for rollback");
            this.sctx.setRollbackOnly();
            TestUtil.logMsg((String)"get rollback status");
            if (this.sctx.getRollbackOnly()) {
                TestUtil.logMsg((String)"transaction marked for rollback - expected");
            } else {
                TestUtil.logMsg((String)"transaction not marked for rollback - unexpected");
                pass = false;
            }
            return pass;
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            return false;
        }
    }

    public boolean getRollbackOnlyTest() {
        TestUtil.logTrace((String)"getRollbackOnlyTest");
        boolean pass = true;
        try {
            TestUtil.logMsg((String)"get rollback status");
            if (this.sctx.getRollbackOnly()) {
                TestUtil.logMsg((String)"transaction marked for rollback - unexpected");
                return false;
            }
            TestUtil.logMsg((String)"transaction not marked for rollback - expected");
            TestUtil.logMsg((String)"mark transaction for rollback");
            this.sctx.setRollbackOnly();
            TestUtil.logMsg((String)"get rollback status");
            if (this.sctx.getRollbackOnly()) {
                TestUtil.logMsg((String)"transaction marked for rollback - expected");
            } else {
                TestUtil.logMsg((String)"transaction not marked for rollback - unexpected");
                pass = false;
            }
            return pass;
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            return false;
        }
    }
}

