/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jpa.core.derivedid.ex2b;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jpa.common.PMClientBase;
import com.sun.ts.tests.jpa.core.derivedid.ex2b.DID2bDependent;
import com.sun.ts.tests.jpa.core.derivedid.ex2b.DID2bDependentId;
import com.sun.ts.tests.jpa.core.derivedid.ex2b.DID2bEmployee;
import com.sun.ts.tests.jpa.core.derivedid.ex2b.DID2bEmployeeId;
import java.util.List;
import java.util.Properties;

public class Client
extends PMClientBase {
    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    @Override
    public void setup(String[] args, Properties p) throws EETest.Fault {
        TestUtil.logTrace((String)"setup");
        try {
            super.setup(args, p);
            this.removeTestData();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception: ", (Throwable)e);
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    public void DIDTest() throws EETest.Fault {
        boolean pass1 = false;
        boolean pass2 = false;
        try {
            this.getEntityTransaction().begin();
            DID2bEmployeeId eId1 = new DID2bEmployeeId("Java", "Duke");
            DID2bEmployeeId eId2 = new DID2bEmployeeId("C", "foo");
            DID2bEmployee employee1 = new DID2bEmployee(eId1);
            DID2bEmployee employee2 = new DID2bEmployee(eId2);
            DID2bDependent dep1 = new DID2bDependent(new DID2bDependentId("Obama", eId1), employee1);
            DID2bDependent dep2 = new DID2bDependent(new DID2bDependentId("Michelle", eId1), employee1);
            DID2bDependent dep3 = new DID2bDependent(new DID2bDependentId("John", eId2), employee2);
            this.getEntityManager().persist((Object)dep1);
            this.getEntityManager().persist((Object)dep2);
            this.getEntityManager().persist((Object)dep3);
            this.getEntityManager().persist((Object)employee1);
            this.getEntityManager().persist((Object)employee2);
            this.getEntityManager().flush();
            TestUtil.logTrace((String)"persisted Employees and Dependents");
            DID2bDependent newDependent = (DID2bDependent)this.getEntityManager().find(DID2bDependent.class, (Object)new DID2bDependentId("Obama", new DID2bEmployeeId("Java", "Duke")));
            if (newDependent != null) {
                this.getEntityManager().refresh((Object)newDependent);
            }
            List depList = this.getEntityManager().createQuery("Select d from DID2bDependent d where d.id.name='Obama' and d.emp.firstName='Java'").getResultList();
            newDependent = null;
            if (depList.size() > 0) {
                newDependent = (DID2bDependent)depList.get(0);
                if (newDependent == dep1) {
                    pass1 = true;
                    TestUtil.logTrace((String)"Received Expected Dependent");
                } else {
                    TestUtil.logErr((String)"Searched Dependent not found");
                }
            } else {
                TestUtil.logErr((String)"getEntityManager().createQuery returned null entry");
            }
            List depList2 = this.getEntityManager().createQuery("Select d from DID2bDependent d where d.id.name='Obama' and d.id.empPK.firstName='Java'").getResultList();
            DID2bDependent newDependent2 = null;
            if (depList2.size() > 0) {
                newDependent2 = (DID2bDependent)depList2.get(0);
                if (newDependent2 == dep1) {
                    pass2 = true;
                    TestUtil.logTrace((String)"Received Expected Dependent");
                } else {
                    TestUtil.logErr((String)"Searched Dependent not found");
                }
            } else {
                TestUtil.logErr((String)"getEntityManager().createQuery returned null entry");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
            this.getEntityTransaction().rollback();
        }
        if (!pass1 || !pass2) {
            throw new EETest.Fault("DTDTest failed");
        }
    }

    @Override
    public void cleanup() throws EETest.Fault {
        TestUtil.logTrace((String)"cleanup");
        this.removeTestData();
        TestUtil.logTrace((String)"cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    private void removeTestData() {
        TestUtil.logTrace((String)"removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM DID2BDEPENDENT").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM DID2BEMPLOYEE").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

