/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.containers.interceptors;

import com.sun.enterprise.deployment.InterceptorDescriptor;
import com.sun.enterprise.deployment.LifecycleCallbackDescriptor;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.interceptor.AroundConstruct;
import jakarta.interceptor.AroundInvoke;
import jakarta.interceptor.AroundTimeout;
import jakarta.interceptor.InvocationContext;
import java.lang.reflect.InaccessibleObjectException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class SystemInterceptorProxy {
    public Object delegate;
    private Method aroundConstruct;
    private Method postConstruct;
    private Method preDestroy;
    private Method aroundInvoke;
    private Method aroundTimeout;

    public void setDelegate(Object delegate) {
        try {
            for (Method delegateMethod : delegate.getClass().getDeclaredMethods()) {
                if (delegateMethod.getAnnotation(PostConstruct.class) != null) {
                    this.postConstruct = delegateMethod;
                    this.prepareMethod(delegateMethod);
                    continue;
                }
                if (delegateMethod.getAnnotation(PreDestroy.class) != null) {
                    this.preDestroy = delegateMethod;
                    this.prepareMethod(delegateMethod);
                    continue;
                }
                if (delegateMethod.getAnnotation(AroundInvoke.class) != null) {
                    this.aroundInvoke = delegateMethod;
                    this.prepareMethod(delegateMethod);
                    continue;
                }
                if (delegateMethod.getAnnotation(AroundTimeout.class) != null) {
                    this.aroundTimeout = delegateMethod;
                    this.prepareMethod(delegateMethod);
                    continue;
                }
                if (delegateMethod.getAnnotation(AroundConstruct.class) == null) continue;
                this.aroundConstruct = delegateMethod;
                this.prepareMethod(delegateMethod);
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
        this.delegate = delegate;
    }

    @PostConstruct
    public Object init(InvocationContext ctx) throws Exception {
        return this.doCall(ctx, this.postConstruct);
    }

    @PreDestroy
    public Object destroy(InvocationContext ctx) throws Exception {
        return this.doCall(ctx, this.preDestroy);
    }

    @AroundConstruct
    public Object create(InvocationContext ctx) throws Exception {
        return this.doCall(ctx, this.aroundConstruct);
    }

    @AroundInvoke
    public Object aroundInvoke(InvocationContext ctx) throws Exception {
        return this.doCall(ctx, this.aroundInvoke);
    }

    @AroundTimeout
    public Object aroundTimeout(InvocationContext ctx) throws Exception {
        return this.doCall(ctx, this.aroundTimeout);
    }

    private Object doCall(InvocationContext ctx, Method method) throws Exception {
        Object returnValue = null;
        if (this.delegate != null && method != null) {
            try {
                returnValue = method.invoke(this.delegate, ctx);
            }
            catch (InvocationTargetException ite) {
                Throwable cause = ite.getCause();
                if (cause instanceof Exception) {
                    throw (Exception)cause;
                }
                throw new Exception(cause);
            }
        } else {
            returnValue = ctx.proceed();
        }
        return returnValue;
    }

    public static InterceptorDescriptor createInterceptorDesc() {
        InterceptorDescriptor interceptor = new InterceptorDescriptor();
        Class<SystemInterceptorProxy> interceptorClass = SystemInterceptorProxy.class;
        String interceptorName = interceptorClass.getName();
        interceptor.setInterceptorClass(interceptorClass);
        LifecycleCallbackDescriptor desc = new LifecycleCallbackDescriptor();
        desc.setLifecycleCallbackClass(interceptorName);
        desc.setLifecycleCallbackMethod("create");
        interceptor.addCallbackDescriptor(LifecycleCallbackDescriptor.CallbackType.AROUND_CONSTRUCT, desc);
        desc = new LifecycleCallbackDescriptor();
        desc.setLifecycleCallbackClass(interceptorName);
        desc.setLifecycleCallbackMethod("init");
        interceptor.addCallbackDescriptor(LifecycleCallbackDescriptor.CallbackType.POST_CONSTRUCT, desc);
        desc = new LifecycleCallbackDescriptor();
        desc.setLifecycleCallbackClass(interceptorName);
        desc.setLifecycleCallbackMethod("destroy");
        interceptor.addCallbackDescriptor(LifecycleCallbackDescriptor.CallbackType.PRE_DESTROY, desc);
        desc = new LifecycleCallbackDescriptor();
        desc.setLifecycleCallbackClass(interceptorName);
        desc.setLifecycleCallbackMethod("aroundInvoke");
        interceptor.addAroundInvokeDescriptor(desc);
        desc = new LifecycleCallbackDescriptor();
        desc.setLifecycleCallbackClass(interceptorName);
        desc.setLifecycleCallbackMethod("aroundTimeout");
        interceptor.addAroundTimeoutDescriptor(desc);
        return interceptor;
    }

    private void prepareMethod(Method method) throws Exception {
        if (!method.trySetAccessible()) {
            throw new InaccessibleObjectException("Unable to make accessible: " + String.valueOf(method));
        }
    }
}

