/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.invokable;

import jakarta.enterprise.inject.spi.AnnotatedMethod;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;

public final class TargetMethod {
    private final Method reflection;
    private final AnnotatedMethod<?> cdi;

    public TargetMethod(Method reflectionMethod) {
        this.reflection = reflectionMethod;
        this.cdi = null;
    }

    public TargetMethod(AnnotatedMethod<?> cdiMethod) {
        this.reflection = cdiMethod.getJavaMember();
        this.cdi = cdiMethod;
    }

    public Method getReflection() {
        return this.reflection;
    }

    public boolean isStatic() {
        return Modifier.isStatic(this.reflection.getModifiers());
    }

    public int getParameterCount() {
        return this.reflection.getParameterCount();
    }

    public Type getParameterType(int position) {
        return this.reflection.getGenericParameterTypes()[position];
    }

    public Collection<Annotation> getParameterAnnotations(int position) {
        if (this.cdi != null) {
            return this.cdi.getParameters().get(position).getAnnotations();
        }
        return Arrays.asList(this.reflection.getParameterAnnotations()[position]);
    }
}

