/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.api.persistence.enhancer.util;

import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;

public final class Timer {
    PrintWriter out = new PrintWriter(System.out, true);
    HashMap methods = new HashMap();
    private final ArrayList calls = new ArrayList(16);

    public Timer() {
    }

    public Timer(PrintWriter out) {
        this.out = out;
    }

    public final synchronized void push(String name) {
        this.push(name, name);
    }

    public final synchronized void push(String name, String message) {
        long now = System.currentTimeMillis();
        MethodDescriptor current = (MethodDescriptor)this.methods.get(name);
        if (current == null) {
            current = new MethodDescriptor(name);
            this.methods.put(name, current);
        }
        ++current.calls;
        ++current.instantiations;
        this.calls.add(new MethodCall(current, message, now, now));
    }

    public final synchronized void pop() {
        long now = System.currentTimeMillis();
        MethodCall call = (MethodCall)this.calls.remove(this.calls.size() - 1);
        long currentSelf = now - call.self;
        long currentTotal = now - call.total;
        if (this.calls.size() > 0) {
            MethodCall previous = (MethodCall)this.calls.get(this.calls.size() - 1);
            previous.self += currentTotal;
        }
        MethodDescriptor current = call.method;
        current.self += currentSelf;
        if (--current.instantiations == 0) {
            current.total += currentTotal;
        }
    }

    private static final String pad(String s, int i) {
        StringBuffer b = new StringBuffer();
        i -= s.length();
        while (i > 0) {
            b.append(' ');
            --i;
        }
        b.append(s);
        return b.toString();
    }

    public final synchronized void print() {
        this.out.println("Timer : printing accumulated times ...");
        Object[] calls = this.methods.values().toArray();
        Arrays.sort(calls, new Comparator(this){

            public int compare(Object o1, Object o2) {
                return (int)(((MethodDescriptor)o2).total - ((MethodDescriptor)o1).total);
            }

            @Override
            public boolean equals(Object obj) {
                return obj != null && this.compare(this, obj) == 0;
            }
        });
        this.out.println("Timer :  total s    self s  #calls  name");
        DecimalFormat nf = new DecimalFormat();
        nf.setMaximumFractionDigits(2);
        nf.setMinimumFractionDigits(2);
        for (int i = 0; i < calls.length; ++i) {
            MethodDescriptor current = (MethodDescriptor)calls[i];
            this.out.println("Timer : " + Timer.pad(nf.format((double)current.total / 1000.0), 8) + "  " + Timer.pad(nf.format((double)current.self / 1000.0), 8) + "  " + Timer.pad(String.valueOf(current.calls), 6) + "  " + current.name);
        }
    }

    private static class MethodDescriptor {
        final String name;
        int instantiations;
        int calls;
        long self;
        long total;

        MethodDescriptor(String name) {
            this.name = name;
        }
    }

    private static class MethodCall {
        final MethodDescriptor method;
        final String message;
        long self;
        long total;

        MethodCall(MethodDescriptor method, String message, long self, long total) {
            this.method = method;
            this.message = message;
            this.self = self;
            this.total = total;
        }
    }
}

