/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.logging;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Locale;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;
import org.jboss.weld.exceptions.DefinitionException;
import org.jboss.weld.exceptions.IllegalArgumentException;
import org.jboss.weld.exceptions.WeldException;
import org.jboss.weld.logging.ReflectionLogger;
import org.jboss.weld.logging.WeldLogger;

public class ReflectionLogger_$logger
extends DelegatingBasicLogger
implements ReflectionLogger,
WeldLogger,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ReflectionLogger_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;

    public ReflectionLogger_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    @Override
    public final void missingRetention(Object param1) {
        this.log.logv(FQCN, Logger.Level.DEBUG, (Throwable)null, this.missingRetention$str(), param1);
    }

    protected String missingRetention$str() {
        return "WELD-000600: {0} is missing @Retention(RUNTIME). Weld will use this annotation, however this may make the application unportable.";
    }

    @Override
    public final void missingTarget(Object param1) {
        this.log.logv(FQCN, Logger.Level.DEBUG, (Throwable)null, this.missingTarget$str(), param1);
    }

    protected String missingTarget$str() {
        return "WELD-000601: {0} is missing @Target. Weld will use this annotation, however this may make the application unportable.";
    }

    @Override
    public final void missingTargetTypeMethodOrTargetType(Object param1) {
        this.log.logv(FQCN, Logger.Level.DEBUG, (Throwable)null, this.missingTargetTypeMethodOrTargetType$str(), param1);
    }

    protected String missingTargetTypeMethodOrTargetType$str() {
        return "WELD-000602: {0} is not declared @Target(TYPE, METHOD) or @Target(TYPE). Weld will use this annotation, however this may make the application unportable.";
    }

    @Override
    public final void missingTargetMethodFieldType(Object param1) {
        this.log.logv(FQCN, Logger.Level.DEBUG, (Throwable)null, this.missingTargetMethodFieldType$str(), param1);
    }

    protected String missingTargetMethodFieldType$str() {
        return "WELD-000604: {0} is not declared @Target(METHOD, FIELD, TYPE). Weld will use this annotation, however this may make the application unportable.";
    }

    @Override
    public final void missingTargetMethodFieldTypeParameterOrTargetMethodTypeOrTargetMethodOrTargetTypeOrTargetField(Object param1) {
        this.log.logv(FQCN, Logger.Level.DEBUG, (Throwable)null, this.missingTargetMethodFieldTypeParameterOrTargetMethodTypeOrTargetMethodOrTargetTypeOrTargetField$str(), param1);
    }

    protected String missingTargetMethodFieldTypeParameterOrTargetMethodTypeOrTargetMethodOrTargetTypeOrTargetField$str() {
        return "WELD-000605: {0} is not declared @Target(METHOD, FIELD, TYPE, PARAMETER), @Target(METHOD, TYPE), @Target(METHOD), @Target(TYPE) or @Target(FIELD). Weld will use this annotation, however this may make the application unportable.";
    }

    protected String unableToGetParameterName$str() {
        return "WELD-000606: Unable to determine name of parameter";
    }

    @Override
    public final IllegalArgumentException unableToGetParameterName() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.unableToGetParameterName$str(), new Object[0]));
        ReflectionLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }

    protected String annotationMapNull$str() {
        return "WELD-000607: annotationMap cannot be null";
    }

    @Override
    public final WeldException annotationMapNull() {
        WeldException result = new WeldException(String.format(this.getLoggingLocale(), this.annotationMapNull$str(), new Object[0]));
        ReflectionLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String declaredAnnotationMapNull$str() {
        return "WELD-000608: declaredAnnotationMap cannot be null";
    }

    @Override
    public final WeldException declaredAnnotationMapNull() {
        WeldException result = new WeldException(String.format(this.getLoggingLocale(), this.declaredAnnotationMapNull$str(), new Object[0]));
        ReflectionLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unableToGetConstructorOnDeserialization$str() {
        return "WELD-000610: Unable to deserialize constructor. Declaring class {0}, index {1}";
    }

    @Override
    public final WeldException unableToGetConstructorOnDeserialization(Object param1, Object param2, Throwable cause) {
        WeldException result = new WeldException(this._formatMessage(this.unableToGetConstructorOnDeserialization$str(), param1, param2), cause);
        ReflectionLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    private String _formatMessage(String format, Object ... args) {
        MessageFormat formatter = new MessageFormat(format, this.getLoggingLocale());
        return formatter.format(args, new StringBuffer(), new FieldPosition(0)).toString();
    }

    protected String unableToGetMethodOnDeserialization$str() {
        return "WELD-000611: Unable to deserialize method. Declaring class {0}, index {1}";
    }

    @Override
    public final WeldException unableToGetMethodOnDeserialization(Object param1, Object param2, Throwable cause) {
        WeldException result = new WeldException(this._formatMessage(this.unableToGetMethodOnDeserialization$str(), param1, param2), cause);
        ReflectionLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unableToGetFieldOnDeserialization$str() {
        return "WELD-000612: Unable to deserialize field. Declaring class {0}, field name {1}";
    }

    @Override
    public final WeldException unableToGetFieldOnDeserialization(Object param1, Object param2, Throwable cause) {
        WeldException result = new WeldException(this._formatMessage(this.unableToGetFieldOnDeserialization$str(), param1, param2), cause);
        ReflectionLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String incorrectNumberOfAnnotatedParametersMethod$str() {
        return "WELD-000614: Incorrect number of AnnotatedParameters {0} on AnnotatedMethod {1}. AnnotatedMethod has {2} as parameters but should have {3} as parameters";
    }

    @Override
    public final DefinitionException incorrectNumberOfAnnotatedParametersMethod(Object param1, Object param2, Object param3, Object param4) {
        DefinitionException result = new DefinitionException(this._formatMessage(this.incorrectNumberOfAnnotatedParametersMethod$str(), param1, param2, param3, param4));
        ReflectionLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String reflectionfactoryInstantiationFailed$str() {
        return "WELD-000616: Instantiation through ReflectionFactory of {0} failed";
    }

    @Override
    public final WeldException reflectionfactoryInstantiationFailed(Object param1, Throwable cause) {
        WeldException result = new WeldException(this._formatMessage(this.reflectionfactoryInstantiationFailed$str(), param1), cause);
        ReflectionLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unsafeInstantiationFailed$str() {
        return "WELD-000617: Instantiation through Unsafe of {0} failed";
    }

    @Override
    public final WeldException unsafeInstantiationFailed(Object param1, Throwable cause) {
        WeldException result = new WeldException(this._formatMessage(this.unsafeInstantiationFailed$str(), param1), cause);
        ReflectionLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void missingTargetMethodFieldParameterType(Object param1) {
        this.log.logv(FQCN, Logger.Level.DEBUG, (Throwable)null, this.missingTargetMethodFieldParameterType$str(), param1);
    }

    protected String missingTargetMethodFieldParameterType$str() {
        return "WELD-000620: {0} is not declared @Target(METHOD, FIELD, PARAMETER, TYPE). Weld will use this annotation, however this may make the application unportable.";
    }

    @Override
    public final void invalidInterceptorBindingTargetDeclaration(Object param1, Object param2, Object param3, Object param4) {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.invalidInterceptorBindingTargetDeclaration$str(), param1, param2, param3, param4);
    }

    protected String invalidInterceptorBindingTargetDeclaration$str() {
        return "WELD-000621: Interceptor binding {0} with @Target defined as {1} should not be applied on interceptor binding {2} with @Target definition: {3}";
    }

    protected String illegalArgumentExceptionOnReflectionInvocation$str() {
        return "WELD-000622: IllegalArgumentException invoking {2} on {1} ({0}) with parameters {3}";
    }

    @Override
    public final WeldException illegalArgumentExceptionOnReflectionInvocation(Class<?> clazz, Object instance, Method method, String parameters, Throwable cause) {
        WeldException result = new WeldException(this._formatMessage(this.illegalArgumentExceptionOnReflectionInvocation$str(), clazz, instance, method, parameters), cause);
        ReflectionLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unknownType$str() {
        return "WELD-000623: Unknown type {0}.";
    }

    @Override
    public final IllegalArgumentException unknownType(Type type) {
        IllegalArgumentException result = new IllegalArgumentException(this._formatMessage(this.unknownType$str(), type));
        ReflectionLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidTypeArgumentCombination$str() {
        return "WELD-000624: Invalid type argument combination: {0}; {1}.";
    }

    @Override
    public final IllegalArgumentException invalidTypeArgumentCombination(Type type1, Type type2) {
        IllegalArgumentException result = new IllegalArgumentException(this._formatMessage(this.invalidTypeArgumentCombination$str(), type1, type2));
        ReflectionLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String noSuchMethodWrapper$str() {
        return "WELD-000625: Unable to locate method: {0}";
    }

    @Override
    public final WeldException noSuchMethodWrapper(NoSuchMethodException cause, String message) {
        WeldException result = new WeldException(this._formatMessage(this.noSuchMethodWrapper$str(), message), cause);
        ReflectionLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void catchingDebug(Throwable throwable) {
        this.log.logf(FQCN, Logger.Level.DEBUG, throwable, this.catchingDebug$str(), new Object[0]);
    }

    protected String catchingDebug$str() {
        return "Catching";
    }
}

