/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.config.processor;

import com.sun.faces.application.ApplicationAssociate;
import com.sun.faces.config.manager.documents.DocumentInfo;
import com.sun.faces.config.processor.AbstractConfigProcessor;
import com.sun.faces.config.processor.FacesConfigNamespaceContext;
import com.sun.faces.util.FacesLogger;
import jakarta.faces.context.FacesContext;
import jakarta.servlet.ServletContext;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ResourceLibraryContractsConfigProcessor
extends AbstractConfigProcessor {
    private static final Logger LOGGER = FacesLogger.CONFIG.getLogger();
    private static final String RESOURCE_LIBRARY_CONTRACTS = "resource-library-contracts";

    @Override
    public void process(ServletContext servletContext, FacesContext facesContext, DocumentInfo[] documentInfos) throws Exception {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        for (DocumentInfo documentInfo : documentInfos) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, MessageFormat.format("Processing factory elements for document: ''{0}''", documentInfo.getSourceURI()));
            }
            Document document = documentInfo.getDocument();
            String namespace = document.getDocumentElement().getNamespaceURI();
            NodeList resourceLibraryContracts = document.getDocumentElement().getElementsByTagNameNS(namespace, RESOURCE_LIBRARY_CONTRACTS);
            if (resourceLibraryContracts == null || resourceLibraryContracts.getLength() <= 0) continue;
            this.processResourceLibraryContracts(resourceLibraryContracts, map);
        }
        if (!map.isEmpty()) {
            ApplicationAssociate associate = ApplicationAssociate.getCurrentInstance();
            associate.setResourceLibraryContracts(map);
        }
    }

    private void processResourceLibraryContracts(NodeList resourceLibraryContracts, HashMap<String, List<String>> map) {
        XPath xpath = XPathFactory.newInstance().newXPath();
        xpath.setNamespaceContext(new FacesConfigNamespaceContext());
        for (int c = 0; c < resourceLibraryContracts.getLength(); ++c) {
            Node node = resourceLibraryContracts.item(c);
            try {
                NodeList mappings = (NodeList)xpath.evaluate(".//ns1:contract-mapping", node, XPathConstants.NODESET);
                if (mappings == null) continue;
                for (int m = 0; m < mappings.getLength(); ++m) {
                    Node contractMapping = mappings.item(m);
                    NodeList urlPatterns = (NodeList)xpath.evaluate(".//ns1:url-pattern/text()", contractMapping, XPathConstants.NODESET);
                    if (urlPatterns == null) continue;
                    for (int p = 0; p < urlPatterns.getLength(); ++p) {
                        String urlPattern = urlPatterns.item(p).getNodeValue().trim();
                        if (LOGGER.isLoggable(Level.INFO)) {
                            LOGGER.log(Level.INFO, "Processing resource library contract mapping for url-pattern: {0}", urlPattern);
                        }
                        if (!map.containsKey(urlPattern)) {
                            ArrayList<String> list = new ArrayList<String>();
                            NodeList contracts = (NodeList)xpath.evaluate(".//ns1:contracts/text()", contractMapping, XPathConstants.NODESET);
                            if (contracts != null && contracts.getLength() > 0) {
                                for (int j = 0; j < contracts.getLength(); ++j) {
                                    String[] contractStrings;
                                    for (String contractString : contractStrings = contracts.item(j).getNodeValue().trim().split(",")) {
                                        if (!list.contains(contractString)) {
                                            if (LOGGER.isLoggable(Level.INFO)) {
                                                LOGGER.log(Level.INFO, "Added contract: {0} for url-pattern: {1}", new Object[]{contractString, urlPattern});
                                            }
                                            list.add(contractString);
                                            continue;
                                        }
                                        if (!LOGGER.isLoggable(Level.INFO)) continue;
                                        LOGGER.log(Level.INFO, "Duplicate contract: {0} found for url-pattern: {1}", new Object[]{contractString, urlPattern});
                                    }
                                }
                            }
                            if (!list.isEmpty()) {
                                map.put(urlPattern, list);
                                continue;
                            }
                            LOGGER.log(Level.INFO, "No contracts found for url-pattern: {0}", urlPattern);
                            continue;
                        }
                        LOGGER.log(Level.INFO, "Duplicate url-patern found: {0}, ignoring it", urlPattern);
                    }
                }
                continue;
            }
            catch (XPathExpressionException exception) {
                LOGGER.log(Level.FINEST, "Unable to parse XPath expression", exception);
            }
        }
    }
}

