/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.module.single;

import com.sun.enterprise.module.HK2Module;
import com.sun.enterprise.module.ModuleDefinition;
import com.sun.enterprise.module.ResolveError;
import com.sun.enterprise.module.common_impl.DefaultModuleDefinition;
import com.sun.enterprise.module.impl.ModulesRegistryImpl;
import com.sun.enterprise.module.single.ProxyModule;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;
import org.glassfish.hk2.api.ActiveDescriptor;
import org.glassfish.hk2.api.PopulatorPostProcessor;
import org.glassfish.hk2.api.ServiceLocator;

public class ClassPathBasedModulesRegistry
extends ModulesRegistryImpl {
    final ClassLoader cLoader;
    final List<ModuleDefinition> moduleDefs = new ArrayList<ModuleDefinition>();
    final List<HK2Module> modules = new ArrayList<HK2Module>();

    public ClassPathBasedModulesRegistry(ClassLoader singleCL, String classPath) throws IOException {
        super(null);
        this.cLoader = singleCL;
        this.setParentClassLoader(this.cLoader);
        StringTokenizer st = new StringTokenizer(classPath, File.pathSeparator);
        while (st.hasMoreTokens()) {
            String classPathElement = st.nextToken();
            File f = new File(classPathElement);
            if (!f.exists()) continue;
            DefaultModuleDefinition md = new DefaultModuleDefinition(f);
            this.moduleDefs.add(md);
            this.add(md);
        }
        for (ModuleDefinition md : this.moduleDefs) {
            this.modules.add(new ProxyModule(this, md, this.cLoader));
        }
    }

    @Override
    public HK2Module find(Class clazz) {
        HK2Module m = super.find(clazz);
        if (m == null) {
            return this.modules.get(0);
        }
        return m;
    }

    @Override
    public Collection<HK2Module> getModules(String moduleName) {
        return this.getModules();
    }

    @Override
    public Collection<HK2Module> getModules() {
        ArrayList<HK2Module> list = new ArrayList<HK2Module>();
        list.addAll(this.modules);
        return list;
    }

    @Override
    public HK2Module makeModuleFor(String name, String version, boolean resolve) throws ResolveError {
        for (int i = 0; i < this.moduleDefs.size(); ++i) {
            ModuleDefinition md = this.moduleDefs.get(i);
            if (!md.getName().equals(name)) continue;
            return this.modules.get(i);
        }
        return null;
    }

    @Override
    protected List<ActiveDescriptor> parseInhabitants(HK2Module module, String name, ServiceLocator serviceLocator, List<PopulatorPostProcessor> postProcessors) throws IOException {
        return null;
    }
}

