/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.lifecycle;

import com.sun.faces.lifecycle.Phase;
import com.sun.faces.util.FacesLogger;
import jakarta.faces.FacesException;
import jakarta.faces.component.UIViewRoot;
import jakarta.faces.context.FacesContext;
import jakarta.faces.event.PhaseId;
import java.util.logging.Level;
import java.util.logging.Logger;

public class InvokeApplicationPhase
extends Phase {
    private static Logger LOGGER = FacesLogger.LIFECYCLE.getLogger();

    @Override
    public void execute(FacesContext facesContext) throws FacesException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Entering InvokeApplicationsPhase");
        }
        UIViewRoot root = facesContext.getViewRoot();
        assert (null != root);
        try {
            root.processApplication(facesContext);
        }
        catch (RuntimeException re) {
            String exceptionMessage = re.getMessage();
            if (null != exceptionMessage && LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, exceptionMessage, re);
            }
            throw new FacesException(exceptionMessage, re);
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Exiting InvokeApplicationsPhase");
        }
    }

    @Override
    public PhaseId getId() {
        return PhaseId.INVOKE_APPLICATION;
    }
}

