/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server.pluggable;

import com.sun.enterprise.security.ssl.manager.UnifiedX509KeyManager;
import com.sun.enterprise.security.ssl.manager.UnifiedX509TrustManager;
import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.PropertyPermission;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import org.glassfish.api.admin.ProcessEnvironment;
import org.glassfish.logging.annotation.LogMessageInfo;
import org.glassfish.logging.annotation.LogMessagesResourceBundle;
import org.glassfish.logging.annotation.LoggerInfo;
import org.glassfish.security.common.MasterPassword;
import org.jvnet.hk2.annotations.Service;

@Service
@Singleton
public class SecuritySupport {
    public static final String KEY_STORE_PROP = "javax.net.ssl.keyStore";
    public static final String KEYSTORE_PASS_PROP = "javax.net.ssl.keyStorePassword";
    public static final String KEYSTORE_TYPE_PROP = "javax.net.ssl.keyStoreType";
    public static final String TRUST_STORE_PROP = "javax.net.ssl.trustStore";
    public static final String TRUSTSTORE_PASS_PROP = "javax.net.ssl.trustStorePassword";
    public static final String TRUSTSTORE_TYPE_PROP = "javax.net.ssl.trustStoreType";
    @LogMessagesResourceBundle
    private static final String SHARED_LOGMESSAGE_RESOURCE = "com.sun.enterprise.server.pluggable.LogMessages";
    @LoggerInfo(subsystem="SECURITY - SSL", description="Security - SSL", publish=true)
    private static final String SEC_SSL_LOGGER = "jakarta.enterprise.system.security.ssl";
    @LogMessageInfo(message="The SSL certificate with alias {0} has expired: {1}", level="SEVERE", cause="Certificate expired.", action="Check the expiration date of the certicate.")
    private static final String SSL_CERT_EXPIRED = "NCLS-SECURITY-05054";
    private static final Logger LOG = Logger.getLogger("jakarta.enterprise.system.security.ssl", "com.sun.enterprise.server.pluggable.LogMessages");
    private static final String DEFAULT_KEYSTORE_PASS = "changeit";
    private static final String DEFAULT_TRUSTSTORE_PASS = "changeit";
    private final List<KeyStore> keyStores = new ArrayList<KeyStore>();
    private final List<KeyStore> trustStores = new ArrayList<KeyStore>();
    private final List<char[]> keyStorePasswords = new ArrayList<char[]>();
    private final List<String> tokenNames = new ArrayList<String>();
    private final Date initDate = new Date();
    @Inject
    private ProcessEnvironment processEnvironment;
    @Inject
    private MasterPassword masterPassword;

    @PostConstruct
    private void init() {
        char[] keyStorePass;
        String keyStoreFileName = System.getProperty(KEY_STORE_PROP);
        String trustStoreFileName = System.getProperty(TRUST_STORE_PROP);
        char[] trustStorePass = keyStorePass = this.masterPassword.getMasterPassword();
        boolean isAcc = this.processEnvironment.getProcessType().equals((Object)ProcessEnvironment.ProcessType.ACC);
        if (keyStorePass == null || isAcc) {
            String trustStorePassOverride;
            String keyStorePassOverride = System.getProperty(KEYSTORE_PASS_PROP, "changeit");
            if (keyStorePassOverride != null) {
                keyStorePass = keyStorePassOverride.toCharArray();
            }
            if ((trustStorePassOverride = System.getProperty(TRUSTSTORE_PASS_PROP, "changeit")) != null) {
                trustStorePass = trustStorePassOverride.toCharArray();
            }
        }
        this.loadStores(null, null, keyStoreFileName, keyStorePass, System.getProperty(KEYSTORE_TYPE_PROP, KeyStore.getDefaultType()), trustStoreFileName, trustStorePass, System.getProperty(TRUSTSTORE_TYPE_PROP, KeyStore.getDefaultType()));
        Arrays.fill(keyStorePass, ' ');
        Arrays.fill(trustStorePass, ' ');
    }

    public KeyStore[] getKeyStores() {
        return this.keyStores.toArray(new KeyStore[this.keyStores.size()]);
    }

    public KeyStore[] getTrustStores() {
        return this.trustStores.toArray(new KeyStore[this.trustStores.size()]);
    }

    public KeyStore getKeyStore(String token) {
        int idx = this.getTokenIndex(token);
        if (idx < 0) {
            return null;
        }
        return this.keyStores.get(idx);
    }

    public KeyStore getTrustStore(String token) {
        int idx = this.getTokenIndex(token);
        if (idx < 0) {
            return null;
        }
        return this.trustStores.get(idx);
    }

    public KeyStore loadNullStore(String type, int index) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        KeyStore keyStore = KeyStore.getInstance(type);
        keyStore.load(null, this.keyStorePasswords.get(index));
        return keyStore;
    }

    public boolean verifyMasterPassword(char[] masterPass) {
        return Arrays.equals(masterPass, this.keyStorePasswords.get(0));
    }

    public KeyManager[] getKeyManagers(String algorithm) throws IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        KeyStore[] kstores = this.getKeyStores();
        ArrayList<KeyManager> keyManagers = new ArrayList<KeyManager>();
        for (int i = 0; i < kstores.length; ++i) {
            SecuritySupport.checkCertificateDates(kstores[i], this.initDate);
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(algorithm != null ? algorithm : KeyManagerFactory.getDefaultAlgorithm());
            kmf.init(kstores[i], this.keyStorePasswords.get(i));
            KeyManager[] kmgrs = kmf.getKeyManagers();
            if (kmgrs == null) continue;
            keyManagers.addAll(Arrays.asList(kmgrs));
        }
        UnifiedX509KeyManager keyManager = new UnifiedX509KeyManager(keyManagers.toArray(new X509KeyManager[keyManagers.size()]), this.getTokenNames());
        return new KeyManager[]{keyManager};
    }

    public TrustManager[] getTrustManagers(String algorithm) throws IOException, KeyStoreException, NoSuchAlgorithmException {
        KeyStore[] tstores = this.getTrustStores();
        ArrayList<TrustManager> trustManagers = new ArrayList<TrustManager>();
        for (KeyStore tstore : tstores) {
            SecuritySupport.checkCertificateDates(tstore, this.initDate);
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(algorithm != null ? algorithm : TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(tstore);
            TrustManager[] tmgrs = tmf.getTrustManagers();
            if (tmgrs == null) continue;
            trustManagers.addAll(Arrays.asList(tmgrs));
        }
        TrustManager trustManager = trustManagers.size() == 1 ? (TrustManager)trustManagers.get(0) : new UnifiedX509TrustManager(trustManagers.toArray(new X509TrustManager[trustManagers.size()]));
        return new TrustManager[]{trustManager};
    }

    public PrivateKey getPrivateKeyForAlias(String alias, int keystoreIndex) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        Key key;
        if (this.processEnvironment.getProcessType().isStandaloneServer()) {
            this.checkPermission(KEYSTORE_PASS_PROP);
        }
        if ((key = this.keyStores.get(keystoreIndex).getKey(alias, this.keyStorePasswords.get(keystoreIndex))) instanceof PrivateKey) {
            return (PrivateKey)key;
        }
        return null;
    }

    public String[] getTokenNames() {
        return this.tokenNames.toArray(new String[this.tokenNames.size()]);
    }

    private void checkPermission(String key) {
        try {
            RuntimePermission perm = new RuntimePermission("SSLPassword");
            AccessController.checkPermission(perm);
        }
        catch (AccessControlException e) {
            String message = e.getMessage();
            PropertyPermission perm = new PropertyPermission(key, "read");
            if (message != null) {
                message = message.replace(e.getPermission().toString(), perm.toString());
            }
            throw new AccessControlException(message, perm);
        }
    }

    private int getTokenIndex(String token) {
        int idx = -1;
        if (token != null && (idx = this.tokenNames.indexOf(token)) < 0) {
            LOG.log(Level.FINEST, "Token {0} not found", token);
        }
        return idx;
    }

    private void loadStores(String tokenName, Provider provider, String keyStoreFile, char[] keyStorePass, String keyStoreType, String trustStoreFile, char[] trustStorePass, String trustStoreType) {
        try {
            KeyStore keyStore = SecuritySupport.loadKS(keyStoreType, provider, keyStoreFile, keyStorePass);
            KeyStore trustStore = SecuritySupport.loadKS(trustStoreType, provider, trustStoreFile, trustStorePass);
            this.keyStores.add(keyStore);
            this.trustStores.add(trustStore);
            this.keyStorePasswords.add(Arrays.copyOf(keyStorePass, keyStorePass.length));
            this.tokenNames.add(tokenName);
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
    }

    private static KeyStore loadKS(String keyStoreType, Provider provider, String keyStoreFile, char[] keyStorePass) throws Exception {
        KeyStore keyStore = provider == null ? KeyStore.getInstance(keyStoreType) : KeyStore.getInstance(keyStoreType, provider);
        if (keyStoreFile == null) {
            keyStore.load(null, keyStorePass);
            return keyStore;
        }
        try (FileInputStream istream = new FileInputStream(keyStoreFile);
             BufferedInputStream bstream = new BufferedInputStream(istream);){
            LOG.log(Level.FINE, "Loading keystoreFile = {0}, keystorePass is null = {1}", new Object[]{keyStoreFile, keyStorePass == null});
            keyStore.load(bstream, keyStorePass);
        }
        return keyStore;
    }

    private static void checkCertificateDates(KeyStore store, Date date) throws KeyStoreException {
        Enumeration<String> aliases = store.aliases();
        while (aliases.hasMoreElements()) {
            String alias = aliases.nextElement();
            Certificate cert = store.getCertificate(alias);
            if (!(cert instanceof X509Certificate) || !((X509Certificate)cert).getNotAfter().before(date)) continue;
            LOG.log(Level.SEVERE, SSL_CERT_EXPIRED, new Object[]{alias, cert});
        }
    }
}

